/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.network.message;

import io.netty.buffer.ByteBuf;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import teamroots.embers.particle.ParticleUtil;

public class MessageCannonBeamFX
implements IMessage {
    public static Random random = new Random();
    double posX = 0.0;
    double posY = 0.0;
    double posZ = 0.0;
    double dX = 0.0;
    double dY = 0.0;
    double dZ = 0.0;
    double hitDistance = Double.POSITIVE_INFINITY;
    int packedColor;

    public MessageCannonBeamFX() {
    }

    public MessageCannonBeamFX(double x, double y, double z, double dX, double dY, double dZ, double hitDistance, int packedColor) {
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.dX = dX;
        this.dY = dY;
        this.dZ = dZ;
        this.hitDistance = hitDistance;
        this.packedColor = packedColor;
    }

    public void fromBytes(ByteBuf buf) {
        this.posX = buf.readDouble();
        this.posY = buf.readDouble();
        this.posZ = buf.readDouble();
        this.dX = buf.readDouble();
        this.dY = buf.readDouble();
        this.dZ = buf.readDouble();
        this.hitDistance = buf.readDouble();
        this.packedColor = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
        buf.writeDouble(this.dX);
        buf.writeDouble(this.dY);
        buf.writeDouble(this.dZ);
        buf.writeDouble(this.hitDistance);
        buf.writeInt(this.packedColor);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageCannonBeamFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageCannonBeamFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            Minecraft.func_71410_x().func_152344_a(() -> MessageHolder.lambda$onMessage$0(message, (World)world));
            return null;
        }

        private static /* synthetic */ void lambda$onMessage$0(MessageCannonBeamFX message, World world) {
            double distance = Math.sqrt(message.dX * message.dX + message.dY * message.dY + message.dZ * message.dZ);
            double segments = distance * 4.0;
            Color color = new Color(message.packedColor, true);
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            for (double i = 0.0; i < segments; i += 1.0) {
                for (int j = 0; j < 5; ++j) {
                    message.posX += 0.2 * message.dX / segments;
                    message.posY += 0.2 * message.dY / segments;
                    message.posZ += 0.2 * message.dZ / segments;
                    ParticleUtil.spawnParticleGlow(world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.0f, 0.0f, 0.0f, r, g, b, 2.0f, 24);
                }
                if (!(i > message.hitDistance * 4.0)) continue;
                for (int k = 0; k < 80; ++k) {
                    ParticleUtil.spawnParticleGlow(world, (float)message.posX, (float)message.posY, (float)message.posZ, 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), 0.125f * (random.nextFloat() - 0.5f), r, g, b, 2.0f, 24);
                }
                break;
            }
        }
    }
}

