/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import teamroots.embers.ConfigManager;
import teamroots.embers.api.EmbersAPI;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierProjectileBase;
import teamroots.embers.api.projectile.IProjectilePreset;
import teamroots.embers.api.projectile.ProjectileFireball;
import teamroots.embers.api.projectile.ProjectileRay;

public class ModifierFocalLens
extends ModifierProjectileBase {
    public ModifierFocalLens() {
        super("focal_lens", 10.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onProjectileFire(EmberProjectileEvent event) {
        ListIterator<IProjectilePreset> projectiles = event.getProjectiles().listIterator();
        ItemStack weapon = event.getStack();
        if (!weapon.func_190926_b() && ItemModUtil.hasHeat(weapon)) {
            int level = ItemModUtil.getModifierLevel(weapon, EmbersAPI.FOCAL_LENS);
            int index = 0;
            int modulo = 1 + (level - 1) * 2;
            if (level > 0) {
                while (projectiles.hasNext()) {
                    IProjectilePreset projectile = projectiles.next();
                    if (projectile instanceof ProjectileRay) {
                        ((ProjectileRay)projectile).setPierceEntities(true);
                    } else if (projectile instanceof ProjectileFireball) {
                        ((ProjectileFireball)projectile).setHoming(level * 10, 4.0 + (double)level * 1.0, index, modulo, (Predicate<Entity>)Predicates.and((Predicate[])new Predicate[]{EntitySelectors.field_180132_d, EntitySelectors.field_94557_a, entity -> {
                            Entity shooter = projectile.getShooter();
                            if (!(entity instanceof EntityLivingBase)) {
                                return false;
                            }
                            if (shooter != null && entity.func_184191_r(shooter)) {
                                return false;
                            }
                            if (entity instanceof EntityPlayer && shooter instanceof EntityPlayer && !ModifierFocalLens.isPVPEnabled(entity.func_130014_f_())) {
                                return false;
                            }
                            return entity.func_70067_L() && shooter != entity;
                        }}));
                    }
                    ++index;
                }
            }
        }
    }

    public static boolean isPVPEnabled(World world) {
        MinecraftServer server = world.func_73046_m();
        return server != null && server.func_71219_W() && ConfigManager.pvpEverybodyIsEnemy;
    }
}

