/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.api.filter.IFilterComparator;
import teamroots.embers.gui.ContainerEye;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEyeButton;
import teamroots.embers.util.Vec2i;

public class GuiEye
extends GuiContainer {
    private static final ResourceLocation guiLocation = new ResourceLocation("embers", "textures/gui/eye_gui.png");

    public GuiEye(EntityPlayer player) {
        super((Container)new ContainerEye(player));
        this.field_146999_f = 176;
        this.field_147000_g = 205;
    }

    private Vec2i getButton(float angle) {
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        return ((ContainerEye)this.field_147002_h).getButtonPosition(xPos, yPos, angle);
    }

    private Vec2i getFinish() {
        return this.getButton(180.0f);
    }

    private Vec2i getLeft() {
        return this.getButton(140.0f);
    }

    private Vec2i getRight() {
        return this.getButton(-140.0f);
    }

    private Vec2i getInvert() {
        return this.getButton(-40.0f);
    }

    private Vec2i getFlag() {
        return this.getButton(40.0f);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isOnButton(mouseX, mouseY, this.getFinish())) {
            this.triggerButton(ContainerEye.EnumButton.FINISH);
        } else if (this.isOnButton(mouseX, mouseY, this.getLeft())) {
            this.triggerButton(ContainerEye.EnumButton.LEFT);
        } else if (this.isOnButton(mouseX, mouseY, this.getRight())) {
            this.triggerButton(ContainerEye.EnumButton.RIGHT);
        } else if (this.isOnButton(mouseX, mouseY, this.getInvert())) {
            this.triggerButton(ContainerEye.EnumButton.INVERT);
        } else if (this.isOnButton(mouseX, mouseY, this.getFlag())) {
            this.triggerButton(ContainerEye.EnumButton.FLAG);
        } else {
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    private void triggerButton(ContainerEye.EnumButton button) {
        PacketHandler.INSTANCE.sendToServer((IMessage)new MessageEyeButton(button));
    }

    protected void func_191948_b(int mouseX, int mouseY) {
        Slot slot = this.getSlotUnderMouse();
        ContainerEye container = (ContainerEye)this.field_147002_h;
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        if (this.isOnButton(mouseX, mouseY, this.getFinish())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Finish"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        } else if (this.isOnButton(mouseX, mouseY, this.getLeft())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Previous"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        } else if (this.isOnButton(mouseX, mouseY, this.getRight())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Next"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        } else if (this.isOnButton(mouseX, mouseY, this.getInvert())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Invert"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        } else if (this.isOnButton(mouseX, mouseY, this.getFlag())) {
            ArrayList tooltip = Lists.newArrayList((Object[])new String[]{"Flag"});
            this.drawHoveringText(tooltip, mouseX, mouseY, this.field_146289_q);
        } else {
            super.func_191948_b(mouseX, mouseY);
        }
    }

    private boolean isOnButton(int mouseX, int mouseY, Vec2i button) {
        return mouseX >= button.x - 16 && mouseX < button.x + 16 && mouseY >= button.y - 16 && mouseY < button.y + 16;
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiLocation);
        int xPos = (this.field_146294_l - this.field_146999_f) / 2;
        int yPos = (this.field_146295_m - this.field_147000_g) / 2;
        int yInventory = yPos + this.field_147000_g - 85;
        this.func_73729_b(xPos, yInventory, 0, 0, this.field_146999_f, 85);
        int textWidth = 212;
        int textHeight = 33;
        int textX = xPos + (this.field_146999_f - textWidth) / 2;
        int textY = yInventory - textHeight;
        this.func_73729_b(textX, textY, 0, 86, 212, 33);
        ContainerEye eye = (ContainerEye)this.field_147002_h;
        IFilterComparator comparator = eye.comparator;
        if (comparator != null) {
            ItemStack left = eye.filterInventory.func_70301_a(0);
            ItemStack right = eye.filterInventory.func_70301_a(1);
            GuiCodex.drawCenteredTextGlowing(this.field_146289_q, comparator.format(left, right, eye.flag, eye.inverted), textX + textWidth / 2, textY + textHeight / 2 - 4);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(guiLocation);
        this.drawButton(xPos, yPos, 180.0f, false, 176, 32);
        this.drawButton(xPos, yPos, 140.0f, false, 176, 16);
        this.drawButton(xPos, yPos, -140.0f, false, 192, 16);
        this.drawButton(xPos, yPos, 90.0f, true, 0, 0);
        this.drawButton(xPos, yPos, -90.0f, true, 0, 0);
        this.drawButton(xPos, yPos, -40.0f, false, 208, 16);
        this.drawButton(xPos, yPos, 40.0f, false, 224, 16);
        int xCenter = xPos + 88;
        int yCenter = yPos + 85 - 50;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)xCenter, (float)yCenter, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)0.0f);
        this.func_73729_b(-8, -8, 176, 0, 16, 16);
        GlStateManager.func_179121_F();
    }

    private void drawButton(int xPos, int yPos, float angle, boolean itemSlot, int u, int v) {
        Vec2i button = ((ContainerEye)this.field_147002_h).getButtonPosition(xPos, yPos, angle);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)button.x, (float)button.y, (float)0.0f);
        GlStateManager.func_179114_b((float)(-angle), (float)0.0f, (float)0.0f, (float)1.0f);
        this.func_73729_b(-24, -24, 0, 119, 48, 48);
        GlStateManager.func_179121_F();
        if (itemSlot) {
            this.func_73729_b(button.x - 24, button.y - 24, 48, 119, 48, 48);
        } else {
            this.func_73729_b(button.x - 8, button.y - 8, u, v, 16, 16);
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

