/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity.magmaworm;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.entity.magmaworm.Down;

public class DownAggressive
extends Down {
    private static final double RANGE_ATTACK = 36.0;
    private double velocity = 0.5;

    public DownAggressive(MagmaWormPhase.PhaseSupplier supplier) {
        super(supplier);
    }

    @Override
    public double getVelocity(EntityMagmaWorm worm) {
        if (worm.isDigging()) {
            return 0.5;
        }
        return this.velocity;
    }

    @Override
    public void onUpdate(EntityMagmaWorm worm) {
        this.velocity = Math.min(2.0, this.velocity + 0.05);
    }

    @Override
    protected Vec3d getTarget(EntityMagmaWorm worm) {
        List<Entity> targets = worm.getAttackTargets(new AxisAlignedBB(worm.field_70165_t - 36.0, worm.field_70163_u - 36.0, worm.field_70161_v - 36.0, worm.field_70165_t + 36.0, worm.field_70163_u + 36.0, worm.field_70161_v + 36.0));
        if (!targets.isEmpty()) {
            Entity target = targets.get(this.random.nextInt(targets.size()));
            double bottom = MagmaWormPhase.getHeight(target.field_70170_p, target.field_70165_t, target.field_70161_v) - 10.0;
            return new Vec3d(target.field_70165_t, bottom, target.field_70161_v);
        }
        return super.getTarget(worm);
    }
}

