/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import teamroots.embers.entity.EntityMagmaProjectile;
import teamroots.embers.entity.EntityMagmaWorm;
import teamroots.embers.entity.magmaworm.Burrow;
import teamroots.embers.entity.magmaworm.Down;
import teamroots.embers.entity.magmaworm.DownAggressive;
import teamroots.embers.entity.magmaworm.DownSeism;
import teamroots.embers.entity.magmaworm.DownStuck;
import teamroots.embers.entity.magmaworm.Homing;
import teamroots.embers.entity.magmaworm.Lunge;
import teamroots.embers.entity.magmaworm.Mortar;
import teamroots.embers.entity.magmaworm.Pillars;
import teamroots.embers.entity.magmaworm.Start;
import teamroots.embers.entity.magmaworm.Up;
import teamroots.embers.entity.magmaworm.UpAggressive;

public class MagmaWormPhase {
    public static final PhaseSupplier START = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Start(this);
        }
    };
    public static final PhaseSupplier DOWN = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Down(this);
        }
    };
    public static final PhaseSupplier DOWN_AGGRESSIVE = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new DownAggressive(this);
        }
    };
    public static final PhaseSupplier DOWN_SEISM = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new DownSeism(this);
        }
    };
    public static final PhaseSupplier DOWN_STUCK = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new DownStuck(this);
        }
    };
    public static final PhaseSupplier UP = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Up(this);
        }
    };
    public static final PhaseSupplier UP_AGGRESSIVE = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new UpAggressive(this);
        }
    };
    public static final PhaseSupplier BURROW = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Burrow(this);
        }
    };
    public static final PhaseSupplier MORTAR = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Mortar(this);
        }
    };
    public static final PhaseSupplier PILLARS = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Pillars(this);
        }
    };
    public static final PhaseSupplier HOMING = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Homing(this);
        }
    };
    public static final PhaseSupplier BURROW_AGGRESSIVE = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Lunge(this, 1);
        }
    };
    public static final PhaseSupplier BURROW_CHASE = new PhaseSupplier(){

        @Override
        public MagmaWormPhase get() {
            return new Lunge(this, 3);
        }
    };
    protected final PhaseSupplier supplier;
    protected Random random = new Random();

    public MagmaWormPhase(PhaseSupplier supplier) {
        this.supplier = supplier;
    }

    public static double getHeight(World world, double x, double z) {
        return world.func_189649_b((int)x, (int)z);
    }

    public MagmaWormPhase pickFollowup(Random random) {
        return this.supplier.pickFollowup(random).get();
    }

    public double getVelocity(EntityMagmaWorm worm) {
        if (worm.isDigging()) {
            return 0.5;
        }
        return 1.0;
    }

    public void onStart(EntityMagmaWorm worm) {
    }

    public void onInterrupt(EntityMagmaWorm worm) {
    }

    public void onEnd(EntityMagmaWorm worm) {
    }

    public void onUpdate(EntityMagmaWorm worm) {
    }

    public void onDig(EntityMagmaWorm worm) {
    }

    public void onUndig(EntityMagmaWorm worm) {
    }

    public static void splashMagma(EntityMagmaWorm worm, Vec3d location, int splashes) {
        for (int i = 0; i < splashes; ++i) {
            Vec3d velocity = Vec3d.func_189986_a((float)(-45.0f + worm.random.nextFloat() * 30.0f - 15.0f), (float)(worm.random.nextFloat() * 360.0f)).func_186678_a((double)0.3f);
            EntityMagmaProjectile projectile = new EntityMagmaProjectile(worm.field_70170_p, worm);
            projectile.func_70107_b(location.field_72450_a, location.field_72448_b, location.field_72449_c);
            projectile.makeSplash(velocity);
            worm.field_70170_p.func_72838_d((Entity)projectile);
        }
    }

    static {
        MagmaWormPhase.START.followups.add(DOWN);
        MagmaWormPhase.UP.followups.add(DOWN);
        MagmaWormPhase.UP.followups.add(DOWN_STUCK);
        MagmaWormPhase.UP.followups.add(DOWN_AGGRESSIVE);
        MagmaWormPhase.UP.followups.add(DOWN_SEISM);
        MagmaWormPhase.UP.followups.add(MORTAR);
        MagmaWormPhase.UP.followups.add(HOMING);
        MagmaWormPhase.UP.followups.add(PILLARS);
        MagmaWormPhase.UP_AGGRESSIVE.followups.add(DOWN);
        MagmaWormPhase.UP_AGGRESSIVE.followups.add(DOWN_AGGRESSIVE);
        MagmaWormPhase.UP_AGGRESSIVE.followups.add(HOMING);
        MagmaWormPhase.DOWN.followups.add(UP);
        MagmaWormPhase.DOWN.followups.add(UP_AGGRESSIVE);
        MagmaWormPhase.DOWN.followups.add(BURROW);
        MagmaWormPhase.DOWN.followups.add(BURROW_AGGRESSIVE);
        MagmaWormPhase.DOWN.followups.add(BURROW_CHASE);
        MagmaWormPhase.DOWN.followups.add(PILLARS);
        MagmaWormPhase.DOWN_AGGRESSIVE.followups.add(UP);
        MagmaWormPhase.DOWN_AGGRESSIVE.followups.add(UP_AGGRESSIVE);
        MagmaWormPhase.DOWN_SEISM.followups.add(UP);
        MagmaWormPhase.DOWN_STUCK.followups.add(UP);
        MagmaWormPhase.BURROW.followups.add(UP);
        MagmaWormPhase.BURROW.followups.add(BURROW_AGGRESSIVE);
        MagmaWormPhase.BURROW.followups.add(MORTAR);
        MagmaWormPhase.BURROW.followups.add(PILLARS);
        MagmaWormPhase.BURROW_AGGRESSIVE.followups.add(UP);
        MagmaWormPhase.BURROW_CHASE.followups.add(UP);
        MagmaWormPhase.MORTAR.followups.add(DOWN);
        MagmaWormPhase.PILLARS.followups.add(DOWN_SEISM);
        MagmaWormPhase.HOMING.followups.add(BURROW);
        MagmaWormPhase.HOMING.followups.add(DOWN);
    }

    public static abstract class PhaseSupplier {
        public List<PhaseSupplier> followups = new ArrayList<PhaseSupplier>();

        public abstract MagmaWormPhase get();

        public PhaseSupplier pickFollowup(Random random) {
            return this.followups.get(random.nextInt(this.followups.size()));
        }
    }
}

