/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.DoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import teamroots.embers.entity.MagmaWormPhase;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.ExtraSerializers;
import teamroots.embers.util.Misc;
import teamroots.embers.util.Spline;

public class EntityMagmaWorm
extends EntityFlying
implements IEntityMultiPart {
    public static final int RANGE_ATTACK = 72;
    public ArrayList<Vec3d> pastPositions = new ArrayList();
    public ArrayList<Vec3d> pastPositionsLast = new ArrayList();
    public MultiPartEntityPart[] wormPartArray;
    public static final DataParameter<Float> targetDirectionX = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Float> targetDirectionY = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187193_c);
    public static final DataParameter<Boolean> pacified = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Boolean> tracking = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<Integer> fadeTimer = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> segments = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<float[]> segmentFade = EntityDataManager.func_187226_a(EntityMagmaWorm.class, ExtraSerializers.FLOAT_ARRAY);
    public static final DataParameter<Boolean> digging = EntityDataManager.func_187226_a(EntityMagmaWorm.class, (DataSerializer)DataSerializers.field_187198_h);
    Random random = new Random();
    Spline currentSpline;
    double distMoved;
    double splineInterval;
    double pastPositionDistance;
    MagmaWormPhase currentPhase;
    public Vec3d moveVec = new Vec3d(0.0, 0.0, 0.0);
    public static SoundEvent ambientSound;
    public static SoundEvent hurtSound;
    public static SoundEvent departureSound;
    private final BossInfoServer bossInfo = (BossInfoServer)new BossInfoServer(this.func_145748_c_(), BossInfo.Color.GREEN, BossInfo.Overlay.PROGRESS).func_186741_a(true);

    public void setCurrentSpline(DoubleFunction<Vec3d> spline, int segments, double splineInterval) {
        this.moveVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.currentSpline = new Spline(spline);
        this.currentSpline.cachePoints(segments, 1.0, 1.0);
        this.splineInterval = this.currentSpline.getTotalArcLength() * splineInterval;
        this.distMoved = 0.0;
    }

    public void setCurrentSpline(Spline spline, double splineInterval) {
        this.moveVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.currentSpline = spline;
        this.splineInterval = splineInterval;
        this.distMoved = 0.0;
    }

    public void setSegmentFade(int index, float fade) {
        float[] value = (float[])this.func_184212_Q().func_187225_a(segmentFade);
        if (value[index] == fade) {
            return;
        }
        value[index] = fade;
        this.func_184212_Q().func_187227_b(segmentFade, (Object)value);
        this.func_184212_Q().func_187217_b(segmentFade);
    }

    public float getSegmentFade(int index) {
        float[] value = (float[])this.func_184212_Q().func_187225_a(segmentFade);
        return value[index];
    }

    public void setSegments(int n) {
        this.func_184212_Q().func_187227_b(segments, (Object)n);
        this.func_184212_Q().func_187217_b(segments);
    }

    public int getSegments() {
        return (Integer)this.func_184212_Q().func_187225_a(segments);
    }

    public void setDigging(boolean flag) {
        this.func_184212_Q().func_187227_b(digging, (Object)flag);
        this.func_184212_Q().func_187217_b(digging);
    }

    public boolean isDigging() {
        return (Boolean)this.func_184212_Q().func_187225_a(digging);
    }

    @Nullable
    public Entity[] func_70021_al() {
        return this.wormPartArray;
    }

    public EntityMagmaWorm(World worldIn) {
        super(worldIn);
        int i;
        this.func_70105_a(2.0f, 2.0f);
        this.field_70145_X = true;
        this.field_70160_al = true;
        this.field_70728_aV = 20;
        int segments = this.getSegments();
        for (i = 0; i < segments * 2; ++i) {
            this.pastPositions.add(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            this.pastPositionsLast.add(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        }
        this.wormPartArray = new MultiPartEntityPart[segments];
        for (i = 0; i < segments; ++i) {
            this.wormPartArray[i] = new MultiPartEntityPart((IEntityMultiPart)this, "tail", 2.0f, 2.0f);
        }
        this.field_70177_z = this.field_70146_Z.nextInt(240) + 60;
    }

    public boolean func_184222_aU() {
        return false;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(pacified, (Object)false);
        this.func_184212_Q().func_187214_a(tracking, (Object)false);
        this.func_184212_Q().func_187214_a(targetDirectionX, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(targetDirectionY, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(fadeTimer, (Object)0);
        this.func_184212_Q().func_187214_a(segments, (Object)15);
        this.func_184212_Q().func_187214_a(segmentFade, (Object)new float[15]);
        this.func_184212_Q().func_187214_a(digging, (Object)false);
    }

    public void func_82167_n(Entity entity) {
        if (this.func_70638_az() != null && this.func_110143_aJ() > 0.0f && !((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue() && entity.func_110124_au().compareTo(this.func_70638_az().func_110124_au()) == 0 && entity instanceof EntityLivingBase) {
            EntityLivingBase living = (EntityLivingBase)entity;
            if (Misc.isCreativePlayer(living)) {
                return;
            }
            living.func_70097_a(DamageSource.field_76377_j, 4.0f);
            float magnitude = (float)Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
            living.func_70653_a((Entity)this, 3.0f * magnitude + 0.1f, -this.field_70159_w / (double)magnitude + 0.1, -this.field_70179_y / (double)magnitude + 0.1);
            living.func_70652_k((Entity)this);
            living.func_70604_c((EntityLivingBase)this);
        }
    }

    public void func_70619_bc() {
        super.func_70619_bc();
    }

    public Vec3d getSegmentPosition(int index, float partialTicks) {
        Vec3d pos1 = this.pastPositionsLast.get(index);
        Vec3d pos2 = this.pastPositions.get(index);
        return new Vec3d(MathHelper.func_151238_b((double)pos1.field_72450_a, (double)pos2.field_72450_a, (double)partialTicks), MathHelper.func_151238_b((double)pos1.field_72448_b, (double)pos2.field_72448_b, (double)partialTicks), MathHelper.func_151238_b((double)pos1.field_72449_c, (double)pos2.field_72449_c, (double)partialTicks));
    }

    public Vec3d getHeadPosition(float partialTicks) {
        return new Vec3d(MathHelper.func_151238_b((double)this.field_70169_q, (double)this.field_70165_t, (double)partialTicks), MathHelper.func_151238_b((double)this.field_70167_r, (double)this.field_70163_u, (double)partialTicks), MathHelper.func_151238_b((double)this.field_70166_s, (double)this.field_70161_v, (double)partialTicks));
    }

    public void setPhase(MagmaWormPhase phase, boolean interrupt) {
        if (this.currentPhase != null) {
            if (interrupt) {
                this.currentPhase.onInterrupt(this);
            } else {
                this.currentPhase.onEnd(this);
            }
        }
        this.currentPhase = phase;
        this.currentPhase.onStart(this);
    }

    public List<Entity> getAttackTargets(AxisAlignedBB aabb) {
        return this.field_70170_p.func_72872_a(EntityPlayer.class, aabb);
    }

    public void func_70071_h_() {
        int i;
        if (!this.field_70170_p.field_72995_K) {
            if (this.currentPhase == null) {
                this.setPhase(MagmaWormPhase.START.get(), false);
            } else if (this.distMoved >= this.currentSpline.getTotalArcLength()) {
                MagmaWormPhase phase = this.currentPhase.pickFollowup(this.random);
                this.setPhase(phase, false);
            }
        }
        super.func_70071_h_();
        for (int i2 = 0; i2 < this.pastPositions.size(); ++i2) {
            this.pastPositionsLast.set(i2, this.pastPositions.get(i2));
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.func_70106_y();
            return;
        }
        float velocityScale = 0.7f;
        float addedMotionY = 0.0f;
        if (((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue() && (Integer)this.func_184212_Q().func_187225_a(fadeTimer) > 0) {
            this.func_184212_Q().func_187227_b(fadeTimer, (Object)((Integer)this.func_184212_Q().func_187225_a(fadeTimer) - 1));
            this.func_184212_Q().func_187217_b(fadeTimer);
        }
        if ((Integer)this.func_184212_Q().func_187225_a(fadeTimer) > 0) {
            for (i = 0; i < 5; ++i) {
                Vec3d location = this.pastPositions.get(this.field_70146_Z.nextInt(20)).func_178787_e(new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5).func_186678_a(3.0));
                ParticleUtil.spawnParticleGlowThroughBlocks(this.func_130014_f_(), (float)location.field_72450_a, (float)location.field_72448_b + 1.35f, (float)location.field_72449_c, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
            }
        }
        if ((Integer)this.func_184212_Q().func_187225_a(fadeTimer) == 0 && ((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue()) {
            for (i = 0; i < this.getSegments(); ++i) {
                Vec3d location;
                int j;
                for (j = 0; j < 5; ++j) {
                    location = this.pastPositions.get(i).func_178787_e(new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5).func_186678_a(3.0));
                    ParticleUtil.spawnParticleGlowThroughBlocks(this.func_130014_f_(), (float)location.field_72450_a, (float)location.field_72448_b + 1.35f, (float)location.field_72449_c, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
                for (j = 0; j < 2; ++j) {
                    location = this.pastPositions.get(i).func_178787_e(new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5).func_186678_a(1.5));
                    ParticleUtil.spawnParticleGlowThroughBlocks(this.func_130014_f_(), (float)location.field_72450_a, (float)location.field_72448_b + 1.35f, (float)location.field_72449_c, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
            }
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            for (i = 0; i < Math.max(this.getSegments() - 2, 0); ++i) {
                Vec3d location;
                Vec3d velocity;
                int j;
                for (j = 0; j < 5; ++j) {
                    velocity = Vec3d.func_189986_a((float)(this.field_70146_Z.nextFloat() * 360.0f), (float)(this.field_70146_Z.nextFloat() * 360.0f)).func_186678_a((double)0.2f);
                    location = this.pastPositions.get(i).func_178787_e(new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5).func_186678_a(3.0).func_186678_a(0.0));
                    ParticleUtil.spawnParticleGlow(this.func_130014_f_(), (float)location.field_72450_a, (float)location.field_72448_b + 1.35f, (float)location.field_72449_c, (float)velocity.field_72450_a, (float)velocity.field_72448_b, (float)velocity.field_72449_c, 1.0f, 0.25f, 0.06f, 1.0f, 3.0f, 20);
                }
                for (j = 0; j < 2; ++j) {
                    velocity = Vec3d.func_189986_a((float)(this.field_70146_Z.nextFloat() * 360.0f), (float)(this.field_70146_Z.nextFloat() * 360.0f)).func_186678_a((double)0.2f);
                    location = this.pastPositions.get(i).func_178787_e(new Vec3d((double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5, (double)this.field_70146_Z.nextFloat() - 0.5).func_186678_a(1.5).func_186678_a(0.0));
                    ParticleUtil.spawnParticleGlow(this.func_130014_f_(), (float)location.field_72450_a, (float)location.field_72448_b + 1.35f, (float)location.field_72449_c, 0.0f, 0.0f, 0.0f, 1.0f, 0.25f, 0.06f, 1.0f, 5.0f, 20);
                }
            }
        }
        if (this.currentPhase != null && !this.field_70170_p.field_72995_K) {
            this.currentPhase.onUpdate(this);
        }
        if (this.field_70173_aa % 20 == 20) {
            List<EntityPlayer> playersValid = Misc.getNonCreativePlayers(this.field_70170_p, new AxisAlignedBB(this.field_70165_t - 72.0, this.field_70163_u - 72.0, this.field_70161_v - 72.0, this.field_70165_t + 72.0, this.field_70163_u + 72.0, this.field_70161_v + 72.0));
            boolean foundPrevious = false;
            if (this.func_70638_az() != null) {
                for (int i3 = 0; i3 < playersValid.size(); ++i3) {
                    if (playersValid.get(i3).func_110124_au().compareTo(this.func_70638_az().func_110124_au()) != 0) continue;
                    foundPrevious = true;
                }
            }
            if (!foundPrevious && playersValid.size() > 0) {
                this.func_70624_b((EntityLivingBase)playersValid.get(this.field_70146_Z.nextInt(playersValid.size())));
            }
            if (this.random.nextInt(6) == 0) {
                // empty if block
            }
        }
        if (this.func_70638_az() != null) {
            float distanceToTarget = (float)Math.sqrt(Math.pow(this.field_70165_t - this.func_70638_az().field_70165_t, 2.0) + Math.pow(this.field_70161_v - this.func_70638_az().field_70161_v, 2.0));
            if (distanceToTarget > 30.0f && !((Boolean)this.func_184212_Q().func_187225_a(tracking)).booleanValue()) {
                this.func_184212_Q().func_187227_b(tracking, (Object)true);
                this.func_184212_Q().func_187217_b(tracking);
            }
            velocityScale = (Boolean)this.func_184212_Q().func_187225_a(pacified) == false ? 1.0f + Math.max(-0.875f, (25.0f - distanceToTarget) / 20.0f) : Math.max(0.0f, 20.0f - Math.min(20.0f, 200.0f - (float)((Integer)this.func_184212_Q().func_187225_a(fadeTimer)).intValue())) / 200.0f;
        }
        if (this.func_70638_az() != null && ((Boolean)this.func_184212_Q().func_187225_a(tracking)).booleanValue() && !this.func_130014_f_().field_72995_K) {
            this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(Misc.yawDegreesBetweenPointsSafe(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() / 2.0, this.func_70638_az().field_70161_v, ((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).floatValue()))));
            this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(Misc.pitchDegreesBetweenPoints(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.func_70638_az().field_70165_t, this.func_70638_az().field_70163_u + (double)this.func_70638_az().func_70047_e() / 2.0, this.func_70638_az().field_70161_v))));
            this.func_184212_Q().func_187217_b(targetDirectionX);
            this.func_184212_Q().func_187217_b(targetDirectionY);
        }
        if (this.func_70638_az() == null && this.field_70173_aa % 25 == 0 && !this.func_130014_f_().field_72995_K) {
            this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 360.0f)));
            this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf((float)Math.toRadians(this.random.nextFloat() * 180.0f - 90.0f)));
            this.func_184212_Q().func_187217_b(targetDirectionX);
            this.func_184212_Q().func_187217_b(targetDirectionY);
        }
        this.field_70145_X = false;
        boolean insideBlock = this.func_70094_T();
        if (this.currentPhase != null) {
            if (insideBlock && !this.isDigging()) {
                this.currentPhase.onDig(this);
            }
            if (!insideBlock && this.isDigging()) {
                this.currentPhase.onUndig(this);
            }
        }
        this.setDigging(insideBlock);
        this.field_70145_X = true;
        if (this.currentPhase != null) {
            velocityScale = (float)this.currentPhase.getVelocity(this);
        }
        if ((Integer)this.func_184212_Q().func_187225_a(fadeTimer) <= 180 && (Integer)this.func_184212_Q().func_187225_a(fadeTimer) != 0) {
            velocityScale = 0.0f;
        }
        int interval = 25;
        if (this.field_70173_aa % 200 >= 180) {
            interval = 5;
        }
        for (int i4 = 0; i4 < this.getSegments(); ++i4) {
            this.setSegmentFade(i4, 1.0f);
        }
        if (this.currentSpline != null) {
            this.distMoved += (double)velocityScale;
            Vec3d nextPoint = this.currentSpline.getPoint(this.distMoved);
            if (this.distMoved < this.splineInterval) {
                double intervalLerp = this.distMoved / this.splineInterval;
                nextPoint = new Vec3d(MathHelper.func_151238_b((double)(this.field_70165_t + this.moveVec.field_72450_a), (double)nextPoint.field_72450_a, (double)intervalLerp), MathHelper.func_151238_b((double)(this.field_70163_u + this.moveVec.field_72448_b), (double)nextPoint.field_72448_b, (double)intervalLerp), MathHelper.func_151238_b((double)(this.field_70161_v + this.moveVec.field_72449_c), (double)nextPoint.field_72449_c, (double)intervalLerp));
            } else if (this.distMoved > this.currentSpline.getTotalArcLength()) {
                this.moveVec = new Vec3d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
            }
            this.field_70159_w = nextPoint.field_72450_a - this.field_70165_t;
            this.field_70181_x = nextPoint.field_72448_b - this.field_70163_u;
            this.field_70179_y = nextPoint.field_72449_c - this.field_70161_v;
        }
        this.field_70177_z = (float)Math.toRadians(Misc.yawDegreesBetweenPointsSafe(0.0, 0.0, 0.0, this.field_70159_w, this.field_70181_x, this.field_70179_y, this.field_70177_z));
        this.field_70125_A = (float)Math.toRadians(Misc.pitchDegreesBetweenPoints(0.0, 0.0, 0.0, this.field_70159_w, this.field_70181_x, this.field_70179_y));
        if ((Integer)this.func_184212_Q().func_187225_a(fadeTimer) > 180 || (Integer)this.func_184212_Q().func_187225_a(fadeTimer) == 0) {
            if (this.pastPositions.get((int)0).field_72450_a == 0.0 && this.pastPositions.get((int)0).field_72448_b == 0.0 && this.pastPositions.get((int)0).field_72449_c == 0.0) {
                this.pastPositions.set(0, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
            }
            for (int i5 = 1; i5 < this.pastPositions.size(); ++i5) {
                if (this.pastPositions.get((int)i5).field_72450_a != 0.0 || this.pastPositions.get((int)i5).field_72448_b != 0.0 || this.pastPositions.get((int)i5).field_72449_c != 0.0) continue;
                this.pastPositions.set(i5, this.pastPositions.get(i5 - 1));
            }
            if (this.field_70170_p.field_72995_K) {
                System.out.println();
            }
            double dx = this.field_70165_t - this.field_70169_q;
            double dy = this.field_70163_u - this.field_70167_r;
            double dz = this.field_70161_v - this.field_70166_s;
            this.pastPositionDistance += Math.sqrt(dx * dx + dy * dy + dz * dz);
            int g = 0;
            while ((double)g < this.pastPositionDistance / 0.5) {
                for (int i6 = this.pastPositions.size() - 1; i6 > 0; --i6) {
                    this.pastPositions.set(i6, this.pastPositions.get(i6).func_186678_a(0.5).func_178787_e(this.pastPositions.get(i6 - 1).func_186678_a(0.5)));
                }
                this.pastPositions.set(0, new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v));
                this.pastPositionDistance -= 0.5;
                ++g;
            }
        }
        for (int i7 = 0; i7 < this.wormPartArray.length; ++i7) {
            Vec3d position = this.pastPositions.get(i7);
            Vec3d positionLast = this.pastPositionsLast.get(i7);
            MultiPartEntityPart part = this.wormPartArray[i7];
            part.func_70071_h_();
            part.func_70012_b(position.field_72450_a, position.field_72448_b, position.field_72449_c, 0.0f, 0.0f);
            part.field_70169_q = positionLast.field_72450_a;
            part.field_70167_r = positionLast.field_72448_b;
            part.field_70166_s = positionLast.field_72449_c;
        }
    }

    public boolean func_180431_b(DamageSource source) {
        return (Boolean)this.func_184212_Q().func_187225_a(pacified) != false;
    }

    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)source.func_76346_g());
            EntityLivingBase entityLivingBase = (EntityLivingBase)source.func_76346_g();
        }
        return super.func_70097_a(source, amount);
    }

    public void func_70665_d(DamageSource source, float amount) {
        if (this.func_110143_aJ() - amount <= 0.0f && !((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue()) {
            this.func_70606_j(1.0f);
            this.bossInfo.func_186735_a(0.0f);
            this.func_184212_Q().func_187227_b(pacified, (Object)true);
            this.func_184212_Q().func_187217_b(pacified);
            this.func_184212_Q().func_187227_b(fadeTimer, (Object)200);
            if (source.func_76346_g() instanceof EntityPlayer) {
                EntityPlayer entityPlayer = (EntityPlayer)source.func_76346_g();
            }
        } else if (!((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue()) {
            super.func_70665_d(source, amount);
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
    }

    public boolean func_70652_k(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            this.func_70624_b((EntityLivingBase)entity);
        }
        return super.func_70652_k(entity);
    }

    public boolean func_175446_cd() {
        return false;
    }

    public void func_70106_y() {
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70099_a(new ItemStack(Items.field_190929_cY), 4.0f);
        }
        super.func_70106_y();
    }

    protected boolean func_70692_ba() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(320.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(2.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.func_184212_Q().func_187227_b(targetDirectionX, (Object)Float.valueOf(compound.func_74760_g("targetDirectionX")));
        this.func_184212_Q().func_187227_b(targetDirectionY, (Object)Float.valueOf(compound.func_74760_g("targetDirectionY")));
        this.func_184212_Q().func_187227_b(fadeTimer, (Object)compound.func_74762_e("fadeTimer"));
        this.func_184212_Q().func_187227_b(pacified, (Object)compound.func_74767_n("pacified"));
        this.func_184212_Q().func_187227_b(tracking, (Object)compound.func_74767_n("tracking"));
        this.func_184212_Q().func_187217_b(targetDirectionX);
        this.func_184212_Q().func_187217_b(targetDirectionY);
        this.func_184212_Q().func_187217_b(pacified);
        this.func_184212_Q().func_187217_b(tracking);
        this.func_184212_Q().func_187217_b(fadeTimer);
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("targetDirectionX", ((Float)this.func_184212_Q().func_187225_a(targetDirectionX)).floatValue());
        compound.func_74776_a("targetDirectionY", ((Float)this.func_184212_Q().func_187225_a(targetDirectionY)).floatValue());
        compound.func_74757_a("pacified", ((Boolean)this.func_184212_Q().func_187225_a(pacified)).booleanValue());
        compound.func_74757_a("tracking", ((Boolean)this.func_184212_Q().func_187225_a(tracking)).booleanValue());
        compound.func_74768_a("fadeTimer", ((Integer)this.func_184212_Q().func_187225_a(fadeTimer)).intValue());
    }

    public float getFade(float partialTicks) {
        if ((Integer)this.func_184212_Q().func_187225_a(fadeTimer) == 0) {
            return 1.0f;
        }
        return Math.max(0.0f, ((float)((Integer)this.func_184212_Q().func_187225_a(fadeTimer)).intValue() - partialTicks) / 200.0f);
    }

    public void func_184178_b(EntityPlayerMP player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(EntityPlayerMP player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return new ResourceLocation("embers", "entity/magma_worm");
    }

    public World func_82194_d() {
        return this.field_70170_p;
    }

    public int getIndex(MultiPartEntityPart part) {
        Entity[] parts = this.func_70021_al();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] != part) continue;
            return i;
        }
        return -1;
    }

    public boolean func_70965_a(MultiPartEntityPart part, DamageSource source, float damage) {
        int index = this.getIndex(part);
        return false;
    }
}

