/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.entity;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.projectile.EffectDamage;
import teamroots.embers.damage.DamageEmber;
import teamroots.embers.entity.EntityEmberProjectile;

public class EntityAncientGolem
extends EntityMob {
    public long lastPickaxeHit;

    public EntityAncientGolem(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.8f);
        this.field_70728_aV = 10;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70178_ae = true;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 0.46, true));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 0.46));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.46));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.func_175456_n();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(32.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(ConfigManager.ancientGolemKnockbackResistance);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(40.0);
    }

    protected void func_175456_n() {
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_184610_a(boolean wasRecentlyHit, int lootingModifier, DamageSource source) {
        super.func_184610_a(wasRecentlyHit, lootingModifier, source);
        if (this.field_70170_p.func_82737_E() - this.lastPickaxeHit < 400L || this.isPickaxeHit(source)) {
            this.func_145779_a(RegistryManager.golems_eye, 1);
        }
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70177_z = this.field_70759_as;
        if (!this.field_70128_L && this.func_110143_aJ() > 0.0f && this.field_70173_aa % 100 == 0 && this.func_70638_az() != null && !this.func_130014_f_().field_72995_K) {
            this.func_184185_a(SoundManager.FIREBALL, 1.0f, 1.0f);
            EffectDamage effect = new EffectDamage(4.0f, DamageEmber.EMBER_DAMAGE_SOURCE_FACTORY, 1, 1.0);
            EntityEmberProjectile proj = new EntityEmberProjectile(this.func_130014_f_());
            proj.initCustom(this.field_70165_t, this.field_70163_u + 1.6, this.field_70161_v, this.func_70040_Z().field_72450_a * 0.5, this.func_70040_Z().field_72448_b * 0.5, this.func_70040_Z().field_72449_c * 0.5, 4.0, (Entity)this);
            proj.setEffect(effect);
            this.func_130014_f_().func_72838_d((Entity)proj);
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean result = super.func_70097_a(source, amount);
        if (result && this.isPickaxeHit(source)) {
            this.lastPickaxeHit = this.field_70170_p.func_82737_E();
        }
        return result;
    }

    public boolean isPickaxeHit(DamageSource source) {
        ItemStack weapon;
        boolean isNormalAttack;
        Entity attacker = source.func_76364_f();
        boolean bl = isNormalAttack = source.field_76373_n.equals("player") || source.field_76373_n.equals("mob");
        return isNormalAttack && attacker instanceof EntityLivingBase && (weapon = ((EntityLivingBase)attacker).func_184582_a(EntityEquipmentSlot.MAINHAND)).func_77973_b().getToolClasses(weapon).contains("pickaxe");
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            this.func_184185_a(SoundManager.ANCIENT_GOLEM_PUNCH, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    protected SoundEvent func_184615_bR() {
        return SoundManager.ANCIENT_GOLEM_DEATH;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundManager.ANCIENT_GOLEM_HURT;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        super.func_180429_a(pos, blockIn);
        this.func_184185_a(SoundManager.ANCIENT_GOLEM_STEP, 1.0f, 1.0f);
    }

    public ResourceLocation func_184647_J() {
        return new ResourceLocation("embers", "entity/ancient_golem");
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74772_a("lastPickaxeHit", this.lastPickaxeHit);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.lastPickaxeHit = compound.func_74763_f("lastPickaxeHit");
    }
}

