/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import teamroots.embers.RegistryManager;
import teamroots.embers.block.BlockTEBase;
import teamroots.embers.tileentity.TileEntityInfernoForge;
import teamroots.embers.tileentity.TileEntityInfernoForgeOpening;

public class BlockInfernoForge
extends BlockTEBase {
    public static final AxisAlignedBB AABB_BASE = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB AABB_TOP = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 0.75, 1.0);
    public static final AxisAlignedBB AABB_TOP2 = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);
    public static final AxisAlignedBB AABB_NULL = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyBool isTop = PropertyBool.func_177716_a((String)"top");

    public BlockInfernoForge(Material material, String name, boolean addToTab) {
        super(material, name, addToTab);
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean b) {
        if (((Boolean)state.func_177229_b((IProperty)isTop)).booleanValue()) {
            TileEntity t = worldIn.func_175625_s(pos);
            if (t instanceof TileEntityInfernoForgeOpening) {
                if (((TileEntityInfernoForgeOpening)t).openAmount > 0.0f) {
                    BlockInfernoForge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_NULL);
                } else {
                    BlockInfernoForge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP);
                    BlockInfernoForge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_TOP2);
                }
            }
        } else {
            BlockInfernoForge.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)AABB_BASE);
        }
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        if (meta == 0) {
            return new TileEntityInfernoForge();
        }
        if (meta == 1) {
            return new TileEntityInfernoForgeOpening();
        }
        return null;
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{isTop});
    }

    public int func_176201_c(IBlockState state) {
        boolean top = (Boolean)state.func_177229_b((IProperty)isTop);
        return top ? 1 : 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)isTop, (Comparable)Boolean.valueOf(meta == 1));
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (this.isReplaceable(world, pos.func_177974_f()) && this.isReplaceable(world, pos.func_177984_a()) && this.isReplaceable(world, pos.func_177976_e()) && this.isReplaceable(world, pos.func_177978_c()) && this.isReplaceable(world, pos.func_177968_d()) && this.isReplaceable(world, pos.func_177974_f().func_177978_c()) && this.isReplaceable(world, pos.func_177974_f().func_177968_d()) && this.isReplaceable(world, pos.func_177976_e().func_177978_c()) && this.isReplaceable(world, pos.func_177976_e().func_177968_d()) && this.isReplaceable(world, pos.func_177974_f().func_177984_a()) && this.isReplaceable(world, pos.func_177976_e().func_177984_a()) && this.isReplaceable(world, pos.func_177978_c().func_177984_a()) && this.isReplaceable(world, pos.func_177968_d().func_177984_a()) && this.isReplaceable(world, pos.func_177974_f().func_177978_c().func_177984_a()) && this.isReplaceable(world, pos.func_177974_f().func_177968_d().func_177984_a()) && this.isReplaceable(world, pos.func_177976_e().func_177978_c().func_177984_a()) && this.isReplaceable(world, pos.func_177976_e().func_177968_d().func_177984_a())) {
            return super.func_176196_c(world, pos);
        }
        return false;
    }

    private boolean isReplaceable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        if (!((Boolean)state.func_177229_b((IProperty)isTop)).booleanValue()) {
            world.func_175656_a(pos.func_177984_a(), RegistryManager.inferno_forge.func_176203_a(1));
            world.func_175656_a(pos.func_177978_c(), RegistryManager.inferno_forge_edge.func_176203_a(0));
            world.func_175656_a(pos.func_177978_c().func_177976_e(), RegistryManager.inferno_forge_edge.func_176203_a(1));
            world.func_175656_a(pos.func_177976_e(), RegistryManager.inferno_forge_edge.func_176203_a(2));
            world.func_175656_a(pos.func_177968_d().func_177976_e(), RegistryManager.inferno_forge_edge.func_176203_a(3));
            world.func_175656_a(pos.func_177968_d(), RegistryManager.inferno_forge_edge.func_176203_a(4));
            world.func_175656_a(pos.func_177968_d().func_177974_f(), RegistryManager.inferno_forge_edge.func_176203_a(5));
            world.func_175656_a(pos.func_177974_f(), RegistryManager.inferno_forge_edge.func_176203_a(6));
            world.func_175656_a(pos.func_177978_c().func_177974_f(), RegistryManager.inferno_forge_edge.func_176203_a(7));
            world.func_175656_a(pos.func_177978_c().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(8));
            world.func_175656_a(pos.func_177978_c().func_177976_e().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(9));
            world.func_175656_a(pos.func_177976_e().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(10));
            world.func_175656_a(pos.func_177968_d().func_177976_e().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(11));
            world.func_175656_a(pos.func_177968_d().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(12));
            world.func_175656_a(pos.func_177968_d().func_177974_f().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(13));
            world.func_175656_a(pos.func_177974_f().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(14));
            world.func_175656_a(pos.func_177978_c().func_177974_f().func_177984_a(), RegistryManager.inferno_forge_edge.func_176203_a(15));
        }
    }

    public void removeEdge(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_177230_c() == RegistryManager.inferno_forge_edge) {
            world.func_175698_g(pos);
            world.func_184138_a(pos, RegistryManager.inferno_forge_edge.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 8);
        }
        if (world.func_180495_p(pos).func_177230_c() == this) {
            world.func_175698_g(pos);
            world.func_175690_a(pos, null);
            world.func_184138_a(pos, this.func_176223_P().func_177226_a((IProperty)isTop, (Comparable)Boolean.valueOf(true)), Blocks.field_150350_a.func_176223_P(), 8);
        }
    }

    public void cleanEdges(World world, BlockPos pos) {
        this.removeEdge(world, pos.func_177978_c());
        this.removeEdge(world, pos.func_177978_c().func_177976_e());
        this.removeEdge(world, pos.func_177976_e());
        this.removeEdge(world, pos.func_177968_d().func_177976_e());
        this.removeEdge(world, pos.func_177968_d());
        this.removeEdge(world, pos.func_177968_d().func_177974_f());
        this.removeEdge(world, pos.func_177974_f());
        this.removeEdge(world, pos.func_177978_c().func_177974_f());
        this.removeEdge(world, pos.func_177978_c().func_177984_a());
        this.removeEdge(world, pos.func_177978_c().func_177976_e().func_177984_a());
        this.removeEdge(world, pos.func_177976_e().func_177984_a());
        this.removeEdge(world, pos.func_177968_d().func_177976_e().func_177984_a());
        this.removeEdge(world, pos.func_177968_d().func_177984_a());
        this.removeEdge(world, pos.func_177968_d().func_177974_f().func_177984_a());
        this.removeEdge(world, pos.func_177974_f().func_177984_a());
        this.removeEdge(world, pos.func_177978_c().func_177974_f().func_177984_a());
        this.removeEdge(world, pos.func_177984_a());
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        if (state.func_177230_c() == this && !((Boolean)state.func_177229_b((IProperty)isTop)).booleanValue()) {
            drops.add(new ItemStack((Block)this, 1));
        }
        return drops;
    }
}

