/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import org.lwjgl.opengl.GL11;
import teamroots.embers.ConfigManager;
import teamroots.embers.Embers;
import teamroots.embers.RegistryManager;
import teamroots.embers.SoundManager;
import teamroots.embers.api.block.IDial;
import teamroots.embers.api.capabilities.EmbersCapabilities;
import teamroots.embers.api.event.EmberProjectileEvent;
import teamroots.embers.api.item.IEmberChargedTool;
import teamroots.embers.api.item.IInflictorGem;
import teamroots.embers.api.item.IInflictorGemHolder;
import teamroots.embers.api.itemmod.ItemModUtil;
import teamroots.embers.api.itemmod.ModifierBase;
import teamroots.embers.api.power.IEmberCapability;
import teamroots.embers.api.tile.IExtraCapabilityInformation;
import teamroots.embers.api.tile.IMechanicallyPowered;
import teamroots.embers.compat.MysticalMechanicsIntegration;
import teamroots.embers.gui.GuiCodex;
import teamroots.embers.item.ItemEmberGauge;
import teamroots.embers.item.ItemGrandhammer;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberBurstFX;
import teamroots.embers.network.message.MessageEmberGenOffset;
import teamroots.embers.network.message.MessageTyrfingBurstFX;
import teamroots.embers.proxy.ClientProxy;
import teamroots.embers.research.ResearchBase;
import teamroots.embers.tileentity.ITileEntitySpecialRendererLater;
import teamroots.embers.tileentity.TileEntityExplosionPedestal;
import teamroots.embers.tileentity.TileEntityMechAccessor;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;
import teamroots.embers.util.RenderUtil;
import teamroots.embers.world.EmberWorldData;

public class EventManager {
    double gaugeAngle = 0.0;
    public static boolean hasRenderedParticles = false;
    Random random = new Random();
    public static float emberEyeView = 0.0f;
    public static ResearchBase lastResearch = null;
    public static float frameTime = 0.0f;
    public static float frameCounter = 0.0f;
    public static long prevTime = 0L;
    public static EnumHand lastHand = EnumHand.MAIN_HAND;
    public static float starlightRed = 255.0f;
    public static float starlightGreen = 32.0f;
    public static float starlightBlue = 255.0f;
    public static float tickCounter = 0.0f;
    public static double currentEmber = 0.0;
    public static boolean allowPlayerRenderEvent = true;
    public static int ticks = 0;
    public static float prevCooledStrength = 0.0f;
    public static boolean acceptUpdates = true;
    public static WeakHashMap<World, ExplosionCharmWorldInfo> explosionCharmData = new WeakHashMap();
    static EntityPlayer clientPlayer = null;
    private static ThreadLocal<Boolean> captureDrops = ThreadLocal.withInitial(() -> false);
    private static ThreadLocal<NonNullList<ItemStack>> capturedDrops = ThreadLocal.withInitial(NonNullList::func_191196_a);
    static HashSet<String> removedItems = Sets.newHashSet((Object[])new String[]{"embers:advanced_edge", "embers:inferno_forge_edge", "embers:mech_edge", "embers:glow", "embers:structure_marker"});

    @SubscribeEvent
    public void onExplosion(ExplosionEvent.Start event) {
        TileEntity tile;
        World world = event.getWorld();
        Explosion explosion = event.getExplosion();
        ExplosionCharmWorldInfo data = explosionCharmData.get(world);
        if (data == null) {
            return;
        }
        BlockPos charmPos = data.getClosestExplosionCharm(world, new BlockPos(explosion.getPosition()), 8);
        if (charmPos != null && (tile = world.func_175625_s(charmPos)) instanceof TileEntityExplosionPedestal) {
            ((TileEntityExplosionPedestal)tile).absorb(explosion);
            event.setCanceled(true);
        }
    }

    public static void putExplosionCharm(World world, BlockPos pos) {
        if (!explosionCharmData.containsKey(world)) {
            explosionCharmData.put(world, new ExplosionCharmWorldInfo());
        }
        ExplosionCharmWorldInfo data = explosionCharmData.get(world);
        data.put(pos);
    }

    public static NonNullList<ItemStack> captureDrops(boolean start) {
        if (start) {
            captureDrops.set(true);
            capturedDrops.get().clear();
            return NonNullList.func_191196_a();
        }
        captureDrops.set(false);
        return capturedDrops.get();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void captureDrops(BlockEvent.HarvestDropsEvent event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            return;
        }
        float chance = event.getDropChance();
        if (captureDrops.get().booleanValue()) {
            NonNullList<ItemStack> stacks = capturedDrops.get();
            for (ItemStack stack : event.getDrops()) {
                if (stack == null || stack.func_190926_b() || !(world.field_73012_v.nextFloat() <= chance)) continue;
                stacks.add((Object)stack);
            }
            event.getDrops().clear();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent event) {
        ResourceLocation particleGlow = new ResourceLocation("embers:entity/particle_mote");
        event.getMap().func_174942_a(particleGlow);
        ResourceLocation particleSparkle = new ResourceLocation("embers:entity/particle_star");
        event.getMap().func_174942_a(particleSparkle);
        ResourceLocation particleSmoke = new ResourceLocation("embers:entity/particle_smoke");
        event.getMap().func_174942_a(particleSmoke);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_alchemical_redstone);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_lead);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_tin);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_aluminum);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_bronze);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_copper);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_dawnstone);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_electrum);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_gold);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_iron);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_nickel);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_molten_silver);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_steam);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_crude_oil);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_oil);
        this.stitchFluid(event.getMap(), RegistryManager.fluid_gas);
    }

    @SideOnly(value=Side.CLIENT)
    private void stitchFluid(TextureMap map, Fluid fluid) {
        map.func_174942_a(fluid.getStill());
        map.func_174942_a(fluid.getFlowing());
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.WorldTickEvent event) {
        if (event.world.field_73011_w.func_186058_p() == DimensionType.OVERWORLD) {
            boolean changed = false;
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offX;
                EmberWorldData.get(event.world).func_76185_a();
                changed = true;
            }
            if (Misc.random.nextInt(400) == 0) {
                ++EmberGenUtil.offZ;
                EmberWorldData.get(event.world).func_76185_a();
                changed = true;
            }
            if (changed) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberGenOffset(EmberGenUtil.offX, EmberGenUtil.offZ));
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingHurtEvent event) {
        EntityPlayer damager;
        ItemStack s2;
        EntityLivingBase entityLiving = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (entityLiving instanceof EntityPlayer) {
            this.attuneInflictorGem(entityLiving, source, entityLiving.func_184614_ca());
            this.attuneInflictorGem(entityLiving, source, entityLiving.func_184592_cb());
        }
        this.applyInflictorGemResistance(event, entityLiving.func_184582_a(EntityEquipmentSlot.HEAD));
        this.applyInflictorGemResistance(event, entityLiving.func_184582_a(EntityEquipmentSlot.CHEST));
        this.applyInflictorGemResistance(event, entityLiving.func_184582_a(EntityEquipmentSlot.LEGS));
        this.applyInflictorGemResistance(event, entityLiving.func_184582_a(EntityEquipmentSlot.FEET));
        for (ItemStack s2 : entityLiving.func_184209_aF()) {
            if (!(s2.func_77973_b() instanceof ItemArmor)) continue;
            this.addHeat(entityLiving, s2, 5.0f);
        }
        if (source.func_76346_g() instanceof EntityPlayer && !(s2 = (damager = (EntityPlayer)source.func_76346_g()).func_184614_ca()).func_190926_b()) {
            this.addHeat(entityLiving, s2, 1.0f);
        }
    }

    private void attuneInflictorGem(EntityLivingBase entityLiving, DamageSource source, ItemStack stack) {
        if (stack.func_77973_b() instanceof IInflictorGem) {
            ((IInflictorGem)stack.func_77973_b()).attuneSource(stack, entityLiving, source);
        }
    }

    private void applyInflictorGemResistance(LivingHurtEvent event, ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof IInflictorGemHolder) {
            IInflictorGemHolder inflictorGemHolder = (IInflictorGemHolder)item;
            float mult = Math.max(0.0f, 1.0f - inflictorGemHolder.getTotalDamageResistance(event.getEntityLiving(), event.getSource(), stack));
            if (mult == 0.0f) {
                event.setCanceled(true);
            }
            event.setAmount(event.getAmount() * mult);
        }
    }

    private void addHeat(EntityLivingBase entity, ItemStack stack, float added) {
        if (ItemModUtil.hasHeat(stack)) {
            double maxHeat = ItemModUtil.getMaxHeat(stack);
            double heat = ItemModUtil.getHeat(stack);
            if (heat < maxHeat) {
                ItemModUtil.addHeat(stack, added);
                if (heat + (double)added >= maxHeat) {
                    entity.func_130014_f_().func_184148_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundManager.HEATED_ITEM_LEVELUP, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onGameOverlayRender(RenderGameOverlayEvent.Post e) {
        if (e.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            World world;
            frameCounter += 1.0f;
            frameTime = (float)(System.nanoTime() - prevTime) / 1.0E9f;
            prevTime = System.nanoTime();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            boolean showBar = false;
            int w = e.getResolution().func_78326_a();
            int h = e.getResolution().func_78328_b();
            int x = w / 2;
            int y = h / 2;
            if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() instanceof ItemEmberGauge) {
                showBar = true;
            }
            if (!player.func_184592_cb().func_190926_b() && player.func_184592_cb().func_77973_b() instanceof ItemEmberGauge) {
                showBar = true;
            }
            Tessellator tess = Tessellator.func_178181_a();
            BufferBuilder b = tess.func_178180_c();
            if (showBar) {
                world = player.func_130014_f_();
                GlStateManager.func_179097_i();
                GlStateManager.func_179129_p();
                GlStateManager.func_179094_E();
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/ember_meter_overlay.png"));
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                boolean offsetX = false;
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, 0.0, x - 16, y - 4, x + 16, y - 4, x + 16, y - 36, x - 16, y - 36, 0.0, 0.0, 1.0, 1.0);
                tess.func_78381_a();
                double angle = 195.0;
                EmberWorldData data = EmberWorldData.get(world);
                if (player != null) {
                    double ratio = EmberGenUtil.getEmberDensity(world.func_72905_C(), player.func_180425_c().func_177958_n(), player.func_180425_c().func_177952_p());
                    this.gaugeAngle = this.gaugeAngle == 0.0 ? 165.0 + 210.0 * ratio : this.gaugeAngle * 0.99 + 0.01 * (165.0 + 210.0 * ratio);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("embers:textures/gui/ember_meter_pointer.png"));
                GlStateManager.func_179109_b((float)x, (float)(y - 20), (float)0.0f);
                GlStateManager.func_179114_b((float)((float)this.gaugeAngle), (float)0.0f, (float)0.0f, (float)1.0f);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawQuadGui(b, 0.0, -2.5, 13.5, 13.5, 13.5, 13.5, -2.5, -2.5, -2.5, 0.0, 0.0, 1.0, 1.0);
                tess.func_78381_a();
                GlStateManager.func_179121_F();
                GlStateManager.func_179089_o();
                GlStateManager.func_179126_j();
            }
            world = player.func_130014_f_();
            RayTraceResult result = player.func_174822_a(6.0, e.getPartialTicks());
            if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK) {
                TileEntity tileEntity;
                IBlockState state = world.func_180495_p(result.func_178782_a());
                EnumFacing facing = result.field_178784_b;
                ArrayList text = Lists.newArrayList();
                if (state.func_177230_c() instanceof IDial) {
                    text.addAll(((IDial)state.func_177230_c()).getDisplayInfo(world, result.func_178782_a(), state));
                }
                if (Embers.proxy.isPlayerWearingGoggles() && (tileEntity = world.func_175625_s(result.func_178782_a())) != null) {
                    this.addCapabilityInformation(text, tileEntity, facing);
                }
                for (int i = 0; i < text.size(); ++i) {
                    Minecraft.func_71410_x().field_71466_p.func_175063_a((String)text.get(i), (float)(x - Minecraft.func_71410_x().field_71466_p.func_78256_a((String)text.get(i)) / 2), (float)(y + 40 + 11 * i), 0xFFFFFF);
                }
            }
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("minecraft:textures/gui/icons.png"));
        GlStateManager.func_179126_j();
    }

    private void addCapabilityInformation(List<String> text, TileEntity tile, EnumFacing facing) {
        EventManager.addCapabilityItemDescription(text, tile, facing);
        EventManager.addCapabilityFluidDescription(text, tile, facing);
        EventManager.addCapabilityEmberDescription(text, tile, facing);
        if (ConfigManager.isMysticalMechanicsIntegrationEnabled()) {
            MysticalMechanicsIntegration.addCapabilityInformation(text, tile, facing);
        }
        if (tile.hasCapability(EmbersCapabilities.UPGRADE_PROVIDER_CAPABILITY, facing)) {
            text.add(I18n.func_135052_a((String)"embers.tooltip.goggles.upgrade", (Object[])new Object[0]));
        }
        if (TileEntityMechAccessor.canAccess(tile)) {
            text.add(I18n.func_135052_a((String)"embers.tooltip.goggles.accessor_slot", (Object[])new Object[0]));
        }
        if (tile instanceof IMechanicallyPowered) {
            text.add(I18n.func_135052_a((String)"embers.tooltip.goggles.actuator_slot", (Object[])new Object[0]));
        }
        if (tile instanceof IExtraCapabilityInformation) {
            ((IExtraCapabilityInformation)tile).addOtherDescription(text, facing);
        }
    }

    public static void addCapabilityItemDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            String filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.item", filter));
            }
        }
    }

    public static void addCapabilityFluidDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability capability = CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            String filter = null;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                IFluidHandler handler = (IFluidHandler)tile.getCapability(capability, facing);
                for (IFluidTankProperties properties : handler.getTankProperties()) {
                    boolean input = properties.canFill();
                    boolean output = properties.canDrain();
                    if (!input && !output) {
                        ioType = IExtraCapabilityInformation.EnumIOType.NONE;
                        continue;
                    }
                    if (input && !output) {
                        ioType = IExtraCapabilityInformation.EnumIOType.INPUT;
                        continue;
                    }
                    if (!output || input) continue;
                    ioType = IExtraCapabilityInformation.EnumIOType.OUTPUT;
                }
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.fluid", filter));
            }
        }
    }

    public static void addCapabilityEmberDescription(List<String> text, TileEntity tile, EnumFacing facing) {
        Capability<IEmberCapability> capability = EmbersCapabilities.EMBER_CAPABILITY;
        if (tile.hasCapability(capability, facing)) {
            IExtraCapabilityInformation.EnumIOType ioType = IExtraCapabilityInformation.EnumIOType.BOTH;
            if (tile instanceof IExtraCapabilityInformation && ((IExtraCapabilityInformation)tile).hasCapabilityDescription(capability)) {
                ((IExtraCapabilityInformation)tile).addCapabilityDescription(text, capability, facing);
            } else {
                text.add(IExtraCapabilityInformation.formatCapability(ioType, "embers.tooltip.goggles.ember", null));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.START) {
            EntityPlayerSP player;
            ++ticks;
            if (!Minecraft.func_71410_x().func_147113_T()) {
                ClientProxy.particleRenderer.updateParticles();
            }
            if ((player = Minecraft.func_71410_x().field_71439_g) != null) {
                IBlockState state;
                World world = player.func_130014_f_();
                RayTraceResult result = player.func_174822_a(6.0, Minecraft.func_71410_x().func_184121_ak());
                if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && (state = world.func_180495_p(result.func_178782_a())).func_177230_c() instanceof IDial) {
                    ((IDial)state.func_177230_c()).updateTEData(world, state, result.func_178782_a());
                }
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPlayerRender(RenderPlayerEvent.Pre event) {
        if (event.getEntityPlayer() != null && (Minecraft.func_71410_x().field_71415_G || event.getEntityPlayer().func_110124_au().compareTo(Minecraft.func_71410_x().field_71439_g.func_110124_au()) != 0)) {
            event.setCanceled(!allowPlayerRenderEvent);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onEntityDamaged(LivingHurtEvent event) {
        Entity trueSource;
        if (event.getSource().field_76373_n.equals(RegistryManager.damage_ember.field_76373_n) && event.getEntityLiving().func_70644_a(Potion.func_180142_b((String)"fire_resistance"))) {
            event.setAmount(event.getAmount() * 0.5f);
        }
        if (!((trueSource = event.getSource().func_76346_g()) instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)trueSource;
        ItemStack heldStack = player.func_184614_ca();
        if (heldStack.func_190926_b()) {
            return;
        }
        if (heldStack.func_77973_b() == RegistryManager.tyrfing) {
            event.getEntity().func_184185_a(SoundManager.TYRFING_HIT, 1.0f, 1.0f);
            if (!event.getEntity().field_70170_p.field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageTyrfingBurstFX(event.getEntity().field_70165_t, event.getEntity().field_70163_u + (double)(event.getEntity().field_70131_O / 2.0f), event.getEntity().field_70161_v));
            }
            event.setAmount(event.getAmount() / 4.0f * (4.0f + (float)event.getEntityLiving().func_110148_a(SharedMonsterAttributes.field_188791_g).func_111126_e() * 1.0f));
        }
        if (heldStack.func_77973_b() instanceof IEmberChargedTool) {
            if (!player.field_71075_bZ.field_75098_d && !((IEmberChargedTool)heldStack.func_77973_b()).hasEmber(heldStack)) {
                event.setCanceled(true);
            }
            if (!event.isCanceled() && event.getAmount() > 0.0f) {
                event.getEntityLiving().func_70015_d(1);
                if (!event.getEntityLiving().func_130014_f_().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberBurstFX(event.getEntityLiving().field_70165_t, event.getEntityLiving().field_70163_u + (double)event.getEntityLiving().func_70047_e() / 1.5, event.getEntityLiving().field_70161_v));
                    heldStack.func_77978_p().func_74757_a("didUse", true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        EntityPlayer player = event.getPlayer();
        if (player != null && !player.func_184614_ca().func_190926_b()) {
            ItemStack s = player.func_184614_ca();
            if (!s.func_190926_b() && event.getState().func_185887_b(event.getWorld(), event.getPos()) > 0.0f) {
                this.addHeat((EntityLivingBase)player, s, 1.0f);
            }
            if (player.func_184614_ca().func_77973_b() instanceof ItemGrandhammer) {
                event.setCanceled(true);
                event.getWorld().func_175698_g(event.getPos());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onProjectileFired(EmberProjectileEvent event) {
        EntityLivingBase shooter = event.getShooter();
        ItemStack weapon = event.getStack();
        if (!weapon.func_190926_b()) {
            this.addHeat(shooter, weapon, (float)event.getProjectiles().size() * (float)MathHelper.func_151238_b((double)0.5, (double)3.0, (double)event.getCharge()));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onArrowLoose(ArrowLooseEvent event) {
        EntityLivingBase shooter = event.getEntityLiving();
        ItemStack weapon = event.getBow();
        if (!weapon.func_190926_b()) {
            this.addHeat(shooter, weapon, 1.0f);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ItemModUtil.hasHeat(event.getItemStack())) {
            List<ModifierBase> modifiers;
            long count;
            event.getToolTip().add("");
            if (ItemModUtil.hasHeat(event.getItemStack()) && ItemModUtil.getLevel(event.getItemStack()) > 0) {
                event.getToolTip().add("");
            }
            event.getToolTip().add("                        ");
            if (ItemModUtil.hasHeat(event.getItemStack()) && (count = (modifiers = ItemModUtil.getModifiers(event.getItemStack())).stream().filter(x -> x.shouldRenderTooltip).count()) > 0L) {
                event.getToolTip().add(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.modifiers", (Object[])new Object[0]));
                int i = 0;
                while ((long)i < count) {
                    event.getToolTip().add("");
                    ++i;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTooltipRender(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack != null && ItemModUtil.hasHeat(stack)) {
            for (int i = 0; i < event.getLines().size(); ++i) {
                float ref;
                int func;
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "" + TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.modifiers", (Object[])new Object[0])) == 0) {
                    List modifiers = ItemModUtil.getModifiers(stack).stream().filter(x -> x.shouldRenderTooltip).collect(Collectors.toList());
                    GlStateManager.func_179097_i();
                    GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                    if (modifiers.size() > 0) {
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179141_d();
                        func = GL11.glGetInteger((int)3009);
                        ref = GL11.glGetFloat((int)3010);
                        GlStateManager.func_179092_a((int)519, (float)0.0f);
                        int j = 0;
                        for (ModifierBase modifier : modifiers) {
                            int level = ItemModUtil.getModifierLevel(stack, modifier);
                            GuiCodex.drawTextGlowingAura(event.getFontRenderer(), I18n.func_135052_a((String)("embers.tooltip.modifier." + modifier.name), (Object[])new Object[]{this.getFormattedModifierLevel(level)}), event.getX(), event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i + j + 1) + 2);
                            ++j;
                        }
                        GlStateManager.func_179092_a((int)func, (float)ref);
                        GlStateManager.func_179118_c();
                        GlStateManager.func_179084_k();
                    }
                    GlStateManager.func_179126_j();
                }
                if (((String)event.getLines().get(i)).compareTo(TextFormatting.GRAY + "                        ") != 0) continue;
                GlStateManager.func_179097_i();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
                if (ItemModUtil.getLevel(stack) > 0) {
                    event.getFontRenderer().func_175063_a(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.heat_level", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i - 1) + 2), -1);
                    int level_x = event.getFontRenderer().func_78256_a(I18n.func_135052_a((String)"embers.tooltip.heat_level", (Object[])new Object[0])) + 2;
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179141_d();
                    func = GL11.glGetInteger((int)3009);
                    ref = GL11.glGetFloat((int)3010);
                    GlStateManager.func_179092_a((int)519, (float)0.0f);
                    GuiCodex.drawTextGlowingAura(event.getFontRenderer(), "" + ItemModUtil.getLevel(stack), event.getX() + level_x, event.getY() + (event.getFontRenderer().field_78288_b + 1) * (i - 1) + 2);
                    GlStateManager.func_179092_a((int)func, (float)ref);
                    GlStateManager.func_179118_c();
                    GlStateManager.func_179084_k();
                }
                event.getFontRenderer().func_175063_a(TextFormatting.GRAY + I18n.func_135052_a((String)"embers.tooltip.heat_amount", (Object[])new Object[0]), (float)event.getX(), (float)(event.getY() + (event.getFontRenderer().field_78288_b + 1) * i + 2), -1);
                double x2 = (double)event.getFontRenderer().func_78256_a(I18n.func_135052_a((String)"embers.tooltip.heat_amount", (Object[])new Object[0])) + 1.0;
                double w = event.getFontRenderer().func_78256_a("                        ");
                Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("embers:textures/gui/heat_bar.png"));
                Tessellator tess = Tessellator.func_178181_a();
                BufferBuilder b = tess.func_178180_c();
                GlStateManager.func_179090_x();
                GlStateManager.func_179141_d();
                int func2 = GL11.glGetInteger((int)3009);
                float ref2 = GL11.glGetFloat((int)3010);
                GlStateManager.func_179092_a((int)519, (float)0.0f);
                GlStateManager.func_179147_l();
                double baseX = event.getX();
                double baseY = event.getY() + (event.getFontRenderer().field_78288_b + 1) * i + 2;
                GlStateManager.func_179103_j((int)7425);
                b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                double x1 = baseX + x2 + 4.0;
                double x22 = baseX + w - 3.0;
                float heat = ItemModUtil.getHeat(stack);
                float maxHeat = ItemModUtil.getMaxHeat(stack);
                x22 = x1 + (x22 - x1) * (double)(heat / maxHeat);
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0) * (heat >= maxHeat ? (float)Math.sin((double)ticks * 0.5) * 2.0f + 3.0f : 1.0f);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x22 * coeff, baseY + k, 0.0, (x22 - x1) / 10.0, 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + k))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 1.0f, 0.25f, 0.0625f, Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                x1 = baseX + x2 + 4.0;
                x22 = baseX + w - 3.0;
                double point = x1 + (x22 - x1) * (double)(heat / maxHeat);
                for (double k = 0.0; k < 4.0; k += 0.5) {
                    float thick = (float)(k / 4.0);
                    RenderUtil.drawColorRectBatched(b, point, baseY + k, 0.0, Math.min(x22 - point, (x22 - x1) / 10.0), 8.0 - 2.0 * k, 1.0f, 0.25f, 0.0625f, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.0f, 0.25f, 0.0625f, 0.015625f, 0.0f, 1.0f, 0.25f, 0.0625f, 1.0f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * point), 4 * (int)(baseY + (8.0 - k)))));
                }
                tess.func_78381_a();
                b.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                x1 = baseX + x2 + 4.0;
                x22 = baseX + w - 3.0;
                x1 = x22 - (x22 - x1) * (double)(1.0f - heat / maxHeat);
                for (double j = 0.0; j < 10.0; j += 1.0) {
                    double coeff = j / 10.0;
                    double coeff2 = (j + 1.0) / 10.0;
                    for (double k = 0.0; k < 4.0; k += 0.5) {
                        float thick = (float)(k / 4.0);
                        RenderUtil.drawColorRectBatched(b, x1 * (1.0 - coeff) + x22 * coeff, baseY + k, 0.0, (x22 - x1) / 10.0, 8.0 - 2.0 * k, 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + k))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff2) + x22 * coeff2)), 4 * (int)(baseY + (8.0 - k)))), 0.25f, 0.0625f, 0.015625f, 0.75f * Math.min(1.0f, thick * 0.25f + thick * EmberGenUtil.getEmberDensity(6L, (int)((double)(ticks * 12) + 4.0 * (x1 * (1.0 - coeff) + x22 * coeff)), 4 * (int)(baseY + (8.0 - k)))));
                    }
                }
                tess.func_78381_a();
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179098_w();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179092_a((int)func2, (float)ref2);
                b.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + x2 + 1.0), (int)baseY - 1, 0.0, 0.0, 0.0, 0.5, 0.625, 8, 10);
                RenderUtil.drawTexturedModalRectBatched(b, (int)(baseX + w - 8.0), (int)baseY - 1, 0.0, 0.5, 0.0, 1.0, 0.625, 8, 10);
                tess.func_78381_a();
                GlStateManager.func_179084_k();
                GlStateManager.func_179118_c();
                GlStateManager.func_179126_j();
            }
        }
    }

    private String getFormattedModifierLevel(int level) {
        String key = "embers.tooltip.num" + level;
        if (I18n.func_188566_a((String)key)) {
            return I18n.func_135052_a((String)key, (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"embers.tooltip.numstop", (Object[])new Object[0]);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderAfterWorld(RenderWorldLastEvent event) {
        tickCounter += 1.0f;
        if (Embers.proxy instanceof ClientProxy) {
            GlStateManager.func_179094_E();
            ClientProxy.particleRenderer.renderParticles(clientPlayer, event.getPartialTicks());
            GlStateManager.func_179121_F();
        }
        List list = Minecraft.func_71410_x().field_71441_e.field_147482_g;
        GlStateManager.func_179094_E();
        for (int i = 0; i < list.size(); ++i) {
            TileEntitySpecialRenderer render = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)list.get(i));
            if (!(render instanceof ITileEntitySpecialRendererLater)) continue;
            double x = Minecraft.func_71410_x().field_71439_g.field_70142_S + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70165_t - Minecraft.func_71410_x().field_71439_g.field_70142_S);
            double y = Minecraft.func_71410_x().field_71439_g.field_70137_T + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70163_u - Minecraft.func_71410_x().field_71439_g.field_70137_T);
            double z = Minecraft.func_71410_x().field_71439_g.field_70136_U + (double)Minecraft.func_71410_x().func_184121_ak() * (Minecraft.func_71410_x().field_71439_g.field_70161_v - Minecraft.func_71410_x().field_71439_g.field_70136_U);
            ((ITileEntitySpecialRendererLater)render).renderLater((TileEntity)list.get(i), (double)((TileEntity)list.get(i)).func_174877_v().func_177958_n() - x, (double)((TileEntity)list.get(i)).func_174877_v().func_177956_o() - y, (double)((TileEntity)list.get(i)).func_174877_v().func_177952_p() - z, Minecraft.func_71410_x().func_184121_ak());
        }
        GlStateManager.func_179121_F();
    }

    @SubscribeEvent
    public void onBlockBreak(PlayerEvent.BreakSpeed event) {
        event.getOriginalSpeed();
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawScaledCustomSizeModalRect(double x, double y, float u, float v, float uWidth, float vHeight, double width, double height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder BufferBuilder2 = tessellator.func_178180_c();
        BufferBuilder2.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        BufferBuilder2.func_181662_b(x, y + height, 0.0).func_187315_a((double)(u * f), (double)((v + vHeight) * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x + width, y + height, 0.0).func_187315_a((double)((u + uWidth) * f), (double)((v + vHeight) * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x + width, y, 0.0).func_187315_a((double)((u + uWidth) * f), (double)(v * f1)).func_181675_d();
        BufferBuilder2.func_181662_b(x, y, 0.0).func_187315_a((double)(u * f), (double)(v * f1)).func_181675_d();
        tessellator.func_78381_a();
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            String path = entry.key.toString();
            if (!removedItems.contains(path)) continue;
            entry.ignore();
        }
    }

    public static class ExplosionCharmWorldInfo {
        HashMultimap<ChunkPos, BlockPos> data = HashMultimap.create();

        public void put(BlockPos pos) {
            ChunkPos chunkPos = new ChunkPos(pos);
            this.data.put((Object)chunkPos, (Object)pos);
        }

        public BlockPos getClosestExplosionCharm(World world, BlockPos pos, int radius) {
            BlockPos chosen = null;
            double minDistance = Double.POSITIVE_INFINITY;
            ChunkPos chunkPosA = new ChunkPos(pos.func_177982_a(-radius, 0, -radius));
            ChunkPos chunkPosB = new ChunkPos(pos.func_177982_a(radius, 0, radius));
            for (int x = chunkPosA.field_77276_a; x <= chunkPosB.field_77276_a; ++x) {
                for (int z = chunkPosA.field_77275_b; z <= chunkPosB.field_77275_b; ++z) {
                    ChunkPos chunkPos = new ChunkPos(x, z);
                    Iterator iterator = this.data.get((Object)chunkPos).iterator();
                    while (iterator.hasNext()) {
                        BlockPos testpos = (BlockPos)iterator.next();
                        double testdist = testpos.func_177954_c((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        if (testdist >= minDistance || testdist > (double)(radius * radius)) continue;
                        TileEntity tile = world.func_175625_s(testpos);
                        if (tile instanceof TileEntityExplosionPedestal && !tile.func_145837_r()) {
                            chosen = testpos;
                            minDistance = testdist;
                            continue;
                        }
                        iterator.remove();
                    }
                }
            }
            return chosen;
        }
    }
}

