/*
 * Decompiled with CFR 0.152.
 */
package org.dave.ocxnetdriver.driver.controller;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.internal.Database;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.Node;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import mcjty.xnet.api.channels.IControllerContext;
import mcjty.xnet.api.keys.SidedPos;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.dave.ocxnetdriver.config.ConfigurationHandler;
import org.dave.ocxnetdriver.converter.ConverterBlockPos;
import org.dave.ocxnetdriver.util.CachedReflectionHelper;

public class EnvironmentXnetController
extends AbstractManagedEnvironment
implements NamedBlock {
    protected final TileEntity tileEntity;
    protected final BlockPos controllerPos;
    protected final World controllerWorld;

    public EnvironmentXnetController(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
        this.controllerWorld = this.tileEntity.func_145831_w();
        this.controllerPos = this.tileEntity.func_174877_v();
        this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("xnet", Visibility.Network).create());
    }

    private IControllerContext getControllerContext() {
        return (IControllerContext)this.tileEntity;
    }

    private BlockPos toRelative(BlockPos pos) {
        if (!ConfigurationHandler.Settings.useRelativePositions()) {
            return pos;
        }
        return pos.func_177982_a(-this.controllerPos.func_177958_n(), -this.controllerPos.func_177956_o(), -this.controllerPos.func_177952_p());
    }

    private BlockPos toAbsolute(BlockPos pos) {
        if (!ConfigurationHandler.Settings.useRelativePositions()) {
            return pos;
        }
        return pos.func_177982_a(this.controllerPos.func_177958_n(), this.controllerPos.func_177956_o(), this.controllerPos.func_177952_p());
    }

    private SidedPos getSidedPos(BlockPos pos) {
        return this.getControllerContext().getConnectedBlockPositions().stream().filter(sp -> sp.getPos().equals((Object)pos)).findFirst().orElse(null);
    }

    @Callback(doc="function(sourcePos:table, amount:number, targetPos:table[, sourceSide:number[, targetSide:number]]):number -- Transfer energy between two energy handlers")
    public Object[] transferEnergy(Context context, Arguments args) {
        int simReceived;
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given source position is not connected to the network"};
        }
        int amount = args.checkInteger(1);
        BlockPos targetPos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 2));
        SidedPos targetSidedPos = this.getSidedPos(targetPos);
        if (targetSidedPos == null) {
            return new Object[]{null, "given target position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(3, sidedPos.getSide().func_176745_a()));
        EnumFacing targetSide = EnumFacing.func_82600_a((int)args.optInteger(4, targetSidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "source is not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return new Object[]{null, "source is no forge energy handler"};
        }
        TileEntity targetTileEntity = this.controllerWorld.func_175625_s(targetPos);
        if (targetTileEntity == null) {
            return new Object[]{null, "target is not a tile entity"};
        }
        if (!targetTileEntity.hasCapability(CapabilityEnergy.ENERGY, targetSide)) {
            return new Object[]{null, "target is no forge energy handler"};
        }
        IEnergyStorage handler = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
        IEnergyStorage targetHandler = (IEnergyStorage)targetTileEntity.getCapability(CapabilityEnergy.ENERGY, targetSide);
        if (!handler.canExtract()) {
            return new Object[]{null, "can not extract energy from source"};
        }
        if (!targetHandler.canReceive()) {
            return new Object[]{null, "can not insert energy into target"};
        }
        int transferred = 0;
        int maxTicksToSimulate = ConfigurationHandler.Settings.ignoreEnergyTransferLimits() ? ConfigurationHandler.Settings.getMaxEnergyTransferTicksPerCall() : 1;
        int lastTransfer = Integer.MAX_VALUE;
        ArrayList<String> errors = new ArrayList<String>();
        for (int simulatedTicks = 0; transferred < amount && lastTransfer > 0 && simulatedTicks < maxTicksToSimulate; ++simulatedTicks, transferred += simReceived) {
            int simAmount = handler.extractEnergy(amount - transferred, true);
            if (simAmount <= 0) {
                errors.add("extractable amount from source is 0");
                break;
            }
            simReceived = targetHandler.receiveEnergy(simAmount, true);
            if (simReceived <= 0) {
                errors.add("insertable amount into target is 0");
                break;
            }
            handler.extractEnergy(simReceived, false);
            targetHandler.receiveEnergy(simReceived, false);
        }
        return new Object[]{transferred, errors};
    }

    @Callback(doc="function(pos:table[, side: number]):table -- Get capacity and stored energy of the given energy handler")
    public Object[] getEnergy(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(1, sidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            return new Object[]{null, "not a forge energy handler"};
        }
        IEnergyStorage handler = (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY, side);
        HashMap<String, Constable> result = new HashMap<String, Constable>();
        result.put("capacity", Integer.valueOf(handler.getMaxEnergyStored()));
        result.put("stored", Integer.valueOf(handler.getEnergyStored()));
        result.put("canExtract", Boolean.valueOf(handler.canExtract()));
        result.put("canReceive", Boolean.valueOf(handler.canReceive()));
        return new Object[]{result};
    }

    @Callback(doc="function(sourcePos:table, amount:number, targetPos:table[, fluidName:string][, sourceSide:number[, targetSide:number]]):number -- Transfer fluids between two tanks")
    public Object[] transferFluid(Context context, Arguments args) {
        BlockPos targetPos;
        SidedPos targetSidedPos;
        BlockPos pos;
        SidedPos sidedPos;
        int nextArg = 0;
        if ((sidedPos = this.getSidedPos(pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, nextArg++)))) == null) {
            return new Object[]{null, "given source position is not connected to the network"};
        }
        int amount = args.checkInteger(nextArg++);
        if ((targetSidedPos = this.getSidedPos(targetPos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, nextArg++)))) == null) {
            return new Object[]{null, "given target position is not connected to the network"};
        }
        String fluidName = null;
        FluidStack extractStack = null;
        if (args.isString(nextArg) && (extractStack = FluidRegistry.getFluidStack((String)(fluidName = args.checkString(nextArg++)), (int)amount)) == null) {
            return new Object[]{null, "unknown fluid '" + fluidName + "'"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(nextArg++, sidedPos.getSide().func_176745_a()));
        EnumFacing targetSide = EnumFacing.func_82600_a((int)args.optInteger(nextArg++, targetSidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "source is not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return new Object[]{null, "source is not an fluid handler"};
        }
        TileEntity targetTileEntity = this.controllerWorld.func_175625_s(targetPos);
        if (targetTileEntity == null) {
            return new Object[]{null, "target is not a tile entity"};
        }
        if (!targetTileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, targetSide)) {
            return new Object[]{null, "target is not an fluid handler"};
        }
        IFluidHandler handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        IFluidHandler targetHandler = (IFluidHandler)targetTileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, targetSide);
        FluidStack simStack = extractStack != null ? handler.drain(extractStack, false) : handler.drain(amount, false);
        if (simStack == null) {
            return new Object[]{null, "can not drain from source tank"};
        }
        int simAmount = targetHandler.fill(simStack, false);
        if (simAmount <= 0) {
            return new Object[]{null, "can not fill target tank"};
        }
        FluidStack realStack = extractStack != null ? handler.drain(extractStack, true) : handler.drain(amount, true);
        targetHandler.fill(realStack, true);
        return new Object[]{simAmount};
    }

    @Callback(doc="function(pos:table[, side: number]):table -- List all fluids in the given tank")
    public Object[] getFluids(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(1, sidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            return new Object[]{null, "not a fluid handler"};
        }
        IFluidHandler handler = (IFluidHandler)tileEntity.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side);
        ArrayList result = new ArrayList();
        for (IFluidTankProperties tank : handler.getTankProperties()) {
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("capacity", tank.getCapacity());
            map.put("content", (Integer)tank.getContents());
            result.add(map);
        }
        return new Object[]{result};
    }

    @Callback(doc="function(sourcePos:table, sourceSlot:number, amount:number, targetPos:table[, sourceSide:number[, targetSide:number]]):number -- Transfer items between two inventories")
    public Object[] transferItem(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given source position is not connected to the network"};
        }
        int slot = args.checkInteger(1);
        int amount = args.checkInteger(2);
        BlockPos targetPos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 3));
        SidedPos targetSidedPos = this.getSidedPos(targetPos);
        if (targetSidedPos == null) {
            return new Object[]{null, "given target position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(4, sidedPos.getSide().func_176745_a()));
        EnumFacing targetSide = EnumFacing.func_82600_a((int)args.optInteger(5, targetSidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "source is not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return new Object[]{null, "source is not an item handler"};
        }
        TileEntity targetTileEntity = this.controllerWorld.func_175625_s(targetPos);
        if (targetTileEntity == null) {
            return new Object[]{null, "target is not a tile entity"};
        }
        if (!targetTileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide)) {
            return new Object[]{null, "target is not an item handler"};
        }
        IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        IItemHandler targetHandler = (IItemHandler)targetTileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, targetSide);
        ItemStack sourceStackSim = handler.extractItem(slot - 1, amount, true);
        if (sourceStackSim == null || sourceStackSim.func_190926_b()) {
            return new Object[]{null, "can not extract from source slot"};
        }
        ItemStack returnStackSim = ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)sourceStackSim, (boolean)true);
        int transferrableAmount = amount;
        if (returnStackSim != null && !returnStackSim.func_190926_b()) {
            transferrableAmount = sourceStackSim.func_190916_E() - returnStackSim.func_190916_E();
        }
        if (transferrableAmount > 0) {
            ItemStack sourceStackReal = handler.extractItem(slot - 1, transferrableAmount, false);
            ItemHandlerHelper.insertItemStacked((IItemHandler)targetHandler, (ItemStack)sourceStackReal, (boolean)false);
            return new Object[]{transferrableAmount};
        }
        return new Object[]{null, "can not insert into target"};
    }

    @Callback(doc="function(pos:table[, side: number]):table -- List all items in the given inventory")
    public Object[] getItems(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(1, sidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return new Object[]{null, "not an item handler"};
        }
        IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            result.add(stack.func_77946_l());
        }
        return new Object[]{result};
    }

    @Callback(doc="function(sourcePos:table, sourceSlot:number, database:address, entry:number[, sourceSide:number]) -- Store an itemstack from somewhere in the XNet network in a database upgrade")
    public Object[] store(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given source position is not connected to the network"};
        }
        int slot = args.checkInteger(1) - 1;
        String address = args.checkString(2);
        int entry = args.checkInteger(3) - 1;
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(4, sidedPos.getSide().func_176745_a()));
        Node databaseNode = this.node().network().node(address);
        if (databaseNode == null) {
            return new Object[]{null, "given component address does not exist"};
        }
        Environment databaseEnvironment = databaseNode.host();
        if (databaseEnvironment == null || !(databaseEnvironment instanceof Database)) {
            return new Object[]{null, "given component is no database"};
        }
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "not a tile entity"};
        }
        if (!tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return new Object[]{null, "not an item handler"};
        }
        IItemHandler handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        ItemStack stack = handler.getStackInSlot(slot);
        if (stack.func_190926_b()) {
            return new Object[]{null, "given slot in item handler is empty"};
        }
        Database database = (Database)databaseEnvironment;
        database.setStackInSlot(entry, stack.func_77946_l());
        return new Object[]{stack};
    }

    @Callback(doc="function(pos:table[, side: number]):table -- List all capabilities of the given block at the given or connected side")
    public Object[] getSupportedCapabilities(Context context, Arguments args) {
        BlockPos pos = this.toAbsolute(ConverterBlockPos.checkBlockPos(args, 0));
        SidedPos sidedPos = this.getSidedPos(pos);
        if (sidedPos == null) {
            return new Object[]{null, "given position is not connected to the network"};
        }
        EnumFacing side = EnumFacing.func_82600_a((int)args.optInteger(1, sidedPos.getSide().func_176745_a()));
        TileEntity tileEntity = this.controllerWorld.func_175625_s(pos);
        if (tileEntity == null) {
            return new Object[]{null, "not a tile entity"};
        }
        ArrayList<String> result = new ArrayList<String>();
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            result.add("items");
        }
        if (tileEntity.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)) {
            result.add("fluid");
        }
        if (tileEntity.hasCapability(CapabilityEnergy.ENERGY, side)) {
            result.add("energy");
        }
        return new Object[]{result};
    }

    @Callback(doc="function():table -- List all blocks connected to the XNet network")
    public Object[] getConnectedBlocks(Context context, Arguments args) {
        ArrayList result = new ArrayList();
        for (SidedPos pos : this.getControllerContext().getConnectedBlockPositions()) {
            String connectorName;
            HashMap<String, Object> map = new HashMap<String, Object>();
            IBlockState state = this.controllerWorld.func_180495_p(pos.getPos());
            map.put("pos", this.toRelative(pos.getPos()));
            map.put("side", pos.getSide());
            map.put("name", state.func_177230_c().getRegistryName());
            map.put("meta", state.func_177230_c().func_176201_c(state));
            BlockPos connectorPos = pos.getPos().func_177972_a(pos.getSide());
            String registryName = this.controllerWorld.func_180495_p(connectorPos).func_177230_c().getRegistryName().toString();
            if ((registryName.equals("xnet:advanced_connector") || registryName.equals("xnet:connector")) && (connectorName = (String)CachedReflectionHelper.getFieldValue(String.class, this.controllerWorld.func_175625_s(connectorPos), "name")) != null && connectorName.length() > 0) {
                map.put("connector", connectorName);
            }
            result.add(map);
        }
        return new Object[]{result};
    }

    public String preferredName() {
        return "xnet";
    }

    public int priority() {
        return 1;
    }
}

