/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.common.generators.ItemInventoryGenerator;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class ItemInvFrostyGen
extends ItemInventoryGenerator {
    private Item ICE = Item.func_150898_a((Block)Blocks.field_150432_aD);
    private Item PACKED_ICE = Item.func_150898_a((Block)Blocks.field_150403_cj);
    private Item SNOW = Item.func_150898_a((Block)Blocks.field_150433_aE);
    private Item SNOW_LAYER = Item.func_150898_a((Block)Blocks.field_150431_aC);
    private Item[] validItems = new Item[]{this.ICE, this.PACKED_ICE, Items.field_151126_ay, this.SNOW, this.SNOW_LAYER};
    private ArrayList<Item> validItemsArrayList = new ArrayList<Item>(Arrays.asList(this.validItems));

    public ItemInvFrostyGen() {
        super("inv_frosty_gen");
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        tooltip.add(StringHelper.getInfoText((String)"info.invgens.frosty"));
        this.addMoreInformation(stack, tooltip);
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return this.validItemsArrayList.contains(stack.func_77973_b());
    }

    @Override
    public int calculateTime(ItemStack stack) {
        if (!stack.func_190926_b()) {
            Item item = stack.func_77973_b();
            if (item.equals(this.SNOW_LAYER)) {
                return 500;
            }
            return 400;
        }
        return 0;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        Item fuel = this.getFuel(stack).func_77973_b();
        int minSend = fuel.equals(Items.field_151126_ay) ? 5 : (fuel.equals(this.SNOW) ? 20 : (fuel.equals(this.SNOW_LAYER) ? 2 : 40));
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), minSend);
    }

    @Override
    public void initModel() {
        super.initModel();
    }

    @Override
    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        super.func_77659_a(world, player, hand);
        if (!player.func_70093_af()) {
            player.openGui((Object)InventoryGenerators.instance, 4, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        ItemStack stack = player.func_184586_b(hand);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }
}

