/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.justenoughdimensions.util;

import com.google.gson.JsonObject;
import fi.dy.masa.justenoughdimensions.JustEnoughDimensions;
import fi.dy.masa.justenoughdimensions.client.render.DummyRenderer;
import fi.dy.masa.justenoughdimensions.client.render.SkyRenderer;
import fi.dy.masa.justenoughdimensions.util.JEDJsonUtils;
import fi.dy.masa.justenoughdimensions.util.JEDStringUtils;
import fi.dy.masa.justenoughdimensions.world.JEDWorldProperties;
import javax.annotation.Nullable;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.client.IRenderHandler;

public class ClientUtils {
    public static boolean setRenderersFrom(WorldProvider provider, @Nullable JsonObject obj) {
        if (obj == null) {
            return false;
        }
        boolean success = false;
        if (JEDJsonUtils.hasString(obj, "SkyRenderer")) {
            success |= ClientUtils.createAndSetRendererFromName(provider, JEDJsonUtils.getString(obj, "SkyRenderer"), RendererType.SKY);
        } else {
            int skyRenderType;
            int n = skyRenderType = JEDJsonUtils.hasInteger(obj, "SkyRenderType") ? JEDJsonUtils.getInteger(obj, "SkyRenderType") : 0;
            if (skyRenderType != 0) {
                int skyDisableFlags = JEDJsonUtils.hasInteger(obj, "SkyDisableFlags") ? JEDJsonUtils.getInteger(obj, "SkyDisableFlags") : 0;
                SkyRenderer.SkySettings skySettings = new SkyRenderer.SkySettings();
                skySettings.disableSun = (skyDisableFlags & 1) != 0;
                skySettings.disableMoon = (skyDisableFlags & 2) != 0;
                skySettings.disableStars = (skyDisableFlags & 4) != 0;
                skySettings.sunScale = JEDJsonUtils.hasFloat(obj, "SunScale") ? MathHelper.func_76131_a((float)JEDJsonUtils.getFloat(obj, "SunScale"), (float)0.0f, (float)16.0f) : 1.0f;
                skySettings.moonScale = JEDJsonUtils.hasFloat(obj, "MoonScale") ? MathHelper.func_76131_a((float)JEDJsonUtils.getFloat(obj, "MoonScale"), (float)0.0f, (float)16.0f) : 1.0f;
                skySettings.sunColor = JEDJsonUtils.hasString(obj, "SunColor") ? JEDStringUtils.hexStringToColor(JEDJsonUtils.getString(obj, "SunColor")) : new Vec3d(1.0, 1.0, 1.0);
                skySettings.moonColor = JEDJsonUtils.hasString(obj, "MoonColor") ? JEDStringUtils.hexStringToColor(JEDJsonUtils.getString(obj, "MoonColor")) : new Vec3d(1.0, 1.0, 1.0);
                provider.setSkyRenderer((IRenderHandler)new SkyRenderer(skyRenderType, skySettings));
                success = true;
            }
        }
        if (JEDJsonUtils.hasString(obj, "CloudRenderer")) {
            success |= ClientUtils.createAndSetRendererFromName(provider, JEDJsonUtils.getString(obj, "CloudRenderer"), RendererType.CLOUD);
        }
        if (JEDJsonUtils.hasString(obj, "WeatherRenderer")) {
            success |= ClientUtils.createAndSetRendererFromName(provider, JEDJsonUtils.getString(obj, "WeatherRenderer"), RendererType.WEATHER);
        }
        return success;
    }

    @Nullable
    public static boolean createAndSetRendererFromName(WorldProvider provider, String name, RendererType type) {
        try {
            DummyRenderer renderer = null;
            if ("DummyRenderer".equals(name)) {
                renderer = new DummyRenderer();
            } else {
                Class<?> clazz = Class.forName(name);
                if (clazz != null) {
                    renderer = (IRenderHandler)clazz.newInstance();
                }
            }
            if (renderer != null) {
                JustEnoughDimensions.logInfo("WorldUtils.setRenderersOnNonJEDWorld(): Setting a custom {} renderer '{}' for dimension {}", type.getName(), ((Object)((Object)renderer)).getClass().getName(), provider.getDimension());
                ClientUtils.setRenderer(provider, renderer, type);
                return true;
            }
        }
        catch (Exception e) {
            JustEnoughDimensions.logger.warn("Failed to create a {} renderer from class name '{}'", (Object)type.getName(), (Object)name, (Object)e);
        }
        return false;
    }

    private static void setRenderer(WorldProvider provider, IRenderHandler renderer, RendererType type) {
        switch (type) {
            case SKY: {
                provider.setSkyRenderer(renderer);
                break;
            }
            case CLOUD: {
                provider.setCloudRenderer(renderer);
                break;
            }
            case WEATHER: {
                provider.setWeatherRenderer(renderer);
            }
        }
    }

    @Nullable
    public static MusicTicker.MusicType getMusicTypeFromProperties(JEDWorldProperties props) {
        String name = props.getMusicType();
        return name != null ? ClientUtils.getMusicTypeFromName(name) : null;
    }

    @Nullable
    public static MusicTicker.MusicType getMusicTypeFromName(String name) {
        for (MusicTicker.MusicType type : MusicTicker.MusicType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        return null;
    }

    public static enum RendererType {
        SKY,
        CLOUD,
        WEATHER;


        public String getName() {
            return this.name().toLowerCase();
        }
    }
}

