/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.darkutils.handler;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.darkhax.darkutils.DarkUtils;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="darkutils")
public class FakePlayerHandler {
    public static final String USERNAME = "FAKE_PLAYER_DARK_UTILS";
    public static GameProfile PROFILE = new GameProfile(UUID.nameUUIDFromBytes("FAKE_PLAYER_DARK_UTILS".getBytes()), "FAKE_PLAYER_DARK_UTILS");
    private static Map<WorldServer, EntityPlayer> FAKE_PLAYERS = new HashMap<WorldServer, EntityPlayer>();

    public static EntityPlayer getFakePlayer(WorldServer world) {
        return FAKE_PLAYERS.computeIfAbsent(world, key -> new FakePlayerDU((WorldServer)key));
    }

    public static void causePlayerDamage(EntityLivingBase target, float amount) {
        try {
            if (target.func_130014_f_() instanceof WorldServer) {
                target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)FakePlayerHandler.getFakePlayer((WorldServer)target.func_130014_f_())), amount);
            }
        }
        catch (Exception e) {
            DarkUtils.LOGGER.warn("There was an error trying to damage " + target, new Object[0]);
            DarkUtils.LOGGER.catching((Throwable)e);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            FAKE_PLAYERS.remove(event.getWorld());
        }
    }

    private static class FakePlayerDU
    extends FakePlayer {
        public FakePlayerDU(WorldServer world) {
            super(world, PROFILE);
        }
    }
}

