/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.common.tileentity.TileEntityDoor;

public class MessageDoorOpen
implements IMessage {
    public BlockPos pos = BlockPos.field_177992_a;
    public boolean isOpen = false;
    public boolean isRemat;
    public boolean isDemat;
    public float alpha;
    public int lightLevel;

    public MessageDoorOpen() {
    }

    public MessageDoorOpen(BlockPos pos, TileEntityDoor door) {
        this.pos = pos;
        this.isOpen = !door.isLocked;
        this.isRemat = door.isRemat;
        this.isDemat = door.isDemat;
        this.lightLevel = door.getLightLevel();
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        this.isOpen = buf.readBoolean();
        this.isDemat = buf.readBoolean();
        this.isRemat = buf.readBoolean();
        this.alpha = buf.readFloat();
        this.lightLevel = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeBoolean(this.isOpen);
        buf.writeBoolean(this.isDemat);
        buf.writeBoolean(this.isRemat);
        buf.writeFloat(this.alpha);
        buf.writeInt(this.lightLevel);
    }

    public static class Handler
    implements IMessageHandler<MessageDoorOpen, IMessage> {
        public IMessage onMessage(final MessageDoorOpen mes, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Minecraft mc = Minecraft.func_71410_x();
                    TileEntity te = mc.field_71441_e.func_175625_s(mes.pos);
                    if (te instanceof TileEntityDoor) {
                        TileEntityDoor door = (TileEntityDoor)te;
                        door.setLocked(!mes.isOpen);
                        door.isDemat = mes.isDemat;
                        door.isRemat = mes.isRemat;
                        door.setLightLevel(mes.lightLevel);
                    }
                }
            });
            return null;
        }
    }
}

