/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.network.packets;

import io.netty.buffer.ByteBuf;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.tardis.mod.client.guis.GUICompanion;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityCompanion;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class MessageCompanion
implements IMessage {
    public int id;
    public GUICompanion.EnumAction action;

    public MessageCompanion() {
    }

    public MessageCompanion(int id, GUICompanion.EnumAction act) {
        this.id = id;
        this.action = act;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        this.action = Enum.valueOf(GUICompanion.EnumAction.class, ByteBufUtils.readUTF8String((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.action.name());
    }

    public static class Handler
    implements IMessageHandler<MessageCompanion, IMessage> {
        public IMessage onMessage(final MessageCompanion message, final MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_71121_q().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityCompanion comp = (EntityCompanion)ctx.getServerHandler().field_147369_b.func_71121_q().func_73045_a(message.id);
                    if (comp != null) {
                        if (message.action == GUICompanion.EnumAction.GO_TO_TARDIS) {
                            BlockPos pos;
                            WorldServer world = ctx.getServerHandler().field_147369_b.func_184102_h().func_71218_a(TDimensions.TARDIS_ID);
                            BlockPos blockPos = pos = TardisHelper.hasTardis(ctx.getServerHandler().field_147369_b.func_146103_bH().getId()) ? TardisHelper.getTardis(ctx.getServerHandler().field_147369_b.func_146103_bH().getId()) : BlockPos.field_177992_a;
                            if (pos.equals((Object)BlockPos.field_177992_a)) {
                                return;
                            }
                            TileEntityTardis tardis = Helper.getTardis(world.func_175625_s(pos));
                            if (tardis != null) {
                                comp.setSit(true);
                                comp.tardisPos = tardis.getLocation().func_185334_h();
                            }
                        } else if (message.action == GUICompanion.EnumAction.FOLLOW) {
                            comp.setSit(!comp.getSit());
                            comp.tardisPos = BlockPos.field_177992_a;
                        } else if (message.action == GUICompanion.EnumAction.BRING_TARDIS) {
                            if (comp.field_71093_bK != TDimensions.TARDIS_ID) {
                                TileEntityTardis tardis;
                                WorldServer world = ctx.getServerHandler().field_147369_b.field_70170_p.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                                if (comp.getOwner() != null && TardisHelper.hasTardis(comp.getOwner().func_146103_bH().getId()) && (tardis = Helper.getTardis(world.func_175625_s(TardisHelper.getTardis(comp.getOwner().func_146103_bH().getId())))) != null) {
                                    comp.setSit(true);
                                    comp.tardisPos = tardis.getLocation();
                                    comp.flyTardis = true;
                                }
                            }
                        } else if (message.action == GUICompanion.EnumAction.TAKE_HELD) {
                            ItemStack oldHeld = comp.func_184614_ca();
                            if (!oldHeld.func_190926_b()) {
                                InventoryHelper.func_180173_a((World)ctx.getServerHandler().field_147369_b.field_70170_p, (double)comp.field_70165_t, (double)comp.field_70163_u, (double)comp.field_70161_v, (ItemStack)oldHeld);
                            }
                            comp.func_184611_a(EnumHand.MAIN_HAND, ctx.getServerHandler().field_147369_b.func_184586_b(EnumHand.MAIN_HAND));
                            ctx.getServerHandler().field_147369_b.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                        }
                    }
                }
            });
            return null;
        }
    }
}

