/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.tileentity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.tardis.mod.Tardis;
import net.tardis.mod.api.events.tardis.TardisEnterEvent;
import net.tardis.mod.api.events.tardis.TardisExitEvent;
import net.tardis.mod.client.models.consoles.ModelConsole;
import net.tardis.mod.common.blocks.BlockTardisTop;
import net.tardis.mod.common.blocks.TBlocks;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityTardis;
import net.tardis.mod.common.entities.controls.ControlDimChange;
import net.tardis.mod.common.entities.controls.ControlDirection;
import net.tardis.mod.common.entities.controls.ControlDoor;
import net.tardis.mod.common.entities.controls.ControlDoorSwitch;
import net.tardis.mod.common.entities.controls.ControlFastReturn;
import net.tardis.mod.common.entities.controls.ControlFuel;
import net.tardis.mod.common.entities.controls.ControlLandType;
import net.tardis.mod.common.entities.controls.ControlLaunch;
import net.tardis.mod.common.entities.controls.ControlMag;
import net.tardis.mod.common.entities.controls.ControlPhone;
import net.tardis.mod.common.entities.controls.ControlRandom;
import net.tardis.mod.common.entities.controls.ControlStabilizers;
import net.tardis.mod.common.entities.controls.ControlTelepathicCircuts;
import net.tardis.mod.common.entities.controls.ControlWaypoint;
import net.tardis.mod.common.entities.controls.ControlX;
import net.tardis.mod.common.entities.controls.ControlY;
import net.tardis.mod.common.entities.controls.ControlZ;
import net.tardis.mod.common.entities.controls.EntityControl;
import net.tardis.mod.common.enums.EnumEvent;
import net.tardis.mod.common.enums.EnumTardisState;
import net.tardis.mod.common.events.TardisCrashEvent;
import net.tardis.mod.common.events.TardisLandEvent;
import net.tardis.mod.common.events.TardisTakeOffEvent;
import net.tardis.mod.common.misc.TardisControlFactory;
import net.tardis.mod.common.sounds.InteriorHum;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.systems.SystemFlight;
import net.tardis.mod.common.systems.SystemStabilizers;
import net.tardis.mod.common.systems.TardisSystems;
import net.tardis.mod.common.tileentity.TileEntityDoor;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.network.NetworkHandler;
import net.tardis.mod.network.packets.MessageStopHum;
import net.tardis.mod.util.SpaceTimeCoord;
import net.tardis.mod.util.TardisTeleporter;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.RiftHelper;

public class TileEntityTardis
extends TileEntity
implements ITickable,
IInventory {
    private Random rand = new Random();
    private int ticksToTravel = 0;
    private int ticks = 0;
    private BlockPos tardisLocation = BlockPos.field_177992_a;
    private BlockPos tardisDestination = BlockPos.field_177992_a;
    public int dimension = 0;
    public int destDim = 0;
    public int dimIndex = 0;
    private static IBlockState blockBase = TBlocks.tardis.func_176223_P();
    private IBlockState blockTop = TBlocks.tardis_top_tt.func_176223_P();
    private static final int MAX_TARDIS_SPEED = 8;
    public NonNullList<SpaceTimeCoord> saveCoords = NonNullList.func_191197_a((int)15, (Object)SpaceTimeCoord.ORIGIN);
    public NonNullList<ItemStack> buffer = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    public EntityControl[] controls;
    private float artron = 256.0f;
    private float maxArtron = 256.0f;
    private boolean isFueling = false;
    private boolean shouldDelayLoop = true;
    private ForgeChunkManager.Ticket tardisTicket;
    private boolean chunkLoadTick = true;
    public boolean landOnSurface = true;
    public EnumFacing facing = EnumFacing.NORTH;
    public String currentDimName = "";
    public String targetDimName = "";
    public int totalTimeToTravel;
    public int rotorUpdate = 0;
    public int frame = 0;
    private boolean hadsEnabled = false;
    private boolean forceFields = false;
    public int magnitude = 10;
    public EnumEvent currentEvent = EnumEvent.NONE;
    public TardisSystems.BaseSystem[] systems;
    private EnumTardisState currentState = EnumTardisState.NORMAL;
    private EnumCourseCorrect courseCorrect = EnumCourseCorrect.NONE;
    public List<TardisControlFactory> controlClases = new ArrayList<TardisControlFactory>();
    public int waypointIndex = 0;
    public SpaceTimeCoord returnLocation = new SpaceTimeCoord(this.getLocation(), this.dimension, "");
    public InteriorHum hum = InteriorHum.DEFAULT;
    public boolean overrideStabilizers = false;
    public boolean soundChanged = false;
    private boolean isStealth = false;
    private EntityTardis entity;
    private HashMap<UUID, BlockPos> bedPositions = new HashMap();
    private int landingSoundDuration = 200;

    public TileEntityTardis() {
        if (this.systems == null) {
            this.systems = this.createSystems();
        }
        this.controlClases.add(ControlDimChange::new);
        this.controlClases.add(ControlDirection::new);
        this.controlClases.add(ControlDoorSwitch::new);
        this.controlClases.add(ControlFastReturn::new);
        this.controlClases.add(ControlFuel::new);
        this.controlClases.add(ControlLandType::new);
        this.controlClases.add(ControlLaunch::new);
        this.controlClases.add(ControlMag::new);
        this.controlClases.add(ControlPhone::new);
        this.controlClases.add(ControlRandom::new);
        this.controlClases.add(ControlStabilizers::new);
        this.controlClases.add(ControlTelepathicCircuts::new);
        this.controlClases.add(ControlX::new);
        this.controlClases.add(ControlY::new);
        this.controlClases.add(ControlZ::new);
        this.controlClases.add(ControlWaypoint::new);
    }

    public void func_73660_a() {
        WorldServer ws;
        if (this.hum != null && (this.soundChanged || this.field_145850_b.func_82737_E() % (long)this.hum.getTicks() == 0L) && !this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), this.hum.getSoundEvent(), SoundCategory.AMBIENT, 0.25f, 1.0f);
            this.soundChanged = false;
        }
        if (this.ticksToTravel > 0) {
            --this.ticksToTravel;
            if (this.ticksToTravel % 20 == 0) {
                this.artron -= this.calcFuelUse();
            }
            if (this.ticksToTravel <= 0) {
                this.travel();
            }
            if (this.ticksToTravel == 200 && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.tardis_land, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (this.ticksToTravel == this.totalTimeToTravel - 1) {
                if (!this.field_145850_b.field_72995_K) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.takeoff, SoundCategory.BLOCKS, 1.0f, 1.0f);
                } else if (this.ticksToTravel > this.landingSoundDuration && this.ticksToTravel < this.totalTimeToTravel - this.landingSoundDuration && this.ticksToTravel % 40 == 0) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.loop, SoundCategory.BLOCKS, 0.5f, 1.0f);
                }
            }
            if ((double)this.artron <= 0.0 && this.ticksToTravel % 5 == 0) {
                this.crash();
            }
            if (this.field_145850_b.field_72995_K) {
                this.frame = this.frame + 1 >= ModelConsole.frames.length ? 0 : ++this.frame;
                if (TardisConfig.MISC.camShake && (this.ticksToTravel < 200 || this.totalTimeToTravel - this.ticksToTravel < 200)) {
                    for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(40.0))) {
                        player.field_70125_A = (float)((double)player.field_70125_A + (double)(this.rand.nextInt(10) - 5) * 0.1);
                        player.field_70177_z = (float)((double)player.field_70177_z + (double)(this.rand.nextInt(10) - 5) * 0.1);
                    }
                }
                if (this.getCourseCorrect() != EnumCourseCorrect.NONE) {
                    for (EntityPlayer player : this.field_145850_b.func_72872_a(EntityPlayer.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(40.0))) {
                        player.field_70125_A = (float)((double)player.field_70125_A + (double)(this.rand.nextInt(10) - 5) * 0.1);
                        player.field_70177_z = (float)((double)player.field_70177_z + (double)(this.rand.nextInt(10) - 5) * 0.1);
                    }
                }
            }
            if (!this.field_145850_b.field_72995_K && !this.getCanFly()) {
                this.crash();
            }
        } else if (this.isFueling() && !this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 20L == 0L) {
            ws = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
            this.setArtron(this.getArtron() + TardisConfig.MISC.artronRechargeRate * (float)(RiftHelper.isRift(ws.func_175726_f(this.tardisLocation).func_76632_l(), (World)ws) ? 2 : 1));
        }
        ++this.ticks;
        if (this.ticks >= 20) {
            this.ticks = 0;
            this.updateServer();
        }
        if (this.chunkLoadTick) {
            this.chunkLoadTick = false;
            if (!this.field_145850_b.field_72995_K) {
                ws = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
                if (ws == null) {
                    return;
                }
                this.tardisTicket = ForgeChunkManager.requestTicket((Object)Tardis.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.tardisTicket, (ChunkPos)this.field_145850_b.func_175726_f(this.func_174877_v()).func_76632_l());
            }
        }
        if (this.field_145850_b.field_72995_K && !this.isInFlight()) {
            this.frame = 0;
        }
        this.createControls();
        for (TardisSystems.BaseSystem sys : this.systems) {
            if (sys != null) {
                sys.onUpdate(this.field_145850_b, this.func_174877_v());
                continue;
            }
            ArrayList<TardisSystems.BaseSystem> systems = new ArrayList<TardisSystems.BaseSystem>();
            for (int i = 0; i < this.systems.length; ++i) {
                if (this.systems[i] == null) continue;
                systems.add(this.systems[i]);
            }
            this.systems = systems.toArray(new TardisSystems.BaseSystem[0]);
        }
    }

    public void travel() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos nPos;
            Random rand = new Random();
            this.ticksToTravel = 0;
            WorldServer dWorld = this.field_145850_b.func_73046_m().func_71218_a(this.destDim);
            BlockPos blockPos = nPos = Helper.isSafe((World)dWorld, this.getDestination(), this.facing) ? this.getDestination() : this.getLandingBlock((World)dWorld, this.getDestination());
            if (!dWorld.func_175723_af().func_177746_a(nPos)) {
                nPos = this.getLandingBlock((World)dWorld, new BlockPos(dWorld.func_175723_af().func_177731_f(), (double)nPos.func_177956_o(), dWorld.func_175723_af().func_177721_g()));
            }
            if (nPos != null) {
                if (dWorld.func_175625_s(nPos.func_177977_b()) instanceof TileEntityDoor) {
                    TileEntityDoor door = (TileEntityDoor)dWorld.func_175625_s(nPos.func_177977_b());
                    TileEntityTardis otherTardis = (TileEntityTardis)this.field_145850_b.func_175625_s(door.getConsolePos());
                    if (!(door.isDemat || door.isRemat || otherTardis == null || otherTardis.hadsEnabled)) {
                        nPos = ((TileEntityDoor)dWorld.func_175625_s(nPos.func_177977_b())).getConsolePos().func_177982_a(rand.nextInt(5) - 2, 0, rand.nextInt(5) - 2);
                        dWorld = DimensionManager.getWorld((int)TDimensions.TARDIS_ID);
                        for (int landCheck = 0; landCheck < 10; ++landCheck) {
                            nPos.func_177982_a(rand.nextInt(5) - 2, 0, rand.nextInt(5) - 2);
                            if (dWorld.func_180495_p(nPos).func_185904_a() == Material.field_151579_a && dWorld.func_180495_p(nPos.func_177984_a()).func_185904_a() == Material.field_151579_a) break;
                        }
                        this.destDim = TDimensions.TARDIS_ID;
                    } else if (otherTardis != null && otherTardis.isHADSEnabled()) {
                        otherTardis.startHADS();
                    }
                }
                dWorld.func_175656_a(nPos, blockBase);
                dWorld.func_175656_a(nPos.func_177984_a(), this.blockTop.func_177226_a((IProperty)BlockTardisTop.FACING, (Comparable)this.facing));
                BlockPos consolePos = this.func_174877_v();
                BlockPos landPos = nPos;
                dWorld.func_152344_a(() -> {
                    WorldServer dWorld1 = this.field_145850_b.func_73046_m().func_71218_a(this.destDim);
                    TileEntity te = dWorld1.func_175625_s(landPos.func_177984_a());
                    if (te instanceof TileEntityDoor) {
                        TileEntityDoor door = (TileEntityDoor)te;
                        door.setConsolePos(consolePos);
                        door.setRemat();
                        door.setStealth(this.isStealth);
                    }
                });
                this.setLocation(nPos);
                this.dimension = this.destDim;
                this.setDesination(nPos, this.dimension);
            }
            this.func_70296_d();
            DimensionType type = DimensionManager.getProviderType((int)this.dimension);
            if (type != null) {
                this.currentDimName = type.func_186065_b();
            }
            MinecraftForge.EVENT_BUS.post((Event)new TardisLandEvent(this));
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.drum_beat, SoundCategory.BLOCKS, 0.5f, 1.0f);
            for (TardisSystems.BaseSystem sys : this.systems) {
                sys.wear();
            }
            ControlDoor door = this.getDoor();
            if (door != null) {
                door.setBotiUpdate(true);
            }
        }
        this.shouldDelayLoop = true;
        for (TardisSystems.BaseSystem sys : this.systems) {
            sys.onUpdate(this.field_145850_b, this.func_174877_v());
        }
        this.setLocation(this.getCurrentPosOnPath());
        this.overrideStabilizers = false;
    }

    public void updateServer() {
        if (!this.field_145850_b.field_72995_K && !this.func_145837_r()) {
            for (EntityPlayerMP player : this.field_145850_b.func_72872_a(EntityPlayerMP.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(16.0))) {
                player.field_71135_a.func_147359_a((Packet)this.func_189518_D_());
            }
        }
    }

    public BlockPos getLandingBlock(World world, BlockPos pos) {
        int i;
        BlockPos landPos = pos;
        Random rand = new Random();
        if (this.landOnSurface) {
            for (int tries = 0; tries < 20; ++tries) {
                landPos = Helper.getSafeHigherPos(world, pos.func_177982_a(rand.nextInt(20) - 10, 0, rand.nextInt(20) - 10), this.getFacing());
                if (landPos.equals((Object)BlockPos.field_177992_a)) continue;
                return landPos;
            }
            for (int t = 0; t < 20; ++t) {
                if ((landPos = Helper.getSafePosLower(landPos, world, this.getFacing())).equals((Object)BlockPos.field_177992_a)) continue;
                return landPos;
            }
        }
        for (i = 0; i < 20; ++i) {
            landPos = Helper.getSafePosLower(pos.func_177982_a(rand.nextInt(20) - 10, 0, rand.nextInt(20) - 10), world, this.getFacing());
            if (landPos.equals((Object)BlockPos.field_177992_a)) continue;
            return landPos;
        }
        for (i = 0; i < 20; ++i) {
            if ((landPos = Helper.getSafeHigherPos(world, landPos, this.getFacing())).equals((Object)BlockPos.field_177992_a)) continue;
            return landPos;
        }
        return pos;
    }

    public void func_145839_a(NBTTagCompound tag) {
        Entity entity;
        super.func_145839_a(tag);
        NBTTagCompound tardisTag = tag.func_74775_l("tardis");
        this.ticksToTravel = tardisTag.func_74762_e("timeLeft");
        this.tardisDestination = BlockPos.func_177969_a((long)tardisTag.func_74763_f("tardisDest"));
        this.tardisLocation = BlockPos.func_177969_a((long)tardisTag.func_74763_f("tardisLoc"));
        this.dimension = tardisTag.func_74762_e("dim");
        this.destDim = tardisTag.func_74762_e("destDim");
        this.artron = tardisTag.func_74760_g("fuel");
        this.landOnSurface = tardisTag.func_74767_n("landOnGround");
        NBTTagList coordList = tardisTag.func_150295_c("coordList", 10);
        int i = 0;
        for (NBTBase base : coordList) {
            this.saveCoords.set(i, (Object)SpaceTimeCoord.readFromNBT((NBTTagCompound)base));
            ++i;
        }
        NBTTagList componentList = tardisTag.func_150295_c("componentList", 10);
        int cListIndex = 0;
        for (NBTBase comp : componentList) {
            this.buffer.set(cListIndex, (Object)new ItemStack((NBTTagCompound)comp));
            ++cListIndex;
        }
        this.totalTimeToTravel = tardisTag.func_74762_e("maxTime");
        this.magnitude = tardisTag.func_74762_e("magnitude");
        this.hadsEnabled = tardisTag.func_74767_n("isHADSEnabled");
        this.blockTop = Block.func_176220_d((int)tardisTag.func_74762_e("exterior"));
        ArrayList<TardisSystems.BaseSystem> newSystems = new ArrayList<TardisSystems.BaseSystem>();
        NBTTagList systemList = tardisTag.func_150295_c("system_list", 10);
        for (NBTBase base : systemList) {
            NBTTagCompound systemTag = (NBTTagCompound)base;
            TardisSystems.BaseSystem sys = TardisSystems.createFromName(systemTag.func_74779_i("id"));
            if (sys != null) {
                sys.readFromNBT(systemTag);
            }
            newSystems.add(sys);
        }
        if (newSystems != null) {
            for (TardisSystems.BaseSystem sys : this.systems) {
                if (newSystems.contains(sys)) continue;
                newSystems.add(sys);
            }
            this.systems = newSystems.toArray(new TardisSystems.BaseSystem[0]);
        }
        this.currentState = Enum.valueOf(EnumTardisState.class, tardisTag.func_74779_i("tardis_state_id"));
        this.waypointIndex = tardisTag.func_74762_e("waypoint_index");
        this.hum = tardisTag.func_74762_e("hum") != InteriorHum.hums.size() ? InteriorHum.hums.get(tardisTag.func_74762_e("hum")) : null;
        this.isStealth = tardisTag.func_74767_n("stealth");
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K && tardisTag.func_74764_b("entity_id") && (entity = ((WorldServer)this.field_145850_b).func_73046_m().func_175576_a(tardisTag.func_186857_a("entity_id"))) instanceof EntityTardis) {
            this.entity = (EntityTardis)entity;
        }
        if (tardisTag.func_74764_b("max_artron")) {
            this.maxArtron = tardisTag.func_74760_g("max_artron");
        }
        NBTTagList bedList = tardisTag.func_150295_c("bed_list", 10);
        for (NBTBase base : bedList) {
            NBTTagCompound bedTag = (NBTTagCompound)base;
            this.bedPositions.put(UUID.fromString(bedTag.func_74779_i("player_id")), BlockPos.func_177969_a((long)bedTag.func_74763_f("pos")));
        }
    }

    public void setShouldLandOnSurface(boolean b) {
        this.landOnSurface = b;
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound tardisTag = new NBTTagCompound();
        tardisTag.func_74768_a("timeLeft", this.ticksToTravel);
        tardisTag.func_74772_a("tardisDest", this.tardisDestination.func_177986_g());
        tardisTag.func_74772_a("tardisLoc", this.tardisLocation.func_177986_g());
        tardisTag.func_74768_a("dim", this.dimension);
        tardisTag.func_74768_a("destDim", this.destDim);
        tardisTag.func_74776_a("fuel", this.artron);
        tardisTag.func_74757_a("landOnGround", this.landOnSurface);
        NBTTagList cList = new NBTTagList();
        for (Object co : this.saveCoords) {
            cList.func_74742_a((NBTBase)((SpaceTimeCoord)co).writeToNBT(new NBTTagCompound()));
        }
        tardisTag.func_74782_a("coordList", (NBTBase)cList);
        NBTTagList compoentList = new NBTTagList();
        for (TardisSystems.BaseSystem[] stack : this.buffer) {
            compoentList.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        tardisTag.func_74782_a("componentList", (NBTBase)compoentList);
        tardisTag.func_74768_a("maxTime", this.totalTimeToTravel);
        tardisTag.func_74768_a("magnitude", this.magnitude);
        tardisTag.func_74757_a("isHADSEnabled", this.hadsEnabled);
        tardisTag.func_74768_a("exterior", Block.func_176210_f((IBlockState)this.blockTop));
        NBTTagList systemList = new NBTTagList();
        for (TardisSystems.BaseSystem sys : this.systems) {
            if (sys == null) continue;
            String id = TardisSystems.getIdBySystem(sys);
            if (id == null || id.isEmpty()) {
                System.err.println(id + " IS NOT A VAILD ID");
                break;
            }
            NBTTagCompound sysTag = new NBTTagCompound();
            sysTag.func_74778_a("id", id);
            systemList.func_74742_a((NBTBase)sys.writetoNBT(sysTag));
        }
        tardisTag.func_74782_a("system_list", (NBTBase)systemList);
        tardisTag.func_74778_a("tardis_state_id", this.currentState.name());
        tardisTag.func_74768_a("waypoint_index", this.waypointIndex);
        tardisTag.func_74768_a("hum", this.hum != null ? InteriorHum.hums.indexOf(this.hum) : InteriorHum.hums.size());
        tardisTag.func_74757_a("stealth", this.isStealth);
        if (this.getTardisEntity() != null) {
            tardisTag.func_186854_a("entity_uuid", this.getTardisEntity().func_110124_au());
        }
        tardisTag.func_74776_a("max_artron", this.maxArtron);
        NBTTagList bedList = new NBTTagList();
        for (Map.Entry<UUID, BlockPos> entry : this.bedPositions.entrySet()) {
            NBTTagCompound bedTag = new NBTTagCompound();
            bedTag.func_74778_a("player_id", entry.getKey().toString());
            bedTag.func_74772_a("pos", entry.getValue().func_177986_g());
            bedList.func_74742_a((NBTBase)bedTag);
        }
        tardisTag.func_74782_a("bed_list", (NBTBase)bedList);
        tag.func_74782_a("tardis", (NBTBase)tardisTag);
        return super.func_189515_b(tag);
    }

    public void setDesination(BlockPos pos, int dimension) {
        if (Helper.isThisBlockBehindTheWorldBorder(pos, dimension)) {
            this.tardisDestination = pos.func_185334_h();
            if (Helper.isDimensionBlocked(dimension)) {
                dimension = 0;
            }
            this.destDim = dimension;
            this.func_70296_d();
            if (!this.field_145850_b.field_72995_K) {
                DimensionType type = DimensionManager.getProviderType((int)dimension);
                if (type != null) {
                    this.targetDimName = type.func_186065_b();
                }
                DimensionType currentType = DimensionManager.getProviderType((int)this.dimension);
                if (type != null) {
                    this.currentDimName = currentType.func_186065_b();
                }
            }
            if (this.isInFlight()) {
                this.ticksToTravel += this.calcTimeToTravel() - 400;
                this.totalTimeToTravel += this.ticksToTravel;
            }
        }
    }

    public void setAbsoluteDesination(BlockPos pos, int dimension) {
        this.tardisDestination = pos.func_185334_h();
        this.destDim = dimension;
        this.func_70296_d();
        if (!this.field_145850_b.field_72995_K) {
            DimensionType type = DimensionManager.getProviderType((int)dimension);
            if (type != null) {
                this.targetDimName = type.func_186065_b();
            }
            DimensionType currentType = DimensionManager.getProviderType((int)this.dimension);
            if (type != null) {
                this.currentDimName = currentType.func_186065_b();
            }
        }
    }

    public int calcTimeToTravel() {
        double dist = this.tardisLocation.func_185332_f(this.tardisDestination.func_177958_n(), this.tardisDestination.func_177956_o(), this.tardisDestination.func_177952_p());
        return (int)(dist / (double)(8 * (this.getSystem(SystemStabilizers.class).isOn() ? 1 : 2)) + 400.0 + (double)(this.dimension == this.destDim ? 0 : 300));
    }

    public BlockPos getDestination() {
        return this.tardisDestination;
    }

    public BlockPos getLocation() {
        return this.tardisLocation;
    }

    public void setLocation(BlockPos pos) {
        this.tardisLocation = pos.func_185334_h();
        this.func_70296_d();
    }

    public int getTargetDim() {
        return this.destDim;
    }

    public int getTicks() {
        return this.ticksToTravel;
    }

    public boolean isInFlight() {
        return this.ticksToTravel > 0;
    }

    public boolean isFueling() {
        return this.isFueling;
    }

    public void setFueling(boolean b) {
        this.isFueling = b;
        this.func_70296_d();
    }

    public void setArtron(float f) {
        this.artron = f > this.maxArtron ? this.maxArtron : (f < 0.0f ? 0.0f : f);
        this.func_70296_d();
    }

    public void setSpaceTimeCoordnate(SpaceTimeCoord co) {
        this.setDesination(co.getPos(), co.getDimension());
    }

    public boolean startFlight() {
        TardisTakeOffEvent event = new TardisTakeOffEvent(this);
        if (MinecraftForge.EVENT_BUS.post((Event)event) || event.getFuel() <= 0.0f || event.getDestination() == null || event.getDestination() == BlockPos.field_177992_a || !this.getCanFly()) {
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.engine_stutter, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return false;
        }
        if (this.entity != null) {
            this.entity.func_70106_y();
            this.entity = null;
        }
        this.shouldDelayLoop = true;
        this.totalTimeToTravel = this.ticksToTravel = this.calcTimeToTravel();
        this.setFueling(false);
        if (!this.field_145850_b.field_72995_K) {
            WorldServer oWorld = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
            oWorld.func_152344_a(() -> {
                if (oWorld.func_175625_s(this.tardisLocation.func_177984_a()) != null) {
                    ((TileEntityDoor)oWorld.func_175625_s(this.tardisLocation.func_177984_a())).setDemat();
                }
            });
            this.returnLocation = new SpaceTimeCoord(this.getLocation(), this.dimension, "Return Location");
        }
        this.func_70296_d();
        return true;
    }

    public boolean getCanFly() {
        for (TardisSystems.BaseSystem s : this.systems) {
            if (!s.shouldStopFlight()) continue;
            return false;
        }
        return true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -1, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("dim", this.dimension);
        tag.func_74768_a("destDim", this.destDim);
        tag.func_74772_a("loc", this.getLocation().func_177986_g());
        tag.func_74772_a("dest", this.getDestination().func_177986_g());
        tag.func_74776_a("fuel", this.artron);
        tag.func_74768_a("timeLeft", this.ticksToTravel);
        tag.func_74768_a("maxTime", this.totalTimeToTravel);
        tag.func_74778_a("currentDimName", this.currentDimName);
        tag.func_74778_a("targetDimName", this.targetDimName);
        if (this.controls != null && this.controls.length > 0) {
            NBTTagList list = new NBTTagList();
            for (EntityControl e : this.controls) {
                list.func_74742_a((NBTBase)new NBTTagInt(e.func_145782_y()));
            }
            tag.func_74782_a("control_ids", (NBTBase)list);
        }
        tag.func_74768_a("facing", this.facing.func_176736_b());
        tag.func_74768_a("exterior", Block.func_176210_f((IBlockState)this.blockTop));
        NBTTagList sysList = new NBTTagList();
        for (TardisSystems.BaseSystem s : this.systems) {
            NBTTagCompound sT = new NBTTagCompound();
            sT.func_74778_a("id", TardisSystems.getIdBySystem(s));
            s.writetoNBT(sT);
            sysList.func_74742_a((NBTBase)sT);
        }
        tag.func_74782_a("system_list", (NBTBase)sysList);
        tag.func_74778_a("course_correct", this.getCourseCorrect().name());
        tag.func_74768_a("waypoint_index", this.waypointIndex);
        return tag;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        if (this.field_145850_b.field_72995_K) {
            NBTTagCompound tag = pkt.func_148857_g();
            this.destDim = tag.func_74762_e("destDim");
            this.dimension = tag.func_74762_e("dim");
            this.tardisDestination = BlockPos.func_177969_a((long)tag.func_74763_f("dest"));
            this.tardisLocation = BlockPos.func_177969_a((long)tag.func_74763_f("loc"));
            this.artron = tag.func_74760_g("fuel");
            this.ticksToTravel = tag.func_74762_e("timeLeft");
            this.totalTimeToTravel = tag.func_74762_e("maxTime");
            this.targetDimName = tag.func_74779_i("targetDimName");
            this.currentDimName = tag.func_74779_i("currentDimName");
            NBTTagList list = tag.func_150295_c("control_ids", 3);
            ArrayList<Entity> controls = new ArrayList<Entity>();
            for (NBTBase base : list) {
                if (!(base instanceof NBTTagInt)) continue;
                int i = ((NBTTagInt)base).func_150287_d();
                controls.add(this.field_145850_b.func_73045_a(i));
            }
            this.controls = controls.toArray(new EntityControl[0]);
            this.facing = EnumFacing.func_176731_b((int)tag.func_74762_e("facing"));
            this.blockTop = Block.func_176220_d((int)tag.func_74762_e("exterior"));
            ArrayList<TardisSystems.BaseSystem> systems = new ArrayList<TardisSystems.BaseSystem>();
            for (NBTBase base : tag.func_150295_c("system_list", 10)) {
                NBTTagCompound sysTag = (NBTTagCompound)base;
                TardisSystems.BaseSystem system = TardisSystems.createFromName(sysTag.func_74779_i("id"));
                system.readFromNBT(sysTag);
                systems.add(system);
            }
            this.systems = systems.toArray(new TardisSystems.BaseSystem[0]);
            this.setCourseEvent(Enum.valueOf(EnumCourseCorrect.class, tag.func_74779_i("course_correct")));
            this.waypointIndex = tag.func_74762_e("waypoint_index");
        }
    }

    public void setTargetDimension(int id) {
        this.setDesination(this.getLocation(), id);
    }

    public void onLoad() {
        super.onLoad();
        this.updateServer();
    }

    public boolean createControls() {
        if (!(this.field_145850_b.field_72995_K || this.controls != null && this.controls.length != 0)) {
            ArrayList ec = new ArrayList();
            for (TardisControlFactory cont : this.controlClases) {
                ec.add(cont.createControl(this));
            }
            for (EntityControl con : ec) {
                con.func_70107_b((double)this.func_174877_v().func_177958_n() + con.getOffset((TileEntityTardis)this).field_72450_a + 0.5, (double)this.func_174877_v().func_177956_o() + con.getOffset((TileEntityTardis)this).field_72448_b + 1.0, (double)this.func_174877_v().func_177952_p() + con.getOffset((TileEntityTardis)this).field_72449_c + 0.5);
                this.field_145850_b.func_72838_d((Entity)con);
            }
            this.controls = ec.toArray(new EntityControl[0]);
            return true;
        }
        return false;
    }

    public boolean isStealthMode() {
        return this.isStealth;
    }

    public void setStealthMode(boolean stealth) {
        TileEntity te;
        this.isStealth = stealth;
        if (!this.field_145850_b.field_72995_K && !this.isInFlight() && (te = this.field_145850_b.func_73046_m().func_71218_a(this.dimension).func_175625_s(this.getLocation().func_177984_a())) != null && te instanceof TileEntityDoor) {
            ((TileEntityDoor)te).setStealth(this.isStealth);
        }
    }

    public void func_145843_s() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.tardisTicket);
        if (this.controls != null) {
            for (EntityControl cont : this.controls) {
                cont.func_70106_y();
            }
        }
        super.func_145843_s();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(3.0);
    }

    public <T> T getControl(Class<T> clazz) {
        if (this.controls == null || this.controls.length == 0) {
            this.createControls();
        }
        for (EntityControl c : this.controls) {
            if (c.getClass() != clazz) continue;
            return (T)c;
        }
        return null;
    }

    public void crash(boolean explode) {
        if (!this.field_145850_b.field_72995_K) {
            WorldServer ws = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
            BlockPos crashSite = this.getCurrentPosOnPath();
            this.setDesination(crashSite, this.dimension);
            MinecraftForge.EVENT_BUS.post((Event)new TardisCrashEvent(this, crashSite, this.dimension));
            if (explode) {
                ws.func_72876_a(null, (double)crashSite.func_177958_n(), (double)crashSite.func_177956_o(), (double)crashSite.func_177952_p(), 3.0f, true);
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.ticksToTravel = 0;
            this.field_145850_b.func_184133_a(null, this.func_174877_v(), TSounds.cloister_bell, SoundCategory.BLOCKS, 1.0f, 1.0f);
        } else if (explode) {
            for (int i = 0; i < 120; ++i) {
                double offX = Math.sin(Math.toRadians(i * 3));
                double offZ = Math.cos(Math.toRadians(i * 3));
                this.field_145850_b.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, (double)this.func_174877_v().func_177958_n() + 0.5 + offX, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() + 0.5 + offZ, 0.0, 1.0, 0.0, new int[]{0});
            }
        }
        for (TardisSystems.BaseSystem s : this.systems) {
            s.damage();
        }
    }

    public void crash() {
        this.crash(true);
    }

    public void startHADS() {
        if (!this.field_145850_b.field_72995_K && this.hadsEnabled) {
            this.setDesination(this.getLocation().func_177982_a(this.rand.nextInt(20) - 10, 0, this.rand.nextInt(20) - 10), this.dimension);
            this.startFlight();
            WorldServer ws = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
            ws.func_175656_a(this.getLocation(), Blocks.field_150350_a.func_176223_P());
            ws.func_175656_a(this.getLocation().func_177984_a(), Blocks.field_150350_a.func_176223_P());
        }
    }

    public InteriorHum getHum() {
        return this.hum;
    }

    public void toggleHum(InteriorHum newHum) {
        if (!this.field_145850_b.field_72995_K) {
            if (this.hum != null) {
                int oldHumID = InteriorHum.hums.indexOf(this.hum);
                List players = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v();
                for (EntityPlayerMP player : players) {
                    if (player.field_71093_bK != TDimensions.TARDIS_ID || !(player.func_180425_c().func_185332_f(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p()) <= 30.0)) continue;
                    NetworkHandler.NETWORK.sendTo((IMessage)new MessageStopHum(oldHumID), player);
                }
            }
            this.hum = newHum.equals(InteriorHum.DISABLED) ? null : newHum;
            this.soundChanged = true;
        }
    }

    public boolean isForceFieldEnabled() {
        return this.forceFields;
    }

    public void setForceFieldEnabled(boolean forceFields) {
        this.forceFields = forceFields;
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "TARDIS";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70302_i_() {
        return this.buffer.size();
    }

    public boolean func_191420_l() {
        return this.buffer.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.buffer.size()) {
            return (ItemStack)this.buffer.get(index);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.func_70301_a(index);
        ItemStack newStack = stack.func_77979_a(count);
        this.func_70299_a(index, stack);
        this.func_70296_d();
        return newStack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index >= 0 && index < this.buffer.size()) {
            this.buffer.set(index, (Object)stack);
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.buffer.clear();
    }

    public void setExterior(IBlockState state) {
        this.blockTop = state;
        this.func_70296_d();
    }

    public void setHADS(boolean b) {
        this.hadsEnabled = b;
        this.func_70296_d();
    }

    public boolean isHADSEnabled() {
        return this.hadsEnabled;
    }

    public IBlockState getTopBlock() {
        return this.blockTop == null ? TBlocks.tardis_top.func_176223_P() : this.blockTop;
    }

    public float calcFuelUse() {
        SystemStabilizers stab = this.getSystem(SystemStabilizers.class);
        if (stab != null) {
            return stab.getHealth() > 0.0f && stab.isOn() ? 1.0f : 0.5f;
        }
        return 1.0f;
    }

    public int getTimeLeft() {
        return this.ticksToTravel;
    }

    private TardisSystems.BaseSystem[] createSystems() {
        TardisSystems.BaseSystem[] baseSystemArray;
        ArrayList<TardisSystems.BaseSystem> systems = new ArrayList<TardisSystems.BaseSystem>();
        for (String s : TardisSystems.SYSTEMS.keySet()) {
            TardisSystems.BaseSystem system = TardisSystems.createFromName(s);
            if (system == null) continue;
            systems.add(system);
        }
        if (systems == null) {
            TardisSystems.BaseSystem[] baseSystemArray2 = new TardisSystems.BaseSystem[1];
            baseSystemArray = baseSystemArray2;
            baseSystemArray2[0] = new SystemFlight();
        } else {
            baseSystemArray = systems.toArray(new TardisSystems.BaseSystem[0]);
        }
        return baseSystemArray;
    }

    public EnumTardisState getTardisState() {
        return this.currentState;
    }

    public void setTardisState(EnumTardisState state) {
        this.currentState = state;
        this.func_70296_d();
    }

    public void transferPlayer(final Entity entity, boolean checkDoors) {
        EntityTardis tardis;
        if (entity instanceof EntityDragon || entity instanceof EntityControl || entity instanceof ControlDoor) {
            return;
        }
        WorldServer ws = this.field_145850_b.func_73046_m().func_71218_a(this.dimension);
        if (ws == null) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new TardisExitEvent(entity, this.func_174877_v()));
        BlockPos pos = this.getLocation();
        if (entity.func_184187_bx() != null) {
            Entity ride = entity.func_184187_bx();
            entity.func_184220_m(null);
            if (!(ride instanceof EntityTardis)) {
                this.transferPlayer(ride, checkDoors);
            }
        }
        if ((tardis = this.getTardisEntity()) != null && !tardis.field_70128_L) {
            entity.changeDimension(this.dimension, (ITeleporter)new TardisTeleporter(this.getLocation()));
            ws.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    entity.func_184220_m((Entity)tardis);
                }
            });
            return;
        }
        TileEntityDoor door = (TileEntityDoor)ws.func_175625_s(this.getLocation().func_177984_a());
        if (door != null && ws.func_180495_p(door.func_174877_v()).func_177230_c() instanceof BlockTardisTop) {
            EnumFacing face = (EnumFacing)ws.func_180495_p(door.func_174877_v()).func_177229_b((IProperty)BlockTardisTop.FACING);
            pos = door.func_174877_v().func_177977_b().func_177967_a(face, 1);
            if (entity instanceof EntityPlayerMP) {
                if (entity.field_71093_bK != this.dimension) {
                    ((WorldServer)this.field_145850_b).func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, this.dimension, (ITeleporter)new TardisTeleporter(pos));
                }
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, Helper.get180Rot(face), 0.0f);
                return;
            }
            if (entity.field_71093_bK != this.dimension) {
                entity.changeDimension(this.dimension, (ITeleporter)new TardisTeleporter(pos));
            }
            entity.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, Helper.get180Rot(face), 0.0f);
        } else {
            entity.changeDimension(this.dimension, (ITeleporter)new TardisTeleporter(this.getLocation().func_177978_c()));
            entity.func_70634_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p());
        }
    }

    public void enterTARDIS(Entity entity) {
        Vec3d pos;
        if (entity instanceof EntityDragon) {
            return;
        }
        if (this.getTardisState() != EnumTardisState.NORMAL) {
            return;
        }
        MinecraftForge.EVENT_BUS.post((Event)new TardisEnterEvent(entity, this.func_174877_v()));
        ControlDoor door = this.getDoor();
        EnumFacing face = EnumFacing.NORTH;
        if (door == null) {
            pos = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5);
        } else {
            pos = door.func_174791_d().func_178787_e(door.func_70040_Z());
            face = door.func_174811_aO();
        }
        entity.func_70080_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, Helper.get180Rot(face), 0.0f);
        if (entity instanceof EntityPlayerMP) {
            if (TDimensions.TARDIS_ID != entity.field_71093_bK) {
                ((WorldServer)this.field_145850_b).func_73046_m().func_184103_al().transferPlayerToDimension((EntityPlayerMP)entity, TDimensions.TARDIS_ID, (ITeleporter)new TardisTeleporter());
            }
            ((EntityPlayerMP)entity).field_71135_a.func_147364_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, Helper.get180Rot(face), 0.0f);
            return;
        }
        if (entity.field_71093_bK != TDimensions.TARDIS_ID) {
            entity.changeDimension(TDimensions.TARDIS_ID, (ITeleporter)new TardisTeleporter());
        }
    }

    public <T> T getSystem(Class<T> system) {
        for (TardisSystems.BaseSystem sys : this.systems) {
            if (sys.getClass() != system) continue;
            return (T)sys;
        }
        return null;
    }

    public List<TileEntity> getTilesInTardis() {
        ArrayList<TileEntity> tes = new ArrayList<TileEntity>();
        ChunkPos pos = this.field_145850_b.func_175726_f(this.getLocation()).func_76632_l();
        for (int x = -8; x < 8; ++x) {
            for (int z = -8; z < 8; ++z) {
                tes.addAll(this.field_145850_b.func_72964_e(pos.field_77276_a + x, pos.field_77275_b + z).func_177434_r().values());
            }
        }
        return tes;
    }

    public ControlDoor getDoor() {
        Iterator iterator;
        if (!this.func_145831_w().field_72995_K) {
            ChunkPos pos = this.func_145831_w().func_175726_f(this.func_174877_v()).func_76632_l();
            for (int x = -1; x < 3; ++x) {
                for (int z = -1; z < 3; ++z) {
                    ((WorldServer)this.field_145850_b).func_72863_F().func_186028_c(pos.field_77276_a + x, pos.field_77275_b + z);
                }
            }
        }
        if ((iterator = this.field_145850_b.func_72872_a(ControlDoor.class, Block.field_185505_j.func_186670_a(this.func_174877_v()).func_186662_g(40.0)).iterator()).hasNext()) {
            ControlDoor door = (ControlDoor)iterator.next();
            return door;
        }
        return null;
    }

    public BlockPos getCurrentPosOnPath() {
        if (this.isInFlight()) {
            BlockPos dist = this.getDestination().func_177973_b((Vec3i)this.getLocation());
            return this.getLocation().func_177971_a((Vec3i)Helper.scaleBP(dist, (float)this.ticksToTravel / (float)this.totalTimeToTravel));
        }
        return this.getLocation();
    }

    public void setCourseEvent(EnumCourseCorrect event) {
        this.courseCorrect = event;
        this.func_70296_d();
    }

    public EnumCourseCorrect getCourseCorrect() {
        return this.courseCorrect;
    }

    public void setTardisEntity(EntityTardis tardis) {
        this.entity = tardis;
    }

    public EntityTardis getTardisEntity() {
        return this.entity;
    }

    public float getArtron() {
        return this.artron;
    }

    public void addArtronBank() {
        this.maxArtron += 128.0f;
        this.func_70296_d();
    }

    public void setMaxArtron(float max) {
        this.maxArtron = max;
        if (this.artron > max) {
            this.artron = max;
        }
        this.func_70296_d();
    }

    public void removeArtronBank() {
        this.setMaxArtron(this.maxArtron - 128.0f);
        this.func_70296_d();
    }

    public void addBedLoc(EntityPlayer player, BlockPos pos) {
        this.bedPositions.put(player.func_110124_au(), pos);
    }

    public BlockPos getBedPos(EntityPlayer player) {
        return this.bedPositions.get(player.func_110124_au());
    }

    public static enum EnumCourseCorrect {
        NONE(null, ""),
        DIRECTION_X(ControlX.class, "course.tardis.direction.x"),
        DIRECTION_Y(ControlY.class, "course.tardis.direction.y"),
        DIRECTION_Z(ControlZ.class, "course.tardis.direction.z"),
        DIMENSION(ControlDimChange.class, "course.tardis.dimension"),
        ARTRON_LEAK(ControlFuel.class, "course.tardis.artron_leak"),
        SPIN(ControlDirection.class, "course.tardis.spin");

        Class<? extends EntityControl> control;
        String langKey = "";

        private EnumCourseCorrect(Class<? extends EntityControl> con, String nameKey) {
            this.control = con;
            this.langKey = nameKey;
        }

        public Class<? extends EntityControl> getControl() {
            return this.control;
        }

        public TextComponentTranslation getTranslation() {
            return new TextComponentTranslation(this.langKey, new Object[0]);
        }
    }

    public static class NBT {
        public static final String WAYPOINT_INDEX = "waypoint_index";
        public static final String IS_LOCKED = "is_locked";
        public static final String TARDIS_STATE_ID = "tardis_state_id";
        public static final String SYSTEM_LIST = "system_list";
        public static final String FUEL_USAGE = "fuelUseage";
        public static final String HADS_ENABLED = "isHADSEnabled";
        public static final String CONTROL_IDS = "control_ids";
        public static final String COMPOENET_LIST = "componentList";
        public static final String LAND_ON_SURFACE = "landOnGround";
        public static final String MAX_TIME = "maxTime";
        public static final String TARGET_DIM_NAME = "targetDimName";
        public static final String CURRENT_DIM_NAME = "currentDimName";
        public static final String MAGNITUDE = "magnitude";
        public static final String EXTERIOR = "exterior";
        public static final String HEALTH = "health";
        public static final String HUM = "hum";
        public static final String FUCKED_UP = "fucked_up";
        public static final String STEALTH = "stealth";
    }
}

