/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.items.components;

import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.RiftHelper;

public class ItemArtronCapacitor
extends Item {
    static DecimalFormat FORMAT = new DecimalFormat("#.##");

    public ItemArtronCapacitor() {
        this.func_77625_d(1);
    }

    public static void setPower(ItemStack stack, float power) {
        NBTTagCompound tag = Helper.getStackTag(stack);
        tag.func_74776_a("artron", power);
        stack.func_77982_d(tag);
    }

    public static float getPower(ItemStack stack) {
        NBTTagCompound tag = Helper.getStackTag(stack);
        return tag.func_74764_b("artron") ? tag.func_74760_g("artron") : 0.0f;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity te;
        NBTTagCompound tag;
        if (!worldIn.field_72995_K && (tag = player.func_184586_b(hand).func_77978_p()) != null && tag.func_74764_b("artron") && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityTardis) {
            TileEntityTardis tardis = (TileEntityTardis)te;
            tardis.setArtron(tardis.getArtron() + tag.func_74760_g("artron") * 100.0f);
            ItemArtronCapacitor.setPower(player.func_184586_b(hand), 0.0f);
        }
        return super.func_180614_a(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        float oldPower;
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!worldIn.field_72995_K && RiftHelper.isRift(worldIn.func_175726_f(entityIn.func_180425_c()).func_76632_l(), worldIn) && (oldPower = ItemArtronCapacitor.getPower(stack)) < 1.0f) {
            ItemArtronCapacitor.setPower(stack, (float)MathHelper.func_151237_a((double)((double)ItemArtronCapacitor.getPower(stack) + 0.005), (double)0.0, (double)1.0));
        }
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        NBTTagCompound tag;
        if (stack != null && (tag = Helper.getStackTag(stack)).func_74764_b("artron")) {
            tooltip.add(new TextComponentTranslation("tooltip.tardis.artron_capacitor", new Object[0]).func_150254_d() + ": " + FORMAT.format(tag.func_74760_g("artron") * 100.0f));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }
}

