/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.controls;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.tardis.mod.common.entities.controls.EntityControl;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis01;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis02;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis03;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis04;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis05;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.util.common.helpers.Helper;
import scala.util.Random;

public class ControlRandom
extends EntityControl {
    public static int maxDist;

    public ControlRandom(TileEntityTardis tardis) {
        super(tardis);
        maxDist = TardisConfig.MISC.maxRandom;
    }

    public ControlRandom(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.125f);
    }

    @Override
    public Vec3d getOffset(TileEntityTardis tardis) {
        if (((Object)((Object)tardis)).getClass() == TileEntityTardis01.class || ((Object)((Object)tardis)).getClass() == TileEntityTardis02.class) {
            return Helper.convertToPixels(-10.0, -1.5, -1.5);
        }
        if (tardis instanceof TileEntityTardis03) {
            return Helper.convertToPixels(-13.0, 0.0, 5.0);
        }
        if (tardis instanceof TileEntityTardis04) {
            return Helper.convertToPixels(-8.0, -1.0, -4.5);
        }
        if (tardis instanceof TileEntityTardis05) {
            return Helper.convertToPixels(-9.5, -0.5, 5.5);
        }
        return Helper.convertToPixels(0.0, -1.0, 9.0);
    }

    @Override
    public void preformAction(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            TileEntityTardis tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos());
            Random rand = new Random();
            BlockPos loc = tardis.getLocation();
            if (loc == null) {
                loc = player.func_180425_c();
            }
            if (maxDist == 0) {
                WorldServer ws = DimensionManager.getWorld((int)tardis.dimension);
                if (ws != null) {
                    int size = ws.func_175723_af().func_177722_l();
                    tardis.setDesination(new BlockPos(rand.nextInt(size) - size / 2, 64, rand.nextInt(size) - size / 2), tardis.getTargetDim());
                }
            } else {
                tardis.setDesination(new BlockPos(loc.func_177958_n() + rand.nextInt(rand.nextInt(maxDist)) - rand.nextInt(maxDist) / 2, 64, loc.func_177952_p() + rand.nextInt(maxDist) - rand.nextInt(maxDist) / 2), tardis.getTargetDim());
            }
        } else {
            this.ticks = 20;
        }
    }

    @Override
    public void init(TileEntityTardis tardis) {
        if (tardis != null) {
            if (tardis instanceof TileEntityTardis03) {
                this.func_70105_a(Helper.precentToPixels(3.0f), Helper.precentToPixels(2.0f));
            }
            if (tardis instanceof TileEntityTardis05) {
                this.func_70105_a(Helper.precentToPixels(1.0f), Helper.precentToPixels(1.0f));
            }
        }
    }
}

