/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities.controls;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.tardis.mod.common.entities.controls.EntityControl;
import net.tardis.mod.common.sounds.TSounds;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis01;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis02;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis03;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis04;
import net.tardis.mod.common.tileentity.consoles.TileEntityTardis05;
import net.tardis.mod.util.common.helpers.Helper;

public class ControlDimChange
extends EntityControl {
    public ControlDimChange(TileEntityTardis tardis) {
        super(tardis);
    }

    public ControlDimChange(World world) {
        super(world);
        this.func_70105_a(0.125f, 0.0625f);
    }

    @Override
    public Vec3d getOffset(TileEntityTardis tardis) {
        if (tardis instanceof TileEntityTardis01 || ((Object)((Object)tardis)).getClass() == TileEntityTardis02.class) {
            return Helper.convertToPixels(2.0, -2.5, 13.5);
        }
        if (tardis instanceof TileEntityTardis03) {
            return Helper.convertToPixels(-12.0, 0.0, -7.0);
        }
        if (tardis instanceof TileEntityTardis04) {
            return Helper.convertToPixels(-2.0, -1.5, 12.0);
        }
        if (tardis instanceof TileEntityTardis05) {
            return Helper.convertToPixels(5.5, -2.5, -14.5);
        }
        return Helper.convertToPixels(-1.5, -2.0, -12.0);
    }

    @Override
    public void preformAction(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            Integer[] ids = DimensionManager.getStaticDimensionIDs();
            TileEntityTardis tardis = (TileEntityTardis)this.field_70170_p.func_175625_s(this.getConsolePos());
            tardis.dimIndex = !player.func_70093_af() ? ++tardis.dimIndex : --tardis.dimIndex;
            if (tardis.dimIndex >= ids.length) {
                tardis.dimIndex = 0;
            } else if (tardis.dimIndex < 0) {
                tardis.dimIndex = ids.length - 1;
            }
            int dim = ids[tardis.dimIndex];
            if (Helper.isDimensionBlocked(dim)) {
                this.preformAction(player);
            }
            tardis.setTargetDimension(ids[tardis.dimIndex]);
            player.func_146105_b((ITextComponent)new TextComponentString(new TextComponentTranslation("tardis.dimension", new Object[0]).func_150254_d() + " " + Helper.formatDimensionName(DimensionManager.createProviderFor((int)ids[tardis.dimIndex]).func_186058_p().func_186065_b())), true);
        } else {
            this.ticks = 20;
        }
    }

    public int nextDI(int index, int size) {
        if (++index < 0 || index > size) {
            return 0;
        }
        return index;
    }

    @Override
    public void init(TileEntityTardis tardis) {
        if (tardis != null && tardis instanceof TileEntityTardis03) {
            this.func_70105_a(Helper.precentToPixels(6.0f), Helper.precentToPixels(6.0f));
        }
    }

    @Override
    public SoundEvent getUseSound() {
        return TSounds.control_dimension;
    }
}

