/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityLaserRay
extends EntityThrowable
implements IEntityAdditionalSpawnData {
    public float damage;
    public Vec3d color;
    private DamageSource source = DamageSource.field_76377_j;

    public EntityLaserRay(World worldIn) {
        super(worldIn);
    }

    public EntityLaserRay(World worldIn, EntityLivingBase throwerIn, float damage, DamageSource source, Vec3d color) {
        super(worldIn, throwerIn);
        this.damage = damage;
        this.color = color;
        this.source = source;
    }

    public void func_70030_z() {
        double speed = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72438_d(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s));
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 600 || speed < 0.01)) {
            this.func_70106_y();
        }
        super.func_70030_z();
    }

    protected void func_70184_a(RayTraceResult result) {
        IBlockState block;
        if (result == null || this.field_70128_L) {
            return;
        }
        if (result.field_72313_a == RayTraceResult.Type.ENTITY) {
            if (result.field_72308_g == this.field_70192_c || result.field_72308_g == null) {
                return;
            }
            result.field_72308_g.func_70097_a(this.source, this.damage);
        } else if (result.field_72313_a == RayTraceResult.Type.BLOCK && (block = this.field_70170_p.func_180495_p(result.func_178782_a())).func_177230_c() instanceof BlockTNT) {
            BlockPos pos = result.func_178782_a();
            this.field_70170_p.func_175698_g(pos);
            EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.field_70170_p, (double)((float)pos.func_177958_n() + 0.5f), (double)pos.func_177956_o(), (double)((float)pos.func_177952_p() + 0.5f), this.func_85052_h());
            this.field_70170_p.func_72838_d((Entity)entitytntprimed);
            this.field_70170_p.func_184148_a(null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    protected float func_70185_h() {
        return 1.0E-5f;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74776_a("Damage", this.damage);
        compound.func_74780_a("Color_R", this.color.field_72450_a);
        compound.func_74780_a("Color_G", this.color.field_72448_b);
        compound.func_74780_a("Color_B", this.color.field_72449_c);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74760_g("Damage");
        this.color = new Vec3d(compound.func_74769_h("Color_R"), compound.func_74769_h("Color_G"), compound.func_74769_h("Color_B"));
    }

    public void writeSpawnData(ByteBuf buffer) {
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_70014_b(nbt);
        ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
    }

    public void readSpawnData(ByteBuf additionalData) {
        this.func_70037_a(ByteBufUtils.readTag((ByteBuf)additionalData));
    }

    public boolean func_70090_H() {
        return false;
    }
}

