/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.entities;

import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.model.ModelBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAIOpenDoor;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.api.events.tardis.TardisEnterEvent;
import net.tardis.mod.api.events.tardis.TardisExitEvent;
import net.tardis.mod.client.guis.GUICompanion;
import net.tardis.mod.common.dimensions.TDimensions;
import net.tardis.mod.common.entities.EntityDalek;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class EntityCompanion
extends EntityTameable
implements IInventory,
IEntityOwnable {
    public static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityCompanion.class, (DataSerializer)DataSerializers.field_187198_h);
    public static final DataParameter<String> TYPE = EntityDataManager.func_187226_a(EntityCompanion.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Float> TARDIS_XP = EntityDataManager.func_187226_a(EntityCompanion.class, (DataSerializer)DataSerializers.field_187193_c);
    public BlockPos tardisPos = BlockPos.field_177992_a;
    public boolean flyTardis = false;
    private UUID player;
    private NonNullList<ItemStack> INVENTORY = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private EntityAISit sit;

    public EntityCompanion(World worldIn) {
        super(worldIn);
        this.field_70138_W = 1.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        ((PathNavigateGround)this.func_70661_as()).func_179691_c(true);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, 0.5, 4.0f, 8.0f));
        this.sit = new EntityAISit((EntityTameable)this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.sit);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIWander((EntityCreature)this, 0.5));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 30.0f));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIEnterTardis(this, 1.0));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIOpenDoor((EntityLiving)this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityTNTPrimed.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityDalek.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityArrow.class, 6.0f, 1.0, 1.2));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(SITTING, (Object)false);
        this.func_184212_Q().func_187214_a(TYPE, (Object)Helper.randomEnum(EnumCompanionType.class, this.field_70170_p.field_73012_v).name());
        this.func_184212_Q().func_187214_a(TARDIS_XP, (Object)Float.valueOf(0.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.field_71093_bK == TDimensions.TARDIS_ID && this.field_70170_p.func_72820_D() % 20L == 0L) {
            TileEntityTardis tardis = null;
            for (TileEntity te : this.field_70170_p.field_147482_g) {
                if (!(te instanceof TileEntityTardis) || !(te.func_174877_v().func_177951_i((Vec3i)this.func_180425_c()) < Math.pow(16.0, 2.0))) continue;
                tardis = (TileEntityTardis)te;
                break;
            }
            if (tardis != null && tardis.isInFlight()) {
                this.setXP(this.getXP() + 0.001f);
            }
        }
        if (this.isWrongSize()) {
            this.func_70105_a(this.getType().size[0], this.getType().size[1]);
        }
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public EnumCompanionType getType() {
        return Enum.valueOf(EnumCompanionType.class, (String)this.func_184212_Q().func_187225_a(TYPE));
    }

    public void setType(EnumCompanionType type) {
        this.func_184212_Q().func_187227_b(TYPE, (Object)type.name());
    }

    public int func_70302_i_() {
        return this.INVENTORY.size();
    }

    public boolean func_191420_l() {
        return this.INVENTORY.isEmpty();
    }

    public ItemStack func_70301_a(int index) {
        return index < this.INVENTORY.size() ? (ItemStack)this.INVENTORY.get(index) : ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int index, int count) {
        return this.func_70301_a(index).func_77979_a(count);
    }

    public ItemStack func_70304_b(int index) {
        ItemStack s = this.func_70301_a(index);
        this.func_70299_a(index, ItemStack.field_190927_a);
        return s;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < this.INVENTORY.size()) {
            this.INVENTORY.set(index, (Object)stack);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70296_d() {
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.INVENTORY.clear();
    }

    public EntityPlayer getOwner() {
        if (this.player != null && this.field_70170_p.func_152378_a(this.player) != null) {
            return this.field_70170_p.func_152378_a(this.player);
        }
        return null;
    }

    public void setOwner(EntityPlayer player) {
        this.player = player.func_146103_bH().getId();
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GUICompanion(this));
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getType().getName());
    }

    public NBTTagCompound func_189511_e(NBTTagCompound compound) {
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : this.INVENTORY) {
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        compound.func_74782_a("INVENTORY", (NBTBase)list);
        compound.func_74778_a("owner", this.player != null ? this.player.toString() : "");
        compound.func_74778_a("type", this.getType().name());
        compound.func_74776_a("xp", this.getXP());
        return super.func_189511_e(compound);
    }

    public void func_70020_e(NBTTagCompound compound) {
        super.func_70020_e(compound);
        int id = 0;
        NBTTagList list = compound.func_150295_c("INVENTORY", 10);
        for (NBTBase base : list) {
            this.INVENTORY.set(id, (Object)new ItemStack((NBTTagCompound)base));
            ++id;
        }
        if (!compound.func_74779_i("owner").isEmpty()) {
            this.player = UUID.fromString(compound.func_74779_i("owner"));
        }
        if (compound.func_74779_i("type") != null && !compound.func_74779_i("type").isEmpty()) {
            this.setType(Enum.valueOf(EnumCompanionType.class, compound.func_74779_i("type")));
        }
        this.setXP(compound.func_74760_g("xp"));
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K && player.func_146103_bH().getId().equals(this.func_184753_b())) {
            this.openGui();
        } else if (this.func_184753_b() == null) {
            this.setOwner(player);
            if (!this.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("companion.tardis.saved.dalek", new Object[0]), false);
            }
        }
        return true;
    }

    public boolean func_174833_aM() {
        return true;
    }

    public boolean isWrongSize() {
        float[] size = this.getType().size;
        return this.field_70130_N != size[0] || this.field_70131_O != size[1];
    }

    public UUID func_184753_b() {
        return this.player;
    }

    public boolean getSit() {
        return (Boolean)this.func_184212_Q().func_187225_a(SITTING);
    }

    public void setSit(boolean sit) {
        this.func_184212_Q().func_187227_b(SITTING, (Object)sit);
    }

    public float getXP() {
        return ((Float)this.func_184212_Q().func_187225_a(TARDIS_XP)).floatValue();
    }

    public void setXP(float xp) {
        this.func_184212_Q().func_187227_b(TARDIS_XP, (Object)Float.valueOf(xp));
    }

    public boolean func_70631_g_() {
        return false;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public void func_70903_f(boolean tamed) {
    }

    public void func_70904_g(boolean sitting) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sitting);
        this.sit.func_75270_a(sitting);
    }

    public void func_193101_c(EntityPlayer player) {
        this.setOwner(player);
    }

    public boolean func_70909_n() {
        return this.func_184753_b() != null;
    }

    public boolean func_70906_o() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    public boolean func_152114_e(EntityLivingBase entityIn) {
        return entityIn.func_110124_au().equals(this.func_184753_b());
    }

    public EntityAISit func_70907_r() {
        return this.sit;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void enterTardis(TardisEnterEvent event) {
            if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                for (EntityCompanion e : player.func_130014_f_().func_72872_a(EntityCompanion.class, Block.field_185505_j.func_191194_a(player.func_174791_d()).func_186662_g(16.0))) {
                    WorldServer world;
                    TileEntityTardis tardis;
                    if (e.getSit() || e.getOwner() == null || e.getOwner() != player || (tardis = Helper.getTardis((world = player.field_70170_p.func_73046_m().func_71218_a(TDimensions.TARDIS_ID)).func_175625_s(event.getInteriorPos()))) == null) continue;
                    tardis.enterTARDIS((Entity)e);
                }
            }
        }

        @SubscribeEvent
        public static void exitTardis(TardisExitEvent event) {
            if (!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EntityPlayer) {
                EntityPlayer player = (EntityPlayer)event.getEntity();
                WorldServer world = player.field_70170_p.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                for (EntityCompanion c : player.field_70170_p.func_72872_a(EntityCompanion.class, Block.field_185505_j.func_191194_a(player.func_174791_d()).func_186662_g(16.0))) {
                    TileEntityTardis tardis;
                    if (c.getSit() || c.getOwner() == null || c.getOwner() != player || (tardis = Helper.getTardis(world.func_175625_s(event.getPos()))) == null) continue;
                    tardis.transferPlayer((Entity)c, true);
                }
            }
        }
    }

    public static class EntityAIEnterTardis
    extends EntityAIBase {
        double speed;
        EntityCompanion comp;

        public EntityAIEnterTardis(EntityCompanion com, double s) {
            this.comp = com;
            this.speed = s;
            this.func_75248_a(1);
        }

        public boolean func_75250_a() {
            return !this.comp.tardisPos.equals((Object)BlockPos.field_177992_a);
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public void func_75246_d() {
            if (Helper.blockPosToVec3d((Vec3i)this.comp.tardisPos).func_72438_d(this.comp.func_174791_d()) > 3.0) {
                this.comp.field_70765_h.func_75642_a((double)this.comp.tardisPos.func_177958_n(), (double)this.comp.tardisPos.func_177956_o(), (double)this.comp.tardisPos.func_177952_p(), this.speed);
            } else {
                TileEntityTardis tardis;
                this.comp.tardisPos = BlockPos.field_177992_a;
                WorldServer world = this.comp.field_70170_p.func_73046_m().func_71218_a(TDimensions.TARDIS_ID);
                if (this.comp.getOwner() != null && TardisHelper.hasTardis(this.comp.getOwner().func_146103_bH().getId()) && (tardis = Helper.getTardis(world.func_175625_s(TardisHelper.getTardis(this.comp.getOwner().func_146103_bH().getId())))) != null) {
                    tardis.enterTARDIS((Entity)this.comp);
                    if (this.comp.flyTardis) {
                        tardis.setDesination(this.comp.getOwner().func_180425_c(), this.comp.getOwner().field_71093_bK);
                        tardis.startFlight();
                        tardis.overrideStabilizers = true;
                        this.comp.flyTardis = false;
                    }
                }
            }
        }
    }

    public static enum EnumCompanionType {
        CLAIRE("claire", "Claire"),
        VASSILIS("vassilis", "Vassilis"),
        ALEXA("alexa", "Alexa"),
        PETER("peter", "Peter"),
        VANDHAM("vandham", "Vandham"),
        WOLSEY("black", "Wolsey", new float[]{0.75f, 1.0f});

        @SideOnly(value=Side.CLIENT)
        public ModelBase model;
        ResourceLocation skin;
        String formattedName = "";
        float[] size = new float[]{0.6f, 1.75f};

        private EnumCompanionType(String name, String formatName) {
            this.skin = new ResourceLocation("tardis", "textures/entity/companion/" + name + ".png");
            this.formattedName = formatName;
        }

        private EnumCompanionType(String name, String formattedName, float[] size) {
            this(name, formattedName);
            this.size = size;
        }

        public ResourceLocation getTexture() {
            return this.skin;
        }

        public String getName() {
            return this.formattedName;
        }

        @SideOnly(value=Side.CLIENT)
        public ModelBase getModel() {
            this.model.field_78091_s = false;
            return this.model;
        }

        @SideOnly(value=Side.CLIENT)
        public void setModel(ModelBase model) {
            this.model = model;
        }
    }
}

