/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.blocks;

import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.guis.GuiMonitor;
import net.tardis.mod.common.blocks.BlockFacingDecoration;
import net.tardis.mod.common.blocks.interfaces.IRenderBox;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class BlockMonitor
extends BlockFacingDecoration
implements IRenderBox {
    public BlockMonitor(Supplier<TileEntity> tileEntity) {
        super(tileEntity);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack held = playerIn.func_184586_b(hand);
        TileEntityTardis tardis = (TileEntityTardis)worldIn.func_175625_s(TardisHelper.getTardisForPosition((Vec3i)pos));
        if (tardis == null) {
            return true;
        }
        if (held.func_77973_b() instanceof ItemMap) {
            if (!worldIn.field_72995_K) {
                MapData data = ItemMap.func_150912_a((int)held.func_77952_i(), (World)worldIn);
                WorldServer ws = worldIn.func_73046_m().func_71218_a(data.field_76200_c);
                tardis.setDesination(ws.func_175672_r(new BlockPos(data.field_76201_a, 0, data.field_76199_b)), data.field_76200_c);
            }
        } else if (worldIn.field_72995_K) {
            this.openGui(tardis);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void openGui(TileEntityTardis tardis) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMonitor(tardis));
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.clear();
        drops.add((Object)new ItemStack((Block)this));
        super.getDrops(drops, world, pos, state, fortune);
    }

    @Override
    public boolean shouldRenderBox() {
        return false;
    }
}

