/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.common.ars;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.tardis.mod.common.IDoor;
import net.tardis.mod.common.entities.controls.ControlDoor;

public class ConsoleRoom {
    public static List<ConsoleRoom> CONSOLE_ROOMS = new ArrayList<ConsoleRoom>();
    private ResourceLocation preview;
    private ResourceLocation filePath;
    private BlockPos consolePos = BlockPos.field_177992_a;
    AxisAlignedBB BB = new AxisAlignedBB(-20.0, -20.0, -20.0, 20.0, 20.0, 20.0);

    public ConsoleRoom(ResourceLocation preview, ResourceLocation filePath, BlockPos cp) {
        this.preview = preview;
        this.filePath = filePath;
        this.consolePos = cp;
    }

    public ResourceLocation getPreview() {
        return this.preview;
    }

    public ResourceLocation getFilePath() {
        return this.filePath;
    }

    public void generate(WorldServer world, BlockPos pos) {
        for (Entity ent : world.func_72872_a(Entity.class, this.BB)) {
            if (!(ent instanceof IDoor) && !(ent instanceof ControlDoor)) continue;
            ent.func_70106_y();
        }
        Template temp = world.func_184163_y().func_189942_b(world.func_73046_m(), this.filePath);
        PlacementSettings ps = new PlacementSettings();
        temp.func_186253_b((World)world, pos.func_177973_b((Vec3i)this.consolePos), ps);
    }

    public BlockPos getConsolePos() {
        return this.consolePos;
    }

    public static void registerConsoleRoom(String previewPath, String interiorName, BlockPos pos) {
        CONSOLE_ROOMS.add(new ConsoleRoom(new ResourceLocation("tardis", previewPath), new ResourceLocation("tardis", interiorName), pos));
    }
}

