/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.worldshell;

import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.IContainsWorldShell;
import net.tardis.mod.config.TardisConfig;
import net.tardis.mod.util.common.helpers.Helper;

public class RenderWorldShell {
    public static VertexBuffer BOTI = null;

    public static void renderWorldShell(IContainsWorldShell cont, WorldClient world, double x, double y, double z) {
        GlStateManager.func_179094_E();
        BlockPos offset = cont.getWorldShell().getOffset();
        GlStateManager.func_179137_b((double)(x - (double)offset.func_177958_n()), (double)(y - (double)offset.func_177956_o()), (double)(z - (double)offset.func_177952_p()));
        BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74519_b();
        VertexFormat format = DefaultVertexFormats.field_176600_a;
        if (BOTI == null) {
            BOTI = new VertexBuffer(format);
            BOTI.func_177359_a();
            bb.func_181668_a(7, format);
            for (Map.Entry<BlockPos, BlockStorage> entry : cont.getWorldShell().blockMap.entrySet()) {
                IBlockState state = entry.getValue().blockstate;
                state = state.func_185899_b((IBlockAccess)world, entry.getKey());
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                if (!Helper.canRenderInBOTI(state) || state == null) continue;
                if (model != null && !model.func_188618_c() && state.func_185901_i() == EnumBlockRenderType.MODEL) {
                    Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)world, model, state, entry.getKey(), bb, TardisConfig.BOTI.checkSides);
                    continue;
                }
                if (state.func_185901_i() != EnumBlockRenderType.LIQUID) continue;
                Minecraft.func_71410_x().func_175602_ab().field_175025_e.func_178270_a((IBlockAccess)world, state, entry.getKey(), bb);
            }
            bb.func_178977_d();
            bb.func_178965_a();
            BOTI.func_181722_a(bb.func_178966_f());
        }
        BOTI.func_177359_a();
        GlStateManager.func_187420_d((int)3, (int)5126, (int)format.func_177338_f(), (int)0);
        GlStateManager.func_187406_e((int)4, (int)5121, (int)format.func_177338_f(), (int)format.func_177340_e());
        GlStateManager.func_187405_c((int)2, (int)5126, (int)format.func_177338_f(), (int)format.func_177344_b(0));
        GlStateManager.func_187410_q((int)32884);
        GlStateManager.func_187410_q((int)32888);
        GlStateManager.func_187410_q((int)32886);
        BOTI.func_177358_a(7);
        GlStateManager.func_187429_p((int)32884);
        GlStateManager.func_187429_p((int)32888);
        GlStateManager.func_187429_p((int)32886);
        BOTI.func_177361_b();
        RenderHelper.func_74519_b();
        for (TileEntity entity : cont.getWorldShell().getTESRs()) {
            if (entity == null) continue;
            entity.func_145834_a((World)world);
            TileEntitySpecialRenderer render = TileEntityRendererDispatcher.field_147556_a.func_147547_b(entity);
            if (render == null) continue;
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            float light = (float)cont.getWorldShell().blockMap.get((Object)entity.func_174877_v()).light / 15.0f;
            GlStateManager.func_179124_c((float)light, (float)light, (float)light);
            render.func_192841_a(entity, (double)entity.func_174877_v().func_177958_n(), (double)entity.func_174877_v().func_177956_o(), (double)(entity.func_174877_v().func_177952_p() - 1), 0.0f, 0, 1.0f);
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Entity e : cont.getWorldShell().getEntitiesForRender()) {
            RenderHelper.func_74519_b();
            GlStateManager.func_179094_E();
            BlockStorage stor = cont.getWorldShell().blockMap.get(e.func_180425_c().func_177977_b());
            float light = stor != null ? (float)stor.light / 15.0f : 1.0f;
            GlStateManager.func_179124_c((float)light, (float)light, (float)light);
            GlStateManager.func_179137_b((double)e.field_70165_t, (double)e.field_70163_u, (double)e.field_70161_v);
            GlStateManager.func_179114_b((float)e.field_70177_z, (float)0.0f, (float)1.0f, (float)0.0f);
            Minecraft.func_71410_x().func_175598_ae().func_78713_a(e).func_76986_a(e, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    static {
        ((SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                BOTI = null;
            }
        });
    }
}

