/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.renderers.decorations.hellbent;

import java.awt.Color;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.WorldProvider;
import net.minecraftforge.common.DimensionManager;
import net.tardis.mod.client.models.decoration.ModelHellbentMonitor;
import net.tardis.mod.common.blocks.BlockFacingDecoration;
import net.tardis.mod.common.tileentity.TileEntityTardis;
import net.tardis.mod.common.tileentity.decoration.TileEntityHellbentMonitor;
import net.tardis.mod.util.common.helpers.Helper;
import net.tardis.mod.util.common.helpers.TardisHelper;

public class RenderHellbentMonitor
extends TileEntitySpecialRenderer<TileEntityHellbentMonitor> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("tardis", "textures/blocks/hellbent/monitor.png");
    public ModelHellbentMonitor model = new ModelHellbentMonitor();
    Minecraft mc = Minecraft.func_71410_x();

    public void render(TileEntityHellbentMonitor te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 1.25), (double)(z + 0.5));
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        IBlockState state = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() instanceof BlockFacingDecoration) {
            GlStateManager.func_179114_b((float)Helper.getAngleFromFacing((EnumFacing)state.func_177229_b((IProperty)BlockFacingDecoration.FACING)), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)(-Helper.precentToPixels(4.0f)), (float)Helper.precentToPixels(5.0f));
        this.mc.func_110434_K().func_110577_a(TEXTURE);
        this.model.func_78088_a(null, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f);
        TileEntityTardis tardis = (TileEntityTardis)te.func_145831_w().func_175625_s(TardisHelper.getTardisForPosition((Vec3i)te.func_174877_v()));
        if (tardis != null) {
            GlStateManager.func_179094_E();
            double scale = 0.007;
            GlStateManager.func_179109_b((float)(-Helper.precentToPixels(8.0f)), (float)Helper.precentToPixels(8.0f), (float)-1.0f);
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)scale);
            this.drawInfo(tardis);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179121_F();
    }

    private void drawInfo(TileEntityTardis tardis) {
        this.mc.field_71466_p.func_78276_b("Location: " + Helper.formatBlockPos(tardis.getLocation()), 0, this.mc.field_71466_p.field_78288_b * 0, Color.WHITE.getRGB());
        WorldProvider dim = DimensionManager.createProviderFor((int)tardis.dimension);
        String name = "UNKNOWN!";
        if (dim != null && dim.func_186058_p() != null) {
            name = Helper.formatDimensionName(dim.func_186058_p().func_186065_b());
        }
        WorldProvider targetDim = DimensionManager.createProviderFor((int)tardis.getTargetDim());
        String targetDimName = "UNKNOWN!";
        if (dim != null && targetDim.func_186058_p() != null) {
            targetDimName = Helper.formatDimensionName(targetDim.func_186058_p().func_186065_b());
        }
        this.mc.field_71466_p.func_78276_b("Dimension: " + name, 0, this.mc.field_71466_p.field_78288_b * 1, Color.WHITE.getRGB());
        this.mc.field_71466_p.func_78276_b("Destination: " + Helper.formatBlockPos(tardis.getDestination()), 0, this.mc.field_71466_p.field_78288_b * 2, Color.WHITE.getRGB());
        this.mc.field_71466_p.func_78276_b("Target Dim: " + targetDimName, 0, this.mc.field_71466_p.field_78288_b * 3, Color.WHITE.getRGB());
        this.mc.field_71466_p.func_78276_b("Artron Banks: " + tardis.getArtron() + " units", 0, this.mc.field_71466_p.field_78288_b * 4, Color.white.getRGB());
        if (tardis.isInFlight()) {
            this.mc.field_71466_p.func_78276_b("Time Left " + tardis.getTimeLeft() / 20, 0, this.mc.field_71466_p.field_78288_b * 5, Color.WHITE.getRGB());
        } else {
            this.mc.field_71466_p.func_78276_b("TARDIS Landed", 0, this.mc.field_71466_p.field_78288_b * 5, Color.WHITE.getRGB());
        }
        this.mc.field_71466_p.func_78276_b("TARDIS Facing: " + tardis.facing.func_176610_l(), 0, this.mc.field_71466_p.field_78288_b * 6, Color.WHITE.getRGB());
    }
}

