/*
 * Decompiled with CFR 0.152.
 */
package net.tardis.mod.client.models;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.tardis.mod.client.models.exteriors.IExteriorModel;
import net.tardis.mod.client.worldshell.BlockStorage;
import net.tardis.mod.client.worldshell.WorldBoti;
import net.tardis.mod.client.worldshell.WorldShell;

@SideOnly(value=Side.CLIENT)
public class ModelBlocks
implements IExteriorModel {
    public ResourceLocation loc;
    public BlockPos size = BlockPos.field_177992_a;
    public BlockPos offset = BlockPos.field_177992_a;
    public Vec3d rotation = new Vec3d(0.0, 0.0, 0.0);
    private HashMap<BlockPos, BlockStorage> blocks = new HashMap();
    private WorldBoti world;
    private WorldShell ws = new WorldShell(BlockPos.field_177992_a);

    public ModelBlocks(ResourceLocation loc) {
        this.loc = loc;
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(new IResourceManagerReloadListener(){

            public void func_110549_a(IResourceManager resourceManager) {
                ModelBlocks.this.read();
            }
        });
        this.ws.blockMap = this.blocks;
    }

    public void render() {
        if (this.world == null) {
            this.world = new WorldBoti(0, Minecraft.func_71410_x().field_71441_e, this.ws);
        }
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179109_b((float)this.offset.func_177958_n(), (float)this.offset.func_177956_o(), (float)this.offset.func_177952_p());
        GlStateManager.func_179114_b((float)((float)this.rotation.field_72450_a), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotation.field_72448_b), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)this.rotation.field_72449_c), (float)0.0f, (float)0.0f, (float)1.0f);
        for (BlockPos pos : this.blocks.keySet()) {
            try {
                GlStateManager.func_179094_E();
                IBlockState state = this.blocks.get((Object)pos).blockstate;
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
                BufferBuilder bb = Tessellator.func_178181_a().func_178180_c();
                GlStateManager.func_179109_b((float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p());
                List quads = model.func_188616_a(state, null, 0L);
                VertexFormat vFormat = quads.size() > 0 ? ((BakedQuad)quads.get(0)).getFormat() : DefaultVertexFormats.field_176599_b;
                bb.func_181668_a(7, vFormat);
                int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(state, (IBlockAccess)this.world, Minecraft.func_71410_x().field_71439_g.func_180425_c(), MinecraftForgeClient.getRenderPass());
                for (BakedQuad bq : quads) {
                    bb.func_178981_a(bq.func_178209_a());
                }
                for (EnumFacing f : EnumFacing.values()) {
                    for (BakedQuad quad : model.func_188616_a(state, f, 0L)) {
                        bb.func_178981_a(quad.func_178209_a());
                    }
                    bb.func_178968_d(color);
                }
                Tessellator.func_178181_a().func_78381_a();
                GlStateManager.func_179121_F();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GlStateManager.func_179121_F();
    }

    public void read() {
        this.blocks.clear();
        try {
            InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.loc).func_110527_b();
            JsonReader jr = new JsonReader((Reader)new InputStreamReader(is));
            jr.beginObject();
            while (jr.hasNext()) {
                int z;
                int y;
                int x;
                String nameS = jr.nextName();
                if (nameS.equals("structure")) {
                    jr.beginObject();
                    while (jr.hasNext()) {
                        jr.nextName();
                        jr.beginObject();
                        x = 0;
                        y = 0;
                        z = 0;
                        int meta = 0;
                        Block block = null;
                        while (jr.hasNext()) {
                            String name = jr.nextName();
                            if (name.equals("X")) {
                                x = jr.nextInt();
                            }
                            if (name.equals("Y")) {
                                y = jr.nextInt();
                            }
                            if (name.equals("Z")) {
                                z = jr.nextInt();
                            }
                            if (name.equals("Block")) {
                                block = Block.func_149684_b((String)jr.nextString());
                            }
                            if (!name.equals("Meta")) continue;
                            meta = jr.nextInt();
                        }
                        this.blocks.put(new BlockPos(x, y, z), new BlockStorage(meta != 0 ? block.func_176203_a(meta) : block.func_176223_P(), null, 0));
                        jr.endObject();
                    }
                    jr.endObject();
                    continue;
                }
                if (!nameS.equals("data")) continue;
                jr.beginObject();
                x = 0;
                y = 0;
                z = 0;
                int sx = 0;
                int sy = 0;
                int sz = 0;
                double rotX = 0.0;
                double rotY = 0.0;
                double rotZ = 0.0;
                while (jr.hasNext()) {
                    String name = jr.nextName();
                    if (name.equals("position")) {
                        jr.beginArray();
                        x = jr.nextInt();
                        y = jr.nextInt();
                        z = jr.nextInt();
                        jr.endArray();
                    }
                    if (name.equals("size")) {
                        jr.beginArray();
                        sx = jr.nextInt();
                        sy = jr.nextInt();
                        sz = jr.nextInt();
                        jr.endArray();
                    }
                    if (!name.equals("rotation")) continue;
                    jr.beginArray();
                    rotX = jr.nextDouble();
                    rotY = jr.nextDouble();
                    rotZ = jr.nextDouble();
                    jr.endArray();
                }
                this.rotation = new Vec3d(rotX, rotY, rotZ);
                this.size = new BlockPos(sx, sy, sz);
                this.offset = new BlockPos(x, y, z);
                jr.endObject();
            }
            jr.endObject();
            jr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ResourceLocation getKey() {
        return this.loc;
    }

    @Override
    public void renderClosed(float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.func_179137_b((double)-0.5, (double)3.0, (double)0.5);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.render();
        GlStateManager.func_179121_F();
    }

    @Override
    public void renderOpen(float scale) {
        this.render();
    }
}

