/*
 * Decompiled with CFR 0.152.
 */
package squeek.applecore.api_impl;

import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import squeek.applecore.api.AppleCoreAPI;
import squeek.applecore.api.IAppleCoreAccessor;
import squeek.applecore.api.IAppleCoreMutator;
import squeek.applecore.api.food.FoodEvent;
import squeek.applecore.api.food.FoodValues;
import squeek.applecore.api.food.IEdible;
import squeek.applecore.api.hunger.ExhaustionEvent;
import squeek.applecore.api.hunger.HealthRegenEvent;
import squeek.applecore.api.hunger.HungerEvent;
import squeek.applecore.api.hunger.StarvationEvent;
import squeek.applecore.asm.util.IAppleCoreFoodStats;

public enum AppleCoreAccessorMutatorImpl implements IAppleCoreAccessor,
IAppleCoreMutator
{
    INSTANCE;

    protected static final Field itemFoodAlwaysEdible;

    private AppleCoreAccessorMutatorImpl() {
        AppleCoreAPI.accessor = this;
        AppleCoreAPI.mutator = this;
    }

    @Override
    public boolean isFood(@Nonnull ItemStack food) {
        return this.isEdible(food) && this.getUnmodifiedFoodValues(food) != null;
    }

    private boolean isEdible(@Nonnull ItemStack food) {
        if (food == ItemStack.field_190927_a) {
            return false;
        }
        EnumAction useAction = food.func_77973_b().func_77661_b(food);
        if (useAction == EnumAction.EAT || useAction == EnumAction.DRINK) {
            return true;
        }
        return AppleCoreAPI.registry.getEdibleBlockFromItem(food.func_77973_b()) != null;
    }

    @Override
    public boolean canPlayerEatFood(@Nonnull ItemStack food, @Nonnull EntityPlayer player) {
        return player.func_71024_bL().func_75116_a() < this.getMaxHunger(player) || this.isAlwaysEdible(food);
    }

    private boolean isAlwaysEdible(@Nonnull ItemStack food) {
        if (food == ItemStack.field_190927_a || !(food.func_77973_b() instanceof ItemFood)) {
            return false;
        }
        try {
            return itemFoodAlwaysEdible.getBoolean(food.func_77973_b());
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FoodValues getUnmodifiedFoodValues(@Nonnull ItemStack food) {
        if (food != ItemStack.field_190927_a) {
            if (food.func_77973_b() instanceof IEdible) {
                return ((IEdible)food.func_77973_b()).getFoodValues(food);
            }
            if (food.func_77973_b() instanceof ItemFood) {
                return this.getItemFoodValues((ItemFood)food.func_77973_b(), food);
            }
            Block block = AppleCoreAPI.registry.getEdibleBlockFromItem(food.func_77973_b());
            if (block != null && block instanceof IEdible) {
                return ((IEdible)block).getFoodValues(food);
            }
        }
        return null;
    }

    private FoodValues getItemFoodValues(@Nonnull ItemFood itemFood, @Nonnull ItemStack itemStack) {
        return new FoodValues(itemFood.func_150905_g(itemStack), itemFood.func_150906_h(itemStack));
    }

    @Override
    public FoodValues getFoodValues(@Nonnull ItemStack food) {
        FoodValues foodValues = this.getUnmodifiedFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetFoodValues event = new FoodEvent.GetFoodValues(food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public FoodValues getFoodValuesForPlayer(@Nonnull ItemStack food, EntityPlayer player) {
        FoodValues foodValues = this.getFoodValues(food);
        if (foodValues != null) {
            FoodEvent.GetPlayerFoodValues event = new FoodEvent.GetPlayerFoodValues(player, food, foodValues);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.foodValues;
        }
        return null;
    }

    @Override
    public float getExhaustion(EntityPlayer player) {
        try {
            return this.getAppleCoreFoodStats(player).getExhaustion();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    @Override
    public float getMaxExhaustion(EntityPlayer player) {
        ExhaustionEvent.GetMaxExhaustion event = new ExhaustionEvent.GetMaxExhaustion(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.maxExhaustionLevel;
    }

    @Override
    public int getHealthRegenTickPeriod(EntityPlayer player) {
        HealthRegenEvent.GetRegenTickPeriod event = new HealthRegenEvent.GetRegenTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.regenTickPeriod;
    }

    @Override
    public int getStarveDamageTickPeriod(EntityPlayer player) {
        StarvationEvent.GetStarveTickPeriod event = new StarvationEvent.GetStarveTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.starveTickPeriod;
    }

    @Override
    public int getSaturatedHealthRegenTickPeriod(EntityPlayer player) {
        HealthRegenEvent.GetSaturatedRegenTickPeriod event = new HealthRegenEvent.GetSaturatedRegenTickPeriod(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.regenTickPeriod;
    }

    @Override
    public int getMaxHunger(EntityPlayer player) {
        HungerEvent.GetMaxHunger event = new HungerEvent.GetMaxHunger(player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.maxHunger;
    }

    @Override
    public void setExhaustion(EntityPlayer player, float exhaustion) {
        try {
            this.getAppleCoreFoodStats(player).setExhaustion(exhaustion);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setHunger(EntityPlayer player, int hunger) {
        player.func_71024_bL().func_75114_a(hunger);
    }

    @Override
    public void setSaturation(EntityPlayer player, float saturation) {
        try {
            this.getAppleCoreFoodStats(player).setSaturation(saturation);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setHealthRegenTickCounter(EntityPlayer player, int tickCounter) {
        try {
            this.getAppleCoreFoodStats(player).setFoodTimer(tickCounter);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setStarveDamageTickCounter(EntityPlayer player, int tickCounter) {
        try {
            this.getAppleCoreFoodStats(player).setStarveTimer(tickCounter);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IAppleCoreFoodStats getAppleCoreFoodStats(EntityPlayer player) throws ClassCastException {
        return (IAppleCoreFoodStats)player.func_71024_bL();
    }

    static {
        itemFoodAlwaysEdible = ReflectionHelper.findField(ItemFood.class, (String[])new String[]{"alwaysEdible", "field_77852_bZ", "e"});
    }
}

