/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.tilemodule.progress;

import com.valkyrieofnight.vliblegacy.lib.tilemodule.progress.ProgressTracker;
import net.minecraft.world.World;

public interface ITileProgress {
    public ProgressTracker getTracker();

    public World getTheWorld();

    default public void updateProgress() {
        if (!this.getTheWorld().field_72995_K) {
            if (this.getTracker().hasStarted()) {
                int processable = this.canProcess(this.processTicks());
                if (processable > 0) {
                    if (!this.getTracker().isComplete()) {
                        this.onProcessTick(processable);
                        this.getTracker().tick(processable);
                    }
                    if (this.getTracker().isComplete()) {
                        this.onProcessComplete();
                        this.startNewProcess();
                    }
                } else {
                    this.onIdleTick();
                }
            }
            if (!this.getTracker().hasStarted()) {
                this.startNewProcess();
            }
            this.serverUpdate();
        } else {
            this.clientUpdate();
        }
    }

    default public void startNewProcess() {
        if (this.canStartProcess()) {
            this.onProcessStart();
            this.getTracker().resetTracker(this.getCurrentDuration());
            this.getTracker().startTracker();
        }
    }

    public int getCurrentDuration();

    public boolean canStartProcess();

    public int canProcess(int var1);

    public int processTicks();

    public void onProcessStart();

    public void onProcessTick(int var1);

    public void onProcessComplete();

    public void onIdleTick();

    public void serverUpdate();

    public void clientUpdate();

    default public void packetUpdateProgress(int dur, int pro) {
        this.getTracker().resetTracker(dur);
        this.getTracker().startTracker();
        this.getTracker().tick(pro);
    }
}

