/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.block;

import java.util.HashMap;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import org.dave.compactmachines3.block.BlockBaseTunnel;
import org.dave.compactmachines3.init.Blockss;
import org.dave.compactmachines3.init.Itemss;
import org.dave.compactmachines3.tile.TileEntityRedstoneTunnel;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.StructureTools;

public class BlockRedstoneTunnel
extends BlockBaseTunnel {
    public static final PropertyBool IS_OUTPUT = PropertyBool.func_177716_a((String)"output");

    public BlockRedstoneTunnel(Material material) {
        super(material);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)MACHINE_SIDE, (Comparable)EnumFacing.DOWN).func_177226_a((IProperty)IS_OUTPUT, (Comparable)Boolean.valueOf(false)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K || !(player instanceof EntityPlayerMP)) {
            return true;
        }
        EnumFacing connectedSide = (EnumFacing)state.func_177229_b((IProperty)MACHINE_SIDE);
        double faceX = 0.0;
        double faceY = 0.0;
        if (facing.func_176740_k() == EnumFacing.Axis.X) {
            faceY = hitY;
            faceX = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? (double)hitZ : 1.0 - (double)hitZ;
        } else if (facing.func_176740_k() == EnumFacing.Axis.Z) {
            faceY = hitY;
            faceX = facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE ? 1.0 - (double)hitX : (double)hitX;
        } else if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            if (facing.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE) {
                faceY = hitZ;
                faceX = hitX;
            } else {
                faceY = 1.0 - (double)hitZ;
                faceX = hitX;
            }
        }
        if (faceX >= 0.69 && faceX <= 0.94 && faceY >= 0.69 && faceY <= 0.94) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)IS_OUTPUT, (Comparable)Boolean.valueOf((Boolean)state.func_177229_b((IProperty)IS_OUTPUT) == false)));
            WorldSavedDataMachines.INSTANCE.toggleRedstoneTunnelOutput(pos);
            this.notifyOverworldNeighbor(pos);
            world.func_175685_c(pos, (Block)Blockss.redstoneTunnel, false);
        } else {
            EnumFacing nextDirection = StructureTools.getNextDirection(connectedSide);
            int coords = StructureTools.getCoordsForPos(pos);
            HashMap<EnumFacing, RedstoneTunnelData> sideMapping = WorldSavedDataMachines.INSTANCE.redstoneTunnels.get(coords);
            while (sideMapping != null) {
                if (nextDirection == null) {
                    if (world.func_175625_s(pos) != null) {
                        world.func_175713_t(pos);
                    }
                    IBlockState blockState = Blockss.wall.func_176223_P();
                    world.func_175656_a(pos, blockState);
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)Itemss.redstoneTunnelTool));
                    WorldSavedDataMachines.INSTANCE.removeRedstoneTunnel(pos);
                    break;
                }
                if (sideMapping.get(nextDirection) == null) {
                    if (world.func_175625_s(pos) != null) {
                        world.func_175713_t(pos);
                    }
                    world.func_175656_a(pos, state.func_177226_a((IProperty)MACHINE_SIDE, (Comparable)nextDirection));
                    WorldSavedDataMachines.INSTANCE.removeRedstoneTunnel(pos, connectedSide);
                    WorldSavedDataMachines.INSTANCE.addRedstoneTunnel(pos, nextDirection, (Boolean)state.func_177229_b((IProperty)IS_OUTPUT));
                    break;
                }
                nextDirection = StructureTools.getNextDirection(nextDirection);
            }
            this.notifyOverworldNeighbor(pos);
        }
        return true;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return 0;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!(blockAccess.func_175625_s(pos) instanceof TileEntityRedstoneTunnel)) {
            return 0;
        }
        TileEntityRedstoneTunnel redstoneTunnel = (TileEntityRedstoneTunnel)blockAccess.func_175625_s(pos);
        return redstoneTunnel.getRedstonePowerInput((EnumFacing)blockState.func_177229_b((IProperty)MACHINE_SIDE));
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityRedstoneTunnel();
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        if (meta >= 6) {
            state = state.func_177226_a((IProperty)MACHINE_SIDE, (Comparable)EnumFacing.func_82600_a((int)(meta - 6)));
            state = state.func_177226_a((IProperty)IS_OUTPUT, (Comparable)Boolean.valueOf(true));
        } else {
            state = state.func_177226_a((IProperty)MACHINE_SIDE, (Comparable)EnumFacing.func_82600_a((int)meta));
            state = state.func_177226_a((IProperty)IS_OUTPUT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)MACHINE_SIDE)).func_176745_a() + ((Boolean)state.func_177229_b((IProperty)IS_OUTPUT) != false ? 6 : 0);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MACHINE_SIDE, IS_OUTPUT});
    }

    @Override
    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        probeInfo.horizontal().item(new ItemStack(Items.field_151137_ax), probeInfo.defaultItemStyle().width(14).height(14)).text((Boolean)blockState.func_177229_b((IProperty)IS_OUTPUT) != false ? TextFormatting.DARK_GREEN + "Output" : TextFormatting.DARK_RED + "Input");
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
    }
}

