/*
 * Decompiled with CFR 0.152.
 */
package net.shadowfacts.shadowmc.ui.element.view;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import net.minecraft.util.ITickable;
import net.shadowfacts.shadowmc.ui.UIElement;
import net.shadowfacts.shadowmc.ui.UIKeyInteractable;
import net.shadowfacts.shadowmc.ui.UIMouseInteractable;
import net.shadowfacts.shadowmc.ui.element.UIElementBase;
import net.shadowfacts.shadowmc.ui.util.UIHelper;
import net.shadowfacts.shadowmc.util.MouseButton;

public abstract class UIView
extends UIElementBase
implements UIMouseInteractable,
UIKeyInteractable,
ITickable {
    protected Set<UIElement> children = new LinkedHashSet<UIElement>();

    public UIView(String type, String id, String ... classes) {
        super(type, id, classes);
    }

    public void add(UIElement element) {
        element.setParent(this);
        this.children.add(element);
    }

    public void addAll(Collection<UIElement> elements) {
        for (UIElement element : elements) {
            this.add(element);
        }
    }

    @Override
    public void setX(int x) {
        for (UIElement e : this.children) {
            e.setX(e.getX() - this.x + x);
        }
        super.setX(x);
    }

    @Override
    public void setY(int y) {
        for (UIElement e : this.children) {
            e.setY(e.getY() - this.y + y);
        }
        super.setY(y);
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        this.children.forEach(e -> e.draw(mouseX, mouseY));
    }

    public void func_73660_a() {
        this.children.stream().filter(e -> e instanceof ITickable).map(e -> (ITickable)e).forEach(ITickable::func_73660_a);
    }

    @Override
    public void drawTooltip(int mouseX, int mouseY) {
        this.children.stream().filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).forEach(e -> e.drawTooltip(mouseX, mouseY));
    }

    @Override
    public void mouseClickDown(int mouseX, int mouseY, MouseButton button) {
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseClickDown(mouseX, mouseY, button));
    }

    @Override
    public void mouseClickUp(int mouseX, int mouseY, MouseButton button) {
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseClickUp(mouseX, mouseY, button));
    }

    @Override
    public void mouseClickAnywhere(int mouseX, int mouseY, MouseButton button) {
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseClickAnywhere(mouseX, mouseY, button));
    }

    @Override
    public void mouseScroll(int mouseX, int mouseY, int delta) {
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseScroll(mouseX, mouseY, delta));
    }

    @Override
    public void mouseMove(int mouseX, int mouseY, MouseButton button, long timeSinceLastClick) {
        this.children.stream().filter(e -> e instanceof UIMouseInteractable).filter(e -> UIHelper.isWithinBounds(mouseX, mouseY, e)).map(e -> (UIMouseInteractable)((Object)e)).forEach(e -> e.mouseMove(mouseX, mouseY, button, timeSinceLastClick));
    }

    @Override
    public void keyPress(int keyCode, char keyChar) {
        this.children.stream().filter(e -> e instanceof UIKeyInteractable).map(e -> (UIKeyInteractable)((Object)e)).forEach(e -> e.keyPress(keyCode, keyChar));
    }

    public Set<UIElement> getChildren() {
        return this.children;
    }
}

