/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.commands;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.lostcities.dimensions.world.LostCityChunkGenerator;
import mcjty.lostcities.dimensions.world.WorldTypeTools;
import mcjty.lostcities.dimensions.world.lost.BuildingInfo;
import mcjty.lostcities.dimensions.world.lost.cityassets.AssetRegistries;
import mcjty.lostcities.dimensions.world.lost.cityassets.BuildingPart;
import mcjty.lostcities.dimensions.world.lost.cityassets.CompiledPalette;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class CommandBuildPart
implements ICommand {
    public String func_71517_b() {
        return "lc_buildpart";
    }

    public String func_71518_a(ICommandSender sender) {
        return this.func_71517_b() + " <partname>";
    }

    public List<String> func_71514_a() {
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        try {
            String partname = args[0];
            BuildingPart part = AssetRegistries.PARTS.get(partname);
            if (part == null) {
                sender.func_145747_a((ITextComponent)new TextComponentString("Cannot find part '" + partname + "'!"));
                return;
            }
            EntityPlayer player = (EntityPlayer)sender;
            BlockPos start = player.func_180425_c();
            LostCityChunkGenerator provider = WorldTypeTools.getChunkGenerator(sender.func_130014_f_().field_73011_w.getDimension());
            BuildingInfo info = BuildingInfo.getBuildingInfo(start.func_177958_n() >> 4, start.func_177952_p() >> 4, provider);
            CompiledPalette palette = info.getCompiledPalette();
            for (int y = 0; y < part.getSliceCount(); ++y) {
                for (int x = 0; x < part.getXSize(); ++x) {
                    for (int z = 0; z < part.getZSize(); ++z) {
                        BlockPos pos = new BlockPos(info.chunkX * 16 + x, start.func_177956_o() + y, info.chunkZ * 16 + z);
                        Character character = part.getC(x, y, z);
                        IBlockState state = palette.getStraight(character.charValue());
                        if (state == null || state.func_177230_c() == Blocks.field_150483_bI) continue;
                        try {
                            sender.func_130014_f_().func_180501_a(pos, state, 3);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }

    public int compareTo(ICommand o) {
        return this.func_71517_b().compareTo(o.func_71517_b());
    }

    public static class Slice {
        String[] sequence = new String[256];
    }
}

