/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.transformers;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.StringUtils;
import techreborn.blocks.transformers.BlockTransformer;

@RebornRegistry(modID="techreborn")
public class TileTransformer
extends TilePowerAcceptor
implements IToolDrop,
IListInfoProvider {
    @ConfigRegistry(config="misc", category="general", key="IC2TransformersStyle", comment="Input from dots side, output from other sides, like in IC2.")
    public static boolean IC2TransformersStyle = false;
    public String name;
    public Block wrenchDrop;
    public EnumPowerTier inputTier;
    public EnumPowerTier ouputTier;
    public int maxInput;
    public int maxOutput;
    public int maxStorage;

    public TileTransformer(String name, Block wrenchDrop, EnumPowerTier tier) {
        this.wrenchDrop = wrenchDrop;
        this.inputTier = tier;
        this.ouputTier = tier != EnumPowerTier.MICRO ? EnumPowerTier.values()[tier.ordinal() - 1] : EnumPowerTier.MICRO;
        this.name = name;
        this.maxInput = tier.getMaxInput();
        this.maxOutput = tier.getMaxOutput();
        this.maxStorage = tier.getMaxInput() * 2;
        super.setMaxPacketsPerTick(tier.getMaxOutput() / this.ouputTier.getMaxInput());
    }

    public double getBaseMaxPower() {
        return this.maxStorage;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        if (IC2TransformersStyle) {
            return this.getFacing() == direction;
        }
        return this.getFacing() != direction;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        if (IC2TransformersStyle) {
            return this.getFacing() != direction;
        }
        return this.getFacing() == direction;
    }

    public double getBaseMaxOutput() {
        return this.ouputTier.getMaxOutput();
    }

    public double getBaseMaxInput() {
        return this.inputTier.getMaxInput();
    }

    public EnumPowerTier getBaseTier() {
        return this.inputTier;
    }

    public EnumPowerTier getPushingTier() {
        return this.ouputTier;
    }

    public void checkTeir() {
    }

    public EnumFacing getFacing() {
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block instanceof BlockTransformer) {
            return ((BlockTransformer)block).getFacing(this.field_145850_b, this.field_174879_c);
        }
        return null;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(this.wrenchDrop);
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + "Input Rate: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)((int)this.getMaxInput())));
        info.add(TextFormatting.GRAY + "Input Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.inputTier.toString()));
        info.add(TextFormatting.GRAY + "Output Rate: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)((int)this.getMaxOutput())));
        info.add(TextFormatting.GRAY + "Output Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.ouputTier.toString()));
    }
}

