/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.multiblock;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.RebornMachineTile;
import reborncore.common.util.Inventory;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.tiles.TileGenericMachine;
import techreborn.tiles.multiblock.MultiblockChecker;

@RebornRegistry(modID="techreborn")
public class TileImplosionCompressor
extends TileGenericMachine
implements IContainerProvider {
    @ConfigRegistry(config="machines", category="implosion_compressor", key="ImplosionCompressorMaxInput", comment="Implosion Compressor Max Input (Value in EU)")
    public static int maxInput = 64;
    @ConfigRegistry(config="machines", category="implosion_compressor", key="ImplosionCompressorMaxEnergy", comment="Implosion Compressor Max Energy (Value in EU)")
    public static int maxEnergy = 64000;
    public MultiblockChecker multiblockChecker;

    public TileImplosionCompressor() {
        super("ImplosionCompressor", maxInput, maxEnergy, ModBlocks.IMPLOSION_COMPRESSOR, 4);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3};
        this.inventory = new Inventory(5, "TileImplosionCompressor", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.IMPLOSION_COMPRESSOR_RECIPE, (TileEntity)this, 2, 2, this.inventory, inputs, outputs);
    }

    public boolean getMutliBlock() {
        if (this.multiblockChecker == null) {
            return false;
        }
        boolean down = this.multiblockChecker.checkRectY(1, 1, "reinforced", MultiblockChecker.ZERO_OFFSET);
        boolean up = this.multiblockChecker.checkRectY(1, 1, "reinforced", new BlockPos(0, 2, 0));
        boolean chamber = this.multiblockChecker.checkRingYHollow(1, 1, "reinforced", new BlockPos(0, 1, 0));
        return down && chamber && up;
    }

    @Override
    public void func_73660_a() {
        if (this.multiblockChecker == null) {
            this.multiblockChecker = new MultiblockChecker(this.field_145850_b, this.field_174879_c.func_177979_c(3));
        }
        if (!this.field_145850_b.field_72995_K && this.getMutliBlock()) {
            super.func_73660_a();
        }
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("implosioncompressor").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 50, 27).slot(1, 50, 47).outputSlot(2, 92, 36).outputSlot(3, 110, 36).energySlot(4, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((RebornMachineTile)this);
    }
}

