/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator.fluid;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.IToolDrop;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.api.praescriptum.fuels.FuelHandler;
import reborncore.api.praescriptum.ingredients.input.FluidStackInputIngredient;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.common.fluids.RebornFluidTank;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;

public abstract class TileFluidGenerator
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    public final String name;
    public final int maxOutput;
    public final int maxEnergy;
    public final RebornFluidTank tank;
    public final Inventory inventory;
    public final FuelHandler fuelHandler;
    public final Block drop;
    protected final int[] inputSlots;
    protected final int[] outputSlots;
    protected int remainingEnergy = 0;
    protected int totalEnergy = 0;
    protected int energyPerTick = 0;

    public TileFluidGenerator(String name, int maxOutput, int maxEnergy, int tankCapacity, FuelHandler fuelHandler, Block drop) {
        this.name = "Tile" + name;
        this.maxOutput = maxOutput;
        this.maxEnergy = maxEnergy;
        List fluids = fuelHandler.getFuels().stream().flatMap(fuel -> fuel.getInputIngredients().stream().filter(ingredient -> ingredient instanceof FluidStackInputIngredient).map(ingredient -> ((FluidStack)((FluidStackInputIngredient)ingredient).ingredient).getFluid())).collect(Collectors.toList());
        this.tank = new RebornFluidTank(this.name, tankCapacity, (TileEntity)this, fluids::contains);
        this.inventory = new Inventory(2, name, 64, (TileEntity)this);
        this.inputSlots = new int[]{0};
        this.outputSlots = new int[]{1};
        this.fuelHandler = fuelHandler;
        this.drop = drop;
        this.checkTeir();
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound data = tag.func_74775_l("TileFluidGenerator");
        this.remainingEnergy = data.func_74764_b("remainingEnergy") ? data.func_74762_e("remainingEnergy") : 0;
        this.totalEnergy = data.func_74764_b("totalEnergy") ? data.func_74762_e("totalEnergy") : 0;
        this.energyPerTick = data.func_74764_b("energyPerTick") ? data.func_74762_e("energyPerTick") : 0;
        this.tank.readFromNBT(tag);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("remainingEnergy", this.remainingEnergy);
        data.func_74768_a("totalEnergy", this.totalEnergy);
        data.func_74768_a("energyPerTick", this.energyPerTick);
        tag.func_74782_a("TileFluidGenerator", (NBTBase)data);
        this.tank.writeToNBT(tag);
        return tag;
    }

    public void func_73660_a() {
        boolean containerDrained;
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean needsInventoryUpdate = false;
        if (this.field_145850_b.func_82737_E() % 10L == 0L && !this.inventory.func_70301_a(0).func_190926_b() && (containerDrained = FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1))) {
            needsInventoryUpdate = true;
        }
        if (this.remainingEnergy > 0) {
            int amount = Math.min(this.remainingEnergy, this.energyPerTick);
            if (this.canAddEnergy(amount)) {
                this.addEnergy(amount);
                this.remainingEnergy -= amount;
            }
        } else if (this.doWork()) {
            needsInventoryUpdate = true;
            if (!this.isActive()) {
                this.setActive(true);
            }
        } else if (this.isActive()) {
            this.setActive(false);
        }
        if (needsInventoryUpdate) {
            super.func_70296_d();
        }
    }

    public double getBaseMaxPower() {
        return this.maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return this.maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    protected boolean doWork() {
        if (this.tank.isEmpty() || this.tank.getFluid() == null) {
            return false;
        }
        if (this.getEnergy() == (double)this.maxEnergy) {
            return false;
        }
        Fuel fuel = this.fuelHandler.findAndApply2(this.tank.getFluid(), false);
        if (fuel == null) {
            this.reset();
            return false;
        }
        this.remainingEnergy = (int)fuel.getEnergyOutput();
        this.totalEnergy = (int)fuel.getEnergyOutput();
        this.energyPerTick = (int)fuel.getEnergyPerTick();
        return true;
    }

    protected void reset() {
        this.remainingEnergy = 0;
        this.totalEnergy = 0;
        this.energyPerTick = 0;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolDrop(EntityPlayer player) {
        return new ItemStack(this.drop, 1);
    }

    public RebornFluidTank getTank() {
        return this.tank;
    }

    public int getRemainingEnergy() {
        return this.remainingEnergy;
    }

    public void setRemainingEnergy(int remainingEnergy) {
        this.remainingEnergy = remainingEnergy;
    }

    public int getTotalEnergy() {
        return this.totalEnergy;
    }

    public void setTotalEnergy(int totalEnergy) {
        this.totalEnergy = totalEnergy;
    }

    public int getRemainingEnergyScaled(int scale) {
        return this.remainingEnergy == 0 || this.totalEnergy == 0 ? 0 : (this.totalEnergy - this.remainingEnergy) * scale / this.totalEnergy;
    }
}

