/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import ic2.api.item.IMiningDrill;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModItems;
import techreborn.utils.StringUtilities;
import techreborn.utils.TechRebornCreativeTab;

@Optional.Interface(iface="ic2.api.item.IMiningDrill", modid="ic2")
public class ItemDrill
extends ItemPickaxe
implements IEnergyItemInfo,
IMiningDrill {
    public int maxCharge = 1;
    public int cost = 250;
    public float unpoweredSpeed = 2.0f;
    public double transferLimit = 100.0;

    public ItemDrill(Item.ToolMaterial material, String unlocalizedName, int energyCapacity, float unpoweredSpeed, float efficiencyOnProperMaterial) {
        super(material);
        this.field_77864_a = efficiencyOnProperMaterial;
        this.func_77637_a(TechRebornCreativeTab.instance);
        this.func_77625_d(1);
        this.func_77655_b(unlocalizedName);
        this.maxCharge = energyCapacity;
        this.unpoweredSpeed = unpoweredSpeed;
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            return this.unpoweredSpeed;
        }
        if (Items.field_151039_o.func_150893_a(stack, state) > 1.0f || Items.field_151038_n.func_150893_a(stack, state) > 1.0f) {
            return this.field_77864_a;
        }
        return super.func_150893_a(stack, state);
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack) + 1) == 0) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        }
        return true;
    }

    public boolean func_77644_a(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.func_77969_a(oldStack);
    }

    public double getMaxPower(ItemStack stack) {
        return this.maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }

    @Optional.Method(modid="ic2")
    public int energyUse(ItemStack stack, World world, BlockPos pos, IBlockState state) {
        if (stack.func_77973_b() == ModItems.STEEL_DRILL) {
            return 6;
        }
        if (stack.func_77973_b() == ModItems.DIAMOND_DRILL) {
            return 20;
        }
        if (stack.func_77973_b() == ModItems.ADVANCED_DRILL) {
            return 200;
        }
        throw new IllegalArgumentException("Invalid drill: " + StringUtilities.stackToStringSafe(stack));
    }

    @Optional.Method(modid="ic2")
    public int breakTime(ItemStack stack, World world, BlockPos pos, IBlockState state) {
        if (stack.func_77973_b() == ModItems.STEEL_DRILL) {
            return 200;
        }
        if (stack.func_77973_b() == ModItems.DIAMOND_DRILL) {
            return 50;
        }
        if (stack.func_77973_b() == ModItems.ADVANCED_DRILL) {
            return 20;
        }
        throw new IllegalArgumentException("Invalid drill: " + StringUtilities.stackToStringSafe(stack));
    }

    @Optional.Method(modid="ic2")
    public boolean breakBlock(ItemStack stack, World world, BlockPos pos, IBlockState state) {
        if (stack.func_77973_b() == ModItems.STEEL_DRILL) {
            return this.tryUsePower(stack, 50.0);
        }
        if (stack.func_77973_b() == ModItems.DIAMOND_DRILL) {
            return this.tryUsePower(stack, 80.0);
        }
        if (stack.func_77973_b() == ModItems.ADVANCED_DRILL) {
            return this.tryUsePower(stack, 800.0);
        }
        throw new IllegalArgumentException("Invalid drill: " + StringUtilities.stackToStringSafe(stack));
    }

    @Optional.Method(modid="ic2")
    public boolean tryUsePower(ItemStack drill, double amount) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(drill);
        if (capEnergy.getEnergyStored() < (int)amount) {
            return false;
        }
        capEnergy.extractEnergy((int)amount, false);
        return true;
    }
}

