/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.praescriptum.thermalgenerator;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import net.minecraft.client.Minecraft;
import reborncore.api.praescriptum.fuels.Fuel;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.compat.jei.FuelWrapper;

public class ThermalGeneratorFuelWrapper
extends FuelWrapper {
    private final IDrawableAnimated progress;
    private final IDrawableAnimated energyGauge;

    public ThermalGeneratorFuelWrapper(IJeiHelpers jeiHelpers, Fuel fuel) {
        super(fuel);
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        GuiBuilder.ProgressDirection progressDirection = GuiBuilder.ProgressDirection.RIGHT;
        IDrawableStatic progressStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, progressDirection.xActive, progressDirection.yActive, progressDirection.width, progressDirection.height);
        IDrawableStatic energyGaugeStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, 113, 151, 12, 48);
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, 50, IDrawableAnimated.StartDirection.LEFT, false);
        this.energyGauge = guiHelper.createAnimatedDrawable(energyGaugeStatic, 200, IDrawableAnimated.StartDirection.BOTTOM, false);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.progress.draw(minecraft, 52, 23);
        this.energyGauge.draw(minecraft, 79, 4);
        int y = 58;
        int lineHeight = minecraft.field_71466_p.field_78288_b;
        String totalEnergy = PowerSystem.getLocaliszedPowerFormatted((double)this.fuel.getEnergyOutput());
        minecraft.field_71466_p.func_78276_b(totalEnergy, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(totalEnergy) / 2, y, 0x444444);
        String energyPerTick = PowerSystem.getLocaliszedPowerFormatted((double)this.fuel.getEnergyPerTick()) + "/t";
        minecraft.field_71466_p.func_78276_b(energyPerTick, recipeWidth / 2 - minecraft.field_71466_p.func_78256_a(energyPerTick) / 2, y + lineHeight + 1, 0x444444);
    }
}

