/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.multitank;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.blocks.multitank.MultiTankTileEntity;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class MultiTankFluidProperties
implements IFluidTankProperties {
    @Nullable
    private FluidStack contents;
    private final int capacity;
    private final boolean canFill;
    private final boolean canDrain;
    @Nonnull
    private final MultiTankTileEntity tankTileEntity;

    public MultiTankFluidProperties(@Nonnull MultiTankTileEntity tankTileEntity, @Nullable FluidStack contents, int capacity) {
        this(tankTileEntity, contents, capacity, true, true);
    }

    public MultiTankFluidProperties(@Nonnull MultiTankTileEntity tankTileEntity, @Nullable FluidStack contents, int capacity, boolean canFill, boolean canDrain) {
        this.tankTileEntity = tankTileEntity;
        this.contents = contents;
        this.capacity = capacity;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    @Nullable
    public FluidStack getContents() {
        return this.contents == null ? null : this.contents.copy();
    }

    public FluidStack getContentsInternal() {
        return this.contents;
    }

    public boolean hasContents() {
        return this.contents != null;
    }

    public void drain(int amount) {
        if (this.contents == null) {
            return;
        }
        this.contents.amount -= amount;
        if (this.contents.amount <= 0) {
            this.contents = null;
        }
        this.tankTileEntity.func_70296_d();
    }

    public void fill(FluidStack stack) {
        if (stack == null) {
            return;
        }
        if (this.contents == null) {
            this.contents = stack;
        } else {
            this.contents.amount += stack.amount;
        }
        this.tankTileEntity.func_70296_d();
    }

    public void set(FluidStack stack) {
        this.contents = stack == null ? null : stack.copy();
        this.tankTileEntity.func_70296_d();
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean canFill() {
        return this.canFill;
    }

    public boolean canDrain() {
        return this.canDrain;
    }

    public boolean canFillFluidType(FluidStack fluidStack) {
        return this.canFill;
    }

    public boolean canDrainFluidType(FluidStack fluidStack) {
        return this.canDrain;
    }
}

