/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.modintegration.crafttweaker;

import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenDoc;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.StormForgeRegistry;
import shetiphian.terraqueous.modintegration.crafttweaker.StormForgeStackHandler;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.terraqueous.StormForge")
@ZenRegister
@ModOnly(value="terraqueous")
public class StormForge {
    @ZenMethod
    public static void addConversion(IItemStack result, IIngredient input, int ticksToComplete, boolean lightningStrikeOnComplete) {
        StormForge.addConversion(result, input, ticksToComplete, lightningStrikeOnComplete, null);
    }

    @ZenMethod
    @ZenDoc(value="If provided altResult will be used if the StormForge is struck by lightning while processing this item")
    public static void addConversion(IItemStack result, IIngredient input, int ticksToComplete, @Optional IItemStack altResult) {
        StormForge.addConversion(result, input, ticksToComplete, false, altResult);
    }

    private static void addConversion(IItemStack result, IIngredient input, int ticksToComplete, boolean lightningStrikeOnComplete, IItemStack altResult) {
        if (result == null || result.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid StormForgeConversion from CraftTweaker: result can not be null");
            return;
        }
        if (input == null || input.getAmount() == 0) {
            Values.logTerraqueous.error("Skipping invalid StormForgeConversion from CraftTweaker: input can not be null");
            return;
        }
        StormForgeRegistry.register(new StormForgeStackHandler(result, input, ticksToComplete, lightningStrikeOnComplete, altResult));
    }
}

