/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.worldgen;

import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSand;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.block.BlockDoodad;
import shetiphian.terraqueous.common.block.BlockEarthOre;
import shetiphian.terraqueous.common.worldgen.GenBase;

public class GenDoodads
extends GenBase {
    public GenDoodads() {
        this.mustHaveSky = false;
    }

    @Override
    public void generate(Random random, World world, BlockPos pos, ChunkPos chunkPos) {
        boolean genStick;
        if (Values.blockDoodad == null || !Configuration.GENERATOR.generateDoodads) {
            return;
        }
        Configuration.Menu_Generator.SubMenu_Doodads config = Configuration.GENERATOR.DOODADS;
        if (config.generateDoodad_Burnium && random.nextInt(100) < config.chunkChance_Burnium) {
            this.generateBurniumCrystals(random, world, pos);
        }
        if (config.generateDoodad_Endimium && random.nextInt(100) < config.chunkChance_Endimium) {
            this.generateEndimiumCrystals(random, world, pos);
        }
        boolean bl = genStick = config.generateDoodad_Stick && random.nextInt(100) < config.chunkChance_Stick;
        if (genStick) {
            this.generateSticksStonesAndBones(random, world, pos, chunkPos, EnumDoodad.STICK);
        }
        if (config.generateDoodad_Stone && random.nextInt(100) < config.chunkChance_Stone) {
            this.generateSticksStonesAndBones(random, world, pos, chunkPos, EnumDoodad.STONE);
        }
        if (config.generateDoodad_Bone && random.nextInt(100) < config.chunkChance_Bone) {
            this.generateSticksStonesAndBones(random, world, pos, chunkPos, EnumDoodad.BONE);
        }
        if (genStick || config.generateDoodad_Stick && random.nextInt(100) < config.chunkChance_Stick) {
            this.generateSticksStonesAndBones(random, world, pos, chunkPos, EnumDoodad.STICK);
        }
    }

    private void generateBurniumCrystals(Random random, World world, BlockPos pos) {
        if (!BiomeDictionary.hasType((Biome)world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return;
        }
        BlockPos sPos = new BlockPos(pos.func_177958_n(), 1, pos.func_177952_p());
        while (sPos.func_177956_o() < world.func_72940_L()) {
            if (random.nextBoolean() && random.nextBoolean() && world.func_175623_d(sPos) && world.isSideSolid(sPos.func_177977_b(), EnumFacing.UP, false)) {
                IBlockState crystalBurnium = BlockDoodad.EnumType.BURNIUM.state();
                IBlockState oreBurnium = BlockEarthOre.EnumType.BURNIUM_ORE.state();
                if (world.func_180495_p(sPos.func_177977_b()).func_177230_c() == Blocks.field_150424_aL) {
                    this.placeCrystal(world, sPos, crystalBurnium, oreBurnium, false, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177976_e(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177974_f(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177978_c(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    this.placeCrystal(world, sPos.func_177968_d(), crystalBurnium, oreBurnium, true, random, Blocks.field_150424_aL);
                    if (Values.blockEarthOre != null) {
                        this.generateOre(world, sPos, oreBurnium, random, Blocks.field_150424_aL);
                    }
                }
            }
            sPos = sPos.func_177984_a();
        }
    }

    private void generateEndimiumCrystals(Random random, World world, BlockPos pos) {
        if (!BiomeDictionary.hasType((Biome)world.func_175726_f(pos = this.getRandomXZ(random, pos)).func_177411_a(pos, world.func_72959_q()), (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            return;
        }
        if (!world.isSideSolid((pos = this.getTopBlock(world, pos)).func_177977_b(), EnumFacing.UP, false)) {
            return;
        }
        if (random.nextBoolean()) {
            return;
        }
        IBlockState crystalEndimium = BlockDoodad.EnumType.ENDIMIUM.state();
        IBlockState oreEndimium = BlockEarthOre.EnumType.ENDIMIUM_ORE.state();
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150377_bs) {
            this.placeCrystal(world, pos, crystalEndimium, oreEndimium, false, random, Blocks.field_150377_bs);
            if (Values.blockEarthOre != null) {
                this.generateOre(world, pos, oreEndimium, random, Blocks.field_150377_bs);
            }
        }
    }

    private void placeCrystal(World world, BlockPos pos, IBlockState crystal, IBlockState ore, boolean isExtra, Random random, Block replace) {
        if (isExtra) {
            if (!world.func_175623_d(pos) || !world.isSideSolid(pos.func_177977_b(), EnumFacing.UP, false)) {
                return;
            }
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() != replace || !random.nextBoolean()) {
                return;
            }
        }
        Function.setBlock((World)world, (BlockPos)pos, (IBlockState)crystal, (boolean)false);
        if (ore != null) {
            Function.setBlock((World)world, (BlockPos)pos.func_177977_b(), (IBlockState)ore, (boolean)false);
        }
    }

    private void generateOre(World world, BlockPos pos, IBlockState ore, Random random, Block replaceBlock) {
        pos = pos.func_177977_b();
        int yMin = pos.func_177956_o() - (random.nextInt(4) + 1);
        int yMax = pos.func_177956_o() + (random.nextInt(4) + 1);
        for (int yCurrent = yMin; yCurrent <= yMax; ++yCurrent) {
            int parts = random.nextInt(6) + 1;
            for (int part = 0; part < parts; ++part) {
                int xOffset = random.nextInt(5) - 3;
                int zOffset = random.nextInt(5) - 3;
                int xMin = pos.func_177958_n() - (random.nextInt(1) + 1) + xOffset;
                int xMax = pos.func_177958_n() + (random.nextInt(1) + 1) + xOffset;
                int zMin = pos.func_177952_p() - (random.nextInt(1) + 1) + zOffset;
                int zMax = pos.func_177952_p() + (random.nextInt(1) + 1) + zOffset;
                for (int xCurrent = xMin; xCurrent <= xMax; ++xCurrent) {
                    for (int zCurrent = zMin; zCurrent <= zMax; ++zCurrent) {
                        BlockPos place = new BlockPos(xCurrent, yCurrent, zCurrent);
                        if (world.func_180495_p(place).func_177230_c() != replaceBlock) continue;
                        Function.setBlock((World)world, (BlockPos)place, (IBlockState)ore, (boolean)false);
                    }
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void generateSticksStonesAndBones(Random random, World world, BlockPos pos, ChunkPos chunkPos, EnumDoodad doodad) {
        DecorateBiomeEvent.Decorate.EventType eventType;
        BlockPos basePos = pos;
        DecorateBiomeEvent.Decorate.EventType eventType2 = eventType = doodad == EnumDoodad.STICK ? DecorateBiomeEvent.Decorate.EventType.TREE : DecorateBiomeEvent.Decorate.EventType.CUSTOM;
        if (!this.canGenerateType(world, chunkPos, random, eventType)) {
            return;
        }
        pos = this.getRandomXZ(random, basePos);
        Biome biome = world.func_175726_f(pos).func_177411_a(pos, world.func_72959_q());
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END)) {
            return;
        }
        if (!world.isSideSolid((pos = this.getTopBlock(world, pos)).func_177977_b(), EnumFacing.UP, false)) {
            return;
        }
        IBlockState state = null;
        if (doodad == EnumDoodad.STONE) {
            BlockSand.EnumType type;
            IBlockState sState = world.func_180495_p(pos.func_177977_b());
            Block block = sState.func_177230_c();
            state = block == Blocks.field_150322_A || block == Blocks.field_180395_cM ? (block == Blocks.field_180395_cM ? BlockDoodad.EnumType.REDSANDSTONE.state() : BlockDoodad.EnumType.SANDSTONE.state()) : (block instanceof BlockSand ? ((type = (BlockSand.EnumType)sState.func_177229_b((IProperty)BlockSand.field_176504_a)) == BlockSand.EnumType.RED_SAND ? BlockDoodad.EnumType.REDSANDSTONE.state() : BlockDoodad.EnumType.SANDSTONE.state()) : BlockDoodad.EnumType.STONE.state());
        } else if (BiomeDictionary.hasAnyType((Biome)biome)) {
            Set types = BiomeDictionary.getTypes((Biome)biome);
            block4: for (BiomeDictionary.Type type : types) {
                switch (doodad) {
                    case STICK: {
                        if (type != BiomeDictionary.Type.JUNGLE && type != BiomeDictionary.Type.FOREST) break;
                        state = BlockDoodad.EnumType.BRANCH.state();
                        break block4;
                    }
                    case BONE: {
                        if (type != BiomeDictionary.Type.SANDY) break;
                        state = BlockDoodad.EnumType.BONE.state();
                        break block4;
                    }
                }
            }
        }
        if (state != null) {
            Function.setBlock((World)world, (BlockPos)pos, state, (boolean)false);
        }
    }

    private static enum EnumDoodad {
        STICK,
        STONE,
        BONE;

    }
}

