/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.inventory;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.machines.EnderTableRecipeHandler;
import shetiphian.terraqueous.api.machines.IEnderTableRecipe;

public class ContainerEnderTable
extends Container {
    public IInventory tableInventory;
    private Random random;
    public int[] experienceCost;
    public int[] materialCost;
    public int[] enchantIds;
    public String[] tooltips;
    private TriState refreshTooltips;
    private World world;
    private BlockPos pos;
    public short xpSeed;
    private EntityPlayer player;
    private NonNullList<ItemStack> listDust = Function.getOres((String)"dustEnder");

    public ContainerEnderTable(InventoryPlayer invPlayer, World world, BlockPos pos) {
        this.tableInventory = new InventoryEnderTable(this);
        this.random = new Random();
        this.experienceCost = new int[3];
        this.materialCost = new int[3];
        this.enchantIds = new int[]{-1, -1, -1};
        this.tooltips = new String[3];
        this.refreshTooltips = TriState.KEEP;
        this.world = world;
        this.pos = pos;
        this.player = invPlayer.field_70458_d;
        this.updateBaseSeed();
        this.func_75146_a(new SlotSingle(this.tableInventory, 0, 18, 41));
        this.func_75146_a(new Slot(this.tableInventory, 1, 38, 41));
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)invPlayer, col + row * 9 + 9, 11 + col * 18, 86 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.func_75146_a(new Slot((IInventory)invPlayer, col, 11 + col * 18, 144));
        }
    }

    private void updateBaseSeed() {
        this.random.setSeed(this.player.func_175138_ci());
        this.xpSeed = (short)(this.random.nextInt() >> 16);
        this.random.setSeed(this.xpSeed);
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        this.sendWindowProperties(listener);
        listener.func_71112_a((Container)this, 100, TriState.SET.ordinal());
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            this.sendWindowProperties(listener);
            if (this.refreshTooltips == TriState.KEEP) continue;
            listener.func_71112_a((Container)this, 100, this.refreshTooltips.ordinal());
            this.refreshTooltips = TriState.KEEP;
        }
    }

    private void sendWindowProperties(IContainerListener listener) {
        listener.func_71112_a((Container)this, 0, (int)this.xpSeed);
        listener.func_71112_a((Container)this, 1, this.experienceCost[0]);
        listener.func_71112_a((Container)this, 2, this.experienceCost[1]);
        listener.func_71112_a((Container)this, 3, this.experienceCost[2]);
        listener.func_71112_a((Container)this, 4, this.materialCost[0]);
        listener.func_71112_a((Container)this, 5, this.materialCost[1]);
        listener.func_71112_a((Container)this, 6, this.materialCost[2]);
        listener.func_71112_a((Container)this, 7, this.enchantIds[0]);
        listener.func_71112_a((Container)this, 8, this.enchantIds[1]);
        listener.func_71112_a((Container)this, 9, this.enchantIds[2]);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int data) {
        if (id == 0) {
            this.xpSeed = (short)data;
        } else if (id >= 1 && id <= 3) {
            this.experienceCost[id - 1] = data;
        } else if (id >= 4 && id <= 6) {
            this.materialCost[id - 4] = data;
        } else if (id >= 7 && id <= 9) {
            this.enchantIds[id - 7] = data;
        } else if (id == 100) {
            if (data == TriState.CLEAR.ordinal()) {
                this.tooltips[0] = "";
                this.tooltips[1] = "";
                this.tooltips[2] = "";
            } else {
                float enchantPower = this.getEnchantPower();
                EnderTableRecipeHandler.RecipeSet recipes = EnderTableRecipeHandler.INSTANCE.getRecipes(this.tableInventory.func_70301_a(0), this.tableInventory.func_70301_a(1), enchantPower, this.world);
                for (int index = 0; index < 3; ++index) {
                    this.tooltips[index] = EnderTableRecipeHandler.INSTANCE.getTooltip(recipes.get(index), this.tableInventory.func_70301_a(0), this.tableInventory.func_70301_a(1), IEnderTableRecipe.EnumOption.byIndex(index));
                }
            }
        }
    }

    public void func_75130_a(IInventory inventory) {
        this.refreshTooltips = TriState.CLEAR;
        for (int index = 0; index < 3; ++index) {
            this.experienceCost[index] = 0;
            this.materialCost[index] = index + 1;
            this.enchantIds[index] = -1;
        }
        if (inventory == this.tableInventory) {
            ItemStack enchantStack = inventory.func_70301_a(0);
            ItemStack materialStack = inventory.func_70301_a(1);
            if (!enchantStack.func_190926_b()) {
                float enchantPower = this.getEnchantPower();
                EnderTableRecipeHandler.RecipeSet recipes = EnderTableRecipeHandler.INSTANCE.getRecipes(enchantStack, materialStack, enchantPower, this.world);
                if (EnderTableRecipeHandler.INSTANCE.hasAnyEnchantResult(recipes, enchantStack, materialStack)) {
                    for (int index = 0; index < 3; ++index) {
                        IEnderTableRecipe.EnumOption option = IEnderTableRecipe.EnumOption.byIndex(index);
                        this.experienceCost[index] = EnderTableRecipeHandler.INSTANCE.getExpCost(recipes.get(index), enchantStack, materialStack, option);
                        this.materialCost[index] = EnderTableRecipeHandler.INSTANCE.getMaterialCost(recipes.get(index), enchantStack, materialStack, option);
                    }
                    this.refreshTooltips = TriState.SET;
                    this.func_75142_b();
                } else if (enchantStack.func_77956_u()) {
                    if (!materialStack.func_190926_b() && materialStack.func_77973_b() == Items.field_151065_br) {
                        if (!this.player.field_71075_bZ.field_75098_d) {
                            materialStack.func_190918_g(1);
                        }
                        this.player.func_192024_a(ItemStack.field_190927_a, 0);
                        this.updateBaseSeed();
                        Function.giveItem((EntityPlayer)this.player, (ItemStack)materialStack);
                        inventory.func_70299_a(1, ItemStack.field_190927_a);
                    }
                    if (!this.world.field_72995_K) {
                        this.random.setSeed(this.xpSeed);
                        for (int set = 0; set < 3; ++set) {
                            this.experienceCost[set] = EnchantmentHelper.func_77514_a((Random)this.random, (int)set, (int)((int)enchantPower), (ItemStack)enchantStack);
                            this.materialCost[set] = set + 1;
                            this.enchantIds[set] = -1;
                            if (this.experienceCost[set] < set + 1) {
                                this.experienceCost[set] = set + 1;
                            }
                            if (set > 0 && this.experienceCost[set] <= this.experienceCost[set - 1]) {
                                int n = set;
                                this.experienceCost[n] = this.experienceCost[n] + 1;
                            }
                            if (this.experienceCost[set] <= 0) continue;
                            List<EnchantmentData> list = this.getEnchantments(enchantStack, set, this.experienceCost[set]);
                            if (list != null && !list.isEmpty()) {
                                EnchantmentData enchantment = list.get(this.random.nextInt(list.size()));
                                this.enchantIds[set] = Enchantment.func_185258_b((Enchantment)enchantment.field_76302_b);
                                continue;
                            }
                            this.experienceCost[set] = 0;
                            this.materialCost[set] = set + 1;
                            this.enchantIds[set] = -1;
                        }
                        this.func_75142_b();
                    }
                }
            }
        }
    }

    private float getEnchantPower() {
        float enchantPower = 0.0f;
        for (int scanZ = -1; scanZ <= 1; ++scanZ) {
            for (int scanX = -1; scanX <= 1; ++scanX) {
                for (int scanY = 0; scanY < 3; ++scanY) {
                    if (scanZ == 0 && scanX == 0 || !this.world.func_175623_d(this.pos.func_177982_a(scanX, scanY, scanZ))) continue;
                    enchantPower += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(scanX * 2, scanY, scanZ * 2));
                    if (scanX == 0 || scanZ == 0) continue;
                    enchantPower += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(scanX * 2, scanY, scanZ));
                    enchantPower += ForgeHooks.getEnchantPower((World)this.world, (BlockPos)this.pos.func_177982_a(scanX, scanY, scanZ * 2));
                }
            }
        }
        return enchantPower;
    }

    public boolean func_75140_a(EntityPlayer player, int index) {
        IEnderTableRecipe.EnumOption option;
        float enchantPower;
        ItemStack dustStack;
        ItemStack enchantStack = this.tableInventory.func_70301_a(0);
        IEnderTableRecipe recipe = EnderTableRecipeHandler.INSTANCE.getRecipe(enchantStack, dustStack = this.tableInventory.func_70301_a(1), enchantPower = this.getEnchantPower(), option = IEnderTableRecipe.EnumOption.byIndex(index), this.world);
        ItemStack result = EnderTableRecipeHandler.INSTANCE.getEnchantResult(recipe, enchantStack, dustStack, option);
        if (!result.func_190926_b()) {
            enchantStack = result;
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_192024_a(enchantStack, this.experienceCost[index]);
                if (!dustStack.func_190926_b()) {
                    dustStack.func_190918_g(this.materialCost[index]);
                }
            }
            this.tableInventory.func_70299_a(0, enchantStack);
            if (dustStack.func_190926_b()) {
                this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
            } else {
                this.tableInventory.func_70299_a(1, dustStack);
            }
            EnderTableRecipeHandler.INSTANCE.doneEnchant(recipe, enchantStack, dustStack, enchantPower, option, this.world);
            return true;
        }
        int cost = index + 1;
        if ((dustStack.func_190926_b() || dustStack.func_190916_E() < cost) && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (this.experienceCost[index] > 0 && !enchantStack.func_190926_b() && (player.field_71068_ca >= cost && player.field_71068_ca >= this.experienceCost[index] || player.field_71075_bZ.field_75098_d)) {
            if (!this.world.field_72995_K) {
                boolean isBook;
                List<EnchantmentData> listEnchants = this.getEnchantments(enchantStack, index, this.experienceCost[index]);
                boolean bl = isBook = enchantStack.func_77973_b() == Items.field_151122_aG;
                if (listEnchants != null) {
                    player.func_192024_a(enchantStack, cost);
                    if (isBook) {
                        enchantStack = new ItemStack(Items.field_151134_bR);
                        this.tableInventory.func_70299_a(0, enchantStack);
                    }
                    for (EnchantmentData enchantment : listEnchants) {
                        if (isBook) {
                            ItemEnchantedBook.func_92115_a((ItemStack)enchantStack, (EnchantmentData)enchantment);
                            continue;
                        }
                        enchantStack.func_77966_a(enchantment.field_76302_b, enchantment.field_76303_c);
                    }
                    if (!player.field_71075_bZ.field_75098_d && !dustStack.func_190926_b()) {
                        dustStack.func_190918_g(cost);
                        if (dustStack.func_190926_b()) {
                            this.tableInventory.func_70299_a(1, ItemStack.field_190927_a);
                        }
                    }
                    player.func_71029_a(StatList.field_188091_Y);
                    if (player instanceof EntityPlayerMP) {
                        CriteriaTriggers.field_192129_i.func_192190_a((EntityPlayerMP)player, enchantStack, cost);
                    }
                    this.tableInventory.func_70296_d();
                    this.updateBaseSeed();
                    this.func_75130_a(this.tableInventory);
                }
            }
            return true;
        }
        return false;
    }

    private List<EnchantmentData> getEnchantments(ItemStack stack, int index, int level) {
        this.random.setSeed(this.xpSeed + index);
        List list = EnchantmentHelper.func_77513_b((Random)this.random, (ItemStack)stack, (int)level, (boolean)false);
        if (stack.func_77973_b() == Items.field_151122_aG && list != null && list.size() > 1) {
            list.remove(this.random.nextInt(list.size()));
        }
        return list;
    }

    public boolean hasMaterialNeeded(int index) {
        if (this.materialCost[index] < 1) {
            return true;
        }
        ItemStack stack = this.tableInventory.func_70301_a(1);
        if (stack.func_190926_b() || this.materialCost[index] > stack.func_190916_E()) {
            return false;
        }
        if (this.enchantIds[index] > -1) {
            for (ItemStack dust : this.listDust) {
                if (!OreDictionary.itemMatches((ItemStack)dust, (ItemStack)stack, (boolean)false)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public List<EnchantmentData> getEnchantments(int index, int level) {
        return this.getEnchantments(this.tableInventory.func_70301_a(0), index, level);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!this.world.field_72995_K) {
            for (int i = 0; i < this.tableInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.tableInventory.func_70304_b(i);
                if (itemstack.func_190926_b()) continue;
                player.func_71019_a(itemstack, false);
            }
        }
    }

    public boolean func_75145_c(EntityPlayer player) {
        return this.world.func_180495_p(this.pos).func_177230_c() == Values.blockEnderTable && player.func_70092_e((double)this.pos.func_177958_n() + 0.5, (double)this.pos.func_177956_o() + 0.5, (double)this.pos.func_177952_p() + 0.5) <= 64.0;
    }

    @Nonnull
    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack rStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack sStack = slot.func_75211_c();
            rStack = sStack.func_77946_l();
            boolean nullify = false;
            if (index == 0 || index == 1) {
                if (!this.func_75135_a(sStack, 2, 38, true)) {
                    return ItemStack.field_190927_a;
                }
            } else if (!((Slot)this.field_75151_b.get(0)).func_75216_d()) {
                if (sStack.func_190916_E() == 1) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(sStack.func_77946_l());
                    sStack.func_190920_e(0);
                } else if (sStack.func_190916_E() >= 1) {
                    ((Slot)this.field_75151_b.get(0)).func_75215_d(sStack.func_77979_a(1));
                    nullify = true;
                }
            } else if (!((Slot)this.field_75151_b.get(1)).func_75216_d() && sStack.func_77973_b() == Items.field_151065_br && ((Slot)this.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_75151_b.get(0)).func_75211_c().func_77956_u()) {
                if (sStack.func_190916_E() == 1) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(sStack.func_77946_l());
                    sStack.func_190920_e(0);
                } else if (sStack.func_190916_E() >= 1) {
                    ((Slot)this.field_75151_b.get(1)).func_75215_d(sStack.func_77979_a(1));
                    nullify = true;
                }
            } else if (!this.func_75135_a(sStack, 1, 2, true)) {
                return ItemStack.field_190927_a;
            }
            if (sStack.func_190916_E() == 0) {
                slot.func_75215_d(ItemStack.field_190927_a);
            }
            slot.func_75218_e();
            if (nullify || sStack.func_190916_E() == rStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, sStack);
        }
        return rStack;
    }

    private class SlotSingle
    extends Slot {
        public SlotSingle(IInventory inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public int func_75219_a() {
            return 1;
        }
    }

    private class InventoryEnderTable
    extends InventoryBasic {
        final ContainerEnderTable container;

        InventoryEnderTable(ContainerEnderTable container) {
            super("Enchant", true, 2);
            this.container = container;
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
            this.container.func_75130_a((IInventory)this);
        }
    }

    private static enum TriState {
        CLEAR,
        KEEP,
        SET;

    }
}

