/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.Validate;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.common.entity.EntityCloudPainting;
import shetiphian.terraqueous.common.entity.EntityEarthPainting;
import shetiphian.terraqueous.common.misc.EnumArtLayout;

public abstract class EntityPaintingBase
extends EntityHanging {
    public EnumArtLayout art;
    private List<EnumArtLayout> placeableArt;
    private int placeableIndex;
    private short changePause;
    SoundEvent sound;
    private static DataParameter dataWatcherArt = EntityDataManager.func_187226_a(EntityPaintingBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static DataParameter dataWatcherFacing = EntityDataManager.func_187226_a(EntityPaintingBase.class, (DataSerializer)DataSerializers.field_187192_b);
    private static DataParameter dataWatcherPos = EntityDataManager.func_187226_a(EntityPaintingBase.class, (DataSerializer)DataSerializers.field_187200_j);

    public EntityPaintingBase(World world) {
        super(world);
    }

    public EntityPaintingBase(World world, BlockPos pos, EnumFacing facing) {
        super(world, pos);
        ArrayList<EnumArtLayout> list = new ArrayList<EnumArtLayout>();
        EnumArtLayout[] enumArtLayoutArray = EnumArtLayout.values();
        int n = enumArtLayoutArray.length;
        for (int i = 0; i < n; ++i) {
            EnumArtLayout artItem;
            this.art = artItem = enumArtLayoutArray[i];
            this.func_174859_a(facing);
            if (!this.func_70518_d()) continue;
            list.add(artItem);
        }
        this.placeableArt = list;
        if (!list.isEmpty()) {
            int artIndex = this.field_70146_Z.nextInt(list.size());
            this.art = list.get(artIndex);
            this.placeableIndex = artIndex;
        }
        this.func_174859_a(facing);
        this.field_70180_af.func_187227_b(dataWatcherArt, (Object)this.art.index);
        this.field_70180_af.func_187227_b(dataWatcherFacing, (Object)this.field_174860_b.func_176745_a());
        this.field_70180_af.func_187227_b(dataWatcherPos, (Object)this.field_174861_a);
    }

    public void func_70014_b(NBTTagCompound nbtTag) {
        nbtTag.func_74778_a("Motive", this.art.title);
        super.func_70014_b(nbtTag);
        if (this.placeableArt != null) {
            int[] artList = new int[this.placeableArt.size()];
            for (int scan = 0; scan < this.placeableArt.size(); ++scan) {
                EnumArtLayout painting = this.placeableArt.get(scan);
                artList[scan] = painting.index;
            }
            nbtTag.func_74783_a("placeableArt", artList);
            nbtTag.func_74768_a("placeableIndex", this.placeableIndex);
        }
    }

    public void func_70037_a(NBTTagCompound nbtTag) {
        String name = nbtTag.func_74779_i("Motive");
        for (EnumArtLayout artItem : EnumArtLayout.values()) {
            if (!artItem.title.equals(name)) continue;
            this.art = artItem;
        }
        if (this.art == null) {
            this.art = EnumArtLayout.OneOne_1;
        }
        super.func_70037_a(nbtTag);
        this.placeableIndex = nbtTag.func_74762_e("placeableIndex");
        int[] artList = nbtTag.func_74759_k("placeableArt");
        ArrayList<EnumArtLayout> arrayList = new ArrayList<EnumArtLayout>();
        for (int element : artList) {
            EnumArtLayout painting = EnumArtLayout.values()[element];
            arrayList.add(painting);
        }
        this.placeableArt = arrayList;
        this.field_70180_af.func_187227_b(dataWatcherArt, (Object)this.art.index);
        this.field_70180_af.func_187227_b(dataWatcherFacing, (Object)this.field_174860_b.func_176745_a());
        this.field_70180_af.func_187227_b(dataWatcherPos, (Object)this.field_174861_a);
    }

    public int func_82329_d() {
        return this.art.sizeX;
    }

    public int func_82330_g() {
        return this.art.sizeY;
    }

    public void func_110128_b(Entity entity) {
        if (this.func_130014_f_().func_82736_K().func_82766_b("doEntityDrops")) {
            if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
                return;
            }
            this.dropItemStack();
        }
    }

    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187694_dK, 1.0f, 1.0f);
    }

    public abstract void dropItemStack();

    public abstract ResourceLocation getEntityTexture();

    public void func_70012_b(double x, double y, double z, float yaw, float pitch) {
        this.func_70107_b(x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        BlockPos blockpos = this.field_174861_a.func_177963_a(x - this.field_70165_t, y - this.field_70163_u, z - this.field_70161_v);
        this.func_70107_b(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
    }

    public boolean func_70518_d() {
        if (!(this instanceof EntityCloudPainting) && !(this instanceof EntityEarthPainting)) {
            return false;
        }
        if (!this.func_130014_f_().func_184144_a((Entity)this, this.func_174813_aQ()).isEmpty()) {
            return false;
        }
        int sizeWidth = Math.max(1, this.func_82329_d() / 16);
        int sizeHeight = Math.max(1, this.func_82330_g() / 16);
        BlockPos blockpos = this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d());
        EnumFacing enumfacing = this.field_174860_b.func_176735_f();
        for (int scanW = 0; scanW < sizeWidth; ++scanW) {
            for (int scanH = 0; scanH < sizeHeight; ++scanH) {
                BlockPos sPos = blockpos.func_177967_a(enumfacing, scanW).func_177981_b(scanH);
                IBlockState sState = this.func_130014_f_().func_180495_p(sPos);
                Block sBlock = sState.func_177230_c();
                Boolean isCloud = CloudAPI.isCloud(sState, (IBlockAccess)this.func_130014_f_(), sPos);
                Boolean isAir = sBlock.isAir(sState, (IBlockAccess)this.func_130014_f_(), sPos);
                if (!isAir.booleanValue() && (isCloud.booleanValue() || !(this instanceof EntityCloudPainting)) && (!isCloud.booleanValue() || !(this instanceof EntityEarthPainting))) continue;
                return false;
            }
        }
        for (Entity entity : this.func_130014_f_().func_72839_b((Entity)this, this.func_174813_aQ())) {
            if (!(entity instanceof EntityHanging)) continue;
            return false;
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(dataWatcherArt, (Object)0);
        this.field_70180_af.func_187214_a(dataWatcherFacing, (Object)0);
        this.field_70180_af.func_187214_a(dataWatcherPos, (Object)new BlockPos(0, 0, 0));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.func_130014_f_().field_72995_K) {
            try {
                if (this.art == null || this.art.index != (Integer)this.field_70180_af.func_187225_a(dataWatcherArt)) {
                    for (EnumArtLayout enumArt : EnumArtLayout.values()) {
                        if (enumArt.index != (Integer)this.field_70180_af.func_187225_a(dataWatcherArt)) continue;
                        this.art = enumArt;
                        break;
                    }
                    this.field_174861_a = (BlockPos)this.field_70180_af.func_187225_a(dataWatcherPos);
                    this.func_174859_a(EnumFacing.field_82609_l[(Integer)this.field_70180_af.func_187225_a(dataWatcherFacing)]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.changePause > 0) {
            this.changePause = (short)(this.changePause - 1);
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (!this.field_70128_L && !this.func_130014_f_().field_72995_K) {
            if (Values.itemMain != null && damageSource.func_76346_g() instanceof EntityPlayer) {
                ItemStack item;
                EntityPlayer entityPlayer = (EntityPlayer)damageSource.func_76346_g();
                if (!entityPlayer.field_71071_by.func_70448_g().func_190926_b() && (item = entityPlayer.field_71071_by.func_70448_g()).func_77973_b() == Values.itemMain && item.func_77952_i() == 0) {
                    this.changePainting(entityPlayer.func_70093_af());
                    return false;
                }
                if (this.sound != null) {
                    this.func_130014_f_().func_184133_a(null, this.field_174861_a, this.sound, SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
                this.func_70106_y();
                this.func_70018_K();
                if (entityPlayer.field_71075_bZ.field_75098_d) {
                    return true;
                }
                this.dropItemStack();
            } else {
                this.func_70106_y();
                this.func_70018_K();
            }
        }
        return true;
    }

    private void changePainting(boolean reverse) {
        if (this.placeableArt == null) {
            return;
        }
        if (this.changePause > 0) {
            return;
        }
        this.changePause = (short)4;
        if (reverse) {
            --this.placeableIndex;
            if (this.placeableIndex < 0) {
                this.placeableIndex = this.placeableArt.size() - 1;
            }
        } else {
            ++this.placeableIndex;
            if (this.placeableIndex >= this.placeableArt.size()) {
                this.placeableIndex = 0;
            }
        }
        this.art = this.placeableArt.get(this.placeableIndex);
        this.func_174859_a(this.field_174860_b);
        this.field_70180_af.func_187227_b(dataWatcherArt, (Object)this.art.index);
        this.field_70180_af.func_187227_b(dataWatcherFacing, (Object)this.field_174860_b.func_176745_a());
        this.field_70180_af.func_187227_b(dataWatcherPos, (Object)this.field_174861_a);
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        BlockPos blockpos = this.field_174861_a;
        this.field_174861_a = new BlockPos(x, y, z);
        if (!this.field_174861_a.equals((Object)blockpos)) {
            this.func_174856_o();
            this.field_70160_al = true;
        }
    }

    protected void func_174859_a(EnumFacing facingDirectionIn) {
        Validate.notNull((Object)facingDirectionIn);
        Validate.isTrue((boolean)facingDirectionIn.func_176740_k().func_176722_c());
        this.field_174860_b = facingDirectionIn;
        this.field_70126_B = this.field_70177_z = (float)(this.field_174860_b.func_176736_b() * 90);
        this.func_174856_o();
    }

    protected void func_174856_o() {
        if (this.field_174860_b != null) {
            double pX = (double)this.field_174861_a.func_177958_n() + 0.5;
            double pY = (double)this.field_174861_a.func_177956_o() + 0.5;
            double pZ = (double)this.field_174861_a.func_177952_p() + 0.5;
            double widthOffset = this.getPixelOffset(this.func_82329_d());
            double heightOffset = this.getPixelOffset(this.func_82330_g());
            pX -= (double)this.field_174860_b.func_82601_c() * 0.46875;
            pZ -= (double)this.field_174860_b.func_82599_e() * 0.46875;
            EnumFacing enumfacing = this.field_174860_b.func_176735_f();
            this.field_70165_t = pX += widthOffset * (double)enumfacing.func_82601_c();
            this.field_70163_u = pY += heightOffset;
            this.field_70161_v = pZ += widthOffset * (double)enumfacing.func_82599_e();
            double hX = this.func_82329_d();
            double hY = this.func_82330_g();
            double hZ = this.func_82329_d();
            if (this.field_174860_b.func_176740_k() == EnumFacing.Axis.Z) {
                hZ = 1.0;
            } else {
                hX = 1.0;
            }
            this.func_174826_a(new AxisAlignedBB(pX - (hX /= 32.0), pY - (hY /= 32.0), pZ - (hZ /= 32.0), pX + hX, pY + hY, pZ + hZ));
        }
    }

    private double getPixelOffset(int pixels) {
        return (double)(pixels / 16 - 1) * 0.5;
    }

    public void func_70091_d(MoverType type, double xpos, double ypos, double zpos) {
    }
}

