/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IBonemealable;
import shetiphian.terraqueous.Configuration;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.plant.PlantAPI;
import shetiphian.terraqueous.common.block.BlockFlowerPot;
import shetiphian.terraqueous.common.misc.BlueFlowerHandler;
import shetiphian.terraqueous.common.misc.PlantFunctions;

public class BlockFlowers
extends BlockBush
implements IBonemealable,
IShearable {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final AxisAlignedBB AABB_FLOWER = new AxisAlignedBB(0.3, 0.0, 0.3, 0.7, 0.6, 0.7);

    public BlockFlowers() {
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149711_c(0.05f);
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getEnumType(state).getValue();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB_FLOWER;
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        return true;
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150349_c || state.func_177230_c() == Blocks.field_150346_d || state.func_177230_c() == Blocks.field_150457_bL;
    }

    public boolean canGrow(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return this == Values.blockFlowerSingle || this == Values.blockFlowerCluster && Function.getBlockDown((IBlockAccess)world, (BlockPos)pos) != Values.blockFlowerPot;
    }

    public boolean canUseBonemeal(World world, Random random, BlockPos pos, IBlockState state) {
        if (this == Values.blockFlowerSingle) {
            return true;
        }
        if (this == Values.blockFlowerCluster && Function.getBlockDown((IBlockAccess)world, (BlockPos)pos) != Values.blockFlowerPot) {
            return (double)random.nextFloat() < 0.45;
        }
        return false;
    }

    public void grow(World world, Random rand, BlockPos pos, IBlockState state) {
        if (this == Values.blockFlowerSingle && Values.blockFlowerCluster != null) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Values.blockFlowerCluster.func_176203_a(this.func_176201_c(state)), (boolean)true);
        } else if (Values.blockFlowerSingle != null && Function.getBlockDown((IBlockAccess)world, (BlockPos)pos) != Values.blockFlowerPot) {
            this.spreadFlower(world, rand, pos, state);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K || !world.func_72935_r() || Values.blockFlowerSingle == null || Values.blockFlowerCluster == null) {
            return;
        }
        this.func_176475_e(world, pos, state);
        if (this == Values.blockFlowerSingle && PlantFunctions.canGrow(world, pos, PlantAPI.PlantType.FLOWER)) {
            this.grow(world, rand, pos, state);
        } else if (this == Values.blockFlowerCluster && world.func_180495_p(pos.func_177977_b()).func_177230_c() != Values.blockFlowerPot && PlantFunctions.canSpread(world, pos, PlantAPI.PlantType.FLOWER)) {
            this.grow(world, rand, pos, state);
        }
    }

    private void spreadFlower(World world, Random random, BlockPos pos, IBlockState state) {
        byte maxAttempts = PlantFunctions.getMaxPlacementAttempts((IBlockAccess)world, pos, PlantAPI.PlantType.FLOWER);
        byte[] spreadRadius = PlantFunctions.getSpreadRadius((IBlockAccess)world, pos, PlantAPI.PlantType.FLOWER);
        for (byte attempt = 0; attempt < maxAttempts; attempt = (byte)(attempt + 1)) {
            BlockPos sPos = pos.func_177982_a(this.getOffset(spreadRadius[0], random), this.getOffset(spreadRadius[1], random), this.getOffset(spreadRadius[0], random));
            if (world.func_175623_d(sPos) && this.func_180671_f(world, sPos, state) && this.canSpreadHere(world, sPos, state)) {
                Function.setBlock((World)world, (BlockPos)sPos, (IBlockState)Values.blockFlowerSingle.func_176203_a(this.func_176201_c(state)), (boolean)true);
                return;
            }
            pos = sPos;
        }
    }

    private int getOffset(int spreadRadius, Random random) {
        return random.nextInt(spreadRadius) - random.nextInt(spreadRadius);
    }

    private boolean canSpreadHere(World world, BlockPos pos, IBlockState state) {
        if (Values.blockFlowerPot != null && world.func_180495_p(pos.func_177977_b()).func_177230_c() == Values.blockFlowerPot) {
            return false;
        }
        int touching = 0;
        int total = 0;
        int air = 0;
        for (int sX = -2; sX <= 2; sX = (int)((byte)(sX + 1))) {
            for (int sZ = -2; sZ <= 2; sZ = (int)((byte)(sZ + 1))) {
                if (sX == 0 && sZ == 0) continue;
                BlockPos sPos = pos.func_177982_a(sX, 0, sZ);
                if (world.func_175623_d(sPos)) {
                    air = (byte)(air + 1);
                    continue;
                }
                IBlockState sState = world.func_180495_p(sPos);
                if (sState.func_177230_c() != Values.blockFlowerSingle && sState.func_177230_c() != Values.blockFlowerCluster || this.getEnumType(sState) != this.getEnumType(state)) continue;
                total = (byte)(total + 1);
                if (sZ == 0 && (sX == -1 || sX == 1)) {
                    touching = (byte)(touching + 1);
                }
                if (sX != 0 || sZ != -1 && sZ != 1) continue;
                touching = (byte)(touching + 1);
            }
        }
        return touching < 2 && total < 2 && air > 12;
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Values.blockFlowerPot) {
            return true;
        }
        Chunk chunk = world.func_175726_f(pos);
        Biome biome = chunk.func_177411_a(pos, world.func_72959_q());
        if (BiomeDictionary.hasAnyType((Biome)biome) && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SNOWY)) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150458_ak && super.func_180671_f(world, pos, state);
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 100;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public int func_149745_a(Random random) {
        return this == Values.blockFlowerSingle ? 1 : random.nextInt(3) + 1;
    }

    private Item getItem() {
        return Item.func_150898_a((Block)(Values.blockFlowerSingle != null ? Values.blockFlowerSingle : Blocks.field_150350_a));
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        return this.getItem((IBlockAccess)world, pos, state, world.field_73012_v);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.getItem();
    }

    @Nonnull
    public ItemStack getItem(IBlockAccess world, BlockPos pos, IBlockState state, Random rand) {
        if (Values.blockFlowerSingle != null && (!Configuration.TWEAKS.PLANTS.flowersRequireShears || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFlowerPot)) {
            return new ItemStack(this.getItem(), this.func_149745_a(rand), this.func_180651_a(state));
        }
        return ItemStack.field_190927_a;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ItemStack stack = this.getItem(world, pos, state, rand);
        if (!stack.func_190926_b()) {
            drops.add((Object)stack);
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        Random rand = world instanceof World ? ((World)world).field_73012_v : RANDOM;
        ItemStack stack = new ItemStack(this.getItem(), this.func_149745_a(rand), this.func_180651_a(world.func_180495_p(pos)));
        if (!stack.func_190926_b()) {
            ret.add(stack);
        }
        return ret;
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (this.getEnumType(state) == EnumType.BLUE && !world.field_72995_K && entity instanceof EntityPlayer) {
            BlueFlowerHandler.INSTANCE.blueAdd((EntityPlayer)entity);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        if (player != null && player.field_71075_bZ.field_75098_d) {
            return new ItemStack(Item.func_150898_a((Block)this), 1, this.func_180651_a(state));
        }
        return new ItemStack(this.func_180660_a(state, world.field_73012_v, 0), 1, this.func_180651_a(state));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.BLACK;
            Terraqueous.errorPropertyNotFound("BlockFlowers.VARIANT", "BLACK", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        BLACK(0),
        RED(1),
        GREEN(2),
        BROWN(3),
        BLUE(4),
        PURPLE(5),
        CYAN(6),
        SILVER(7),
        GRAY(8),
        PINK(9),
        LIME(10),
        YELLOW(11),
        LIGHTBLUE(12),
        MAGENTA(13),
        ORANGE(14),
        WHITE(15);

        private static final EnumType[] array;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public IBlockState state(boolean cluster) {
            if (cluster && Values.blockFlowerCluster != null) {
                return Values.blockFlowerCluster.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            if (!cluster && Values.blockFlowerSingle != null) {
                return Values.blockFlowerSingle.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            return array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[16];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

