/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import com.google.common.base.Strings;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.IParticleOverride;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.core.common.ParticleHelper;
import shetiphian.core.common.rgb16.IRGB16_Block;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.common.tileentity.TileEntityFlowerPot;

public class BlockFlowerPot
extends Block
implements IColored,
IParticleOverride,
IRGB16_Block {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    public static final EnumPlantType plantLava = EnumPlantType.getPlantType((String)"Lava");
    public static final EnumPlantType plantEnd = EnumPlantType.getPlantType((String)"End");
    private static final AxisAlignedBB AABB_FLOWERPOT = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.375, 0.75);
    private static final AxisAlignedBB AABB_PLANTERPOT = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 1.0, 0.9375);

    public BlockFlowerPot() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149675_a(true);
        this.func_149711_c(0.2f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return BlockFlowerPot.getEnumType(state).getValue();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityFlowerPot();
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing facing) {
        return BlockFaceShape.BOWL;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public float func_176195_g(IBlockState state, World world, BlockPos pos) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        return type == EnumType.FLOWERPOT ? 0.2f : 2.0f;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        if (type != EnumType.FLOWERPOT && !world.func_175623_d(pos.func_177984_a())) {
            IBlockState sState = world.func_180495_p(pos.func_177984_a());
            sState.func_177230_c().func_180650_b(world, pos.func_177984_a(), sState, random);
        }
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return !world.func_175623_d(pos = pos.func_177984_a()) && state.func_177230_c().isLeaves(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        return type != null && type == EnumType.FLOWERPOT ? AABB_FLOWERPOT : AABB_PLANTERPOT;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plant) {
        if (direction == EnumFacing.UP) {
            EnumPlantType plantType = plant.getPlantType(world, pos.func_177972_a(direction));
            EnumType type = BlockFlowerPot.getEnumType(state);
            switch (type) {
                case PLANTER_DIRT: {
                    return plantType == EnumPlantType.Plains || plantType == EnumPlantType.Beach || plantType == EnumPlantType.Cave;
                }
                case PLANTER_FARM: {
                    return plantType == EnumPlantType.Crop || plantType == EnumPlantType.Cave;
                }
                case PLANTER_SAND: {
                    return plantType == EnumPlantType.Desert || plantType == EnumPlantType.Beach || plantType == EnumPlantType.Cave;
                }
                case PLANTER_SOULSAND: {
                    return plantType == EnumPlantType.Nether;
                }
                case PLANTER_WATER: {
                    return plantType == EnumPlantType.Water;
                }
                case PLANTER_LAVA: {
                    return plantType == plantLava;
                }
                case PLANTER_ENDSTONE: {
                    return plantType == plantEnd;
                }
            }
            return false;
        }
        return false;
    }

    public boolean isFertile(World world, BlockPos pos) {
        EnumType type = BlockFlowerPot.getEnumType(world.func_180495_p(pos));
        return type == EnumType.PLANTER_FARM;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        world.func_175698_g(pos);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        ItemStack stack = new ItemStack((Block)this, 1, this.func_180651_a(state));
        TileEntityFlowerPot tile = BlockFlowerPot.getTile(world, pos);
        if (tile != null) {
            if (stack.func_77973_b() instanceof IRGB16_Item) {
                ((IRGB16_Item)stack.func_77973_b()).setRGB16(stack, tile.getRGB16(null).getIndex());
            }
            if (type == EnumType.FLOWERPOT && tile.getPlantStack() != null) {
                drops.add((Object)tile.getPlantStack());
            } else if (type.getSoil() != null && type.getSoil() != Blocks.field_150353_l && type.getSoil() != Blocks.field_150355_j) {
                drops.add((Object)type.getItem());
            }
        }
        drops.add((Object)stack);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        TileEntityFlowerPot tile = BlockFlowerPot.getTile((IBlockAccess)world, pos);
        if (tile == null || player == null) {
            return false;
        }
        ItemStack heldStack = player.func_184586_b(hand);
        if (heldStack.func_190926_b()) {
            if (type == EnumType.FLOWERPOT && tile.getPlantStack() != null && player.func_70093_af()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)tile.getPlantStack());
                }
                tile.setPlantStack(null);
                Function.syncTile((TileEntity)tile);
                return true;
            }
            if (type.getItem() != null && type != EnumType.PLANTER_LAVA && type != EnumType.PLANTER_WATER) {
                if (!player.field_71075_bZ.field_75098_d) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)type.getItem());
                }
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.PLANTER_EMPTY.state(), (boolean)true);
                world.func_175685_c(pos.func_177984_a(), (Block)this, true);
                return true;
            }
            return false;
        }
        Item heldItem = heldStack.func_77973_b();
        if (heldItem == Items.field_151133_ar && (type == EnumType.PLANTER_LAVA || type == EnumType.PLANTER_WATER)) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
                Function.giveItem((EntityPlayer)player, (ItemStack)type.getItem());
            }
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.PLANTER_EMPTY.state(), (boolean)true);
            world.func_175685_c(pos.func_177984_a(), (Block)this, true);
            return true;
        }
        if ((heldItem == Items.field_151129_at || heldItem == Items.field_151131_as) && type == EnumType.PLANTER_EMPTY) {
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
                Function.giveItem((EntityPlayer)player, (ItemStack)new ItemStack(Items.field_151133_ar));
            }
            if (heldItem == Items.field_151129_at) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.PLANTER_LAVA.state(), (boolean)true);
            } else {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)EnumType.PLANTER_WATER.state(), (boolean)true);
            }
            return true;
        }
        ItemStack giveStack = null;
        if (heldItem instanceof ItemBlock) {
            Block block = Block.func_149634_a((Item)heldItem);
            if (type == EnumType.FLOWERPOT) {
                if (tile.getPlantStack() != null) {
                    giveStack = tile.getPlantStack();
                }
                tile.setPlantFacing(player.func_174811_aO().func_176734_d());
                tile.setPlantStack(heldStack.func_77946_l().func_77979_a(1));
                Function.syncTile((TileEntity)tile);
            } else if (type != EnumType.PLANTER_LAVA && type != EnumType.PLANTER_WATER) {
                if (block != Blocks.field_150354_m && block != Blocks.field_150425_aM && block != Blocks.field_150349_c && block != Blocks.field_150346_d && block != Blocks.field_150458_ak && block != Blocks.field_150377_bs) {
                    return false;
                }
                if (type.getSoil() != null) {
                    giveStack = type.getItem();
                }
                EnumType newType = EnumType.forBlock(block);
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)newType.state(), (boolean)true);
                world.func_175685_c(pos.func_177984_a(), (Block)this, true);
            }
            world.func_184133_a(player, pos, block.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            if (!player.field_71075_bZ.field_75098_d) {
                heldStack.func_190918_g(1);
                if (giveStack != null) {
                    Function.giveItem((EntityPlayer)player, (ItemStack)giveStack);
                }
            }
            return true;
        }
        return false;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        if (type == EnumType.PLANTER_WATER) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Blocks.field_150355_j.func_176223_P(), (boolean)true);
        }
        if (type == EnumType.PLANTER_LAVA) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)Blocks.field_150353_l.func_176223_P(), (boolean)true);
        }
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        return type == EnumType.FLOWERPOT ? 0 : 1;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        return type == EnumType.PLANTER_LAVA ? Blocks.field_150353_l.func_149750_m(Blocks.field_150353_l.func_176223_P()) : 0;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityFlowerPot tile = BlockFlowerPot.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            EnumDyeColor current = tile.getRGB16(null).getDyeColor();
            tile.setRGB16(RGB16Helper.getIndexFor((EnumDyeColor)color), null);
            return current != color;
        }
        return false;
    }

    public boolean recolorBlock(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, Vec3d hitVec, String dyeName) {
        TileEntityFlowerPot tile;
        if (!Strings.isNullOrEmpty((String)dyeName) && (tile = BlockFlowerPot.getTile((IBlockAccess)world, pos)) != null) {
            if (!world.field_72995_K) {
                tile.getRGB16(player).recolor(player, dyeName);
                Function.syncTile((TileEntity)tile);
            }
            player.func_184609_a(hand);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityFlowerPot tile;
        if (data.world != null && data.pos != null && (tile = BlockFlowerPot.getTile(data.world, data.pos)) != null) {
            return tile.getRGB16(null).getColor();
        }
        return 0xFFFFFF;
    }

    public boolean addLandingEffects(IBlockState state, WorldServer world, BlockPos pos, IBlockState state2, EntityLivingBase entity, int numberOfParticles) {
        return ParticleHelper.addLandingEffects((WorldServer)world, (BlockPos)pos, (EntityLivingBase)entity, (int)numberOfParticles, (int)this.getParticleStateId(state, (World)world, pos, (Entity)entity));
    }

    public boolean overrideRunningEffects(World world, BlockPos pos, IBlockState state, Entity entity) {
        return ParticleHelper.addRunningEffects((World)world, (BlockPos)pos, (Entity)entity, (int)this.getParticleStateId(state, world, pos, entity));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager effectRenderer) {
        EnumType type;
        BlockPos pos = target.func_178782_a();
        if (target.field_178784_b == EnumFacing.UP && (type = BlockFlowerPot.getEnumType(state)).getSoil() != null) {
            return ParticleHelper.addHitEffects((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b, (ParticleManager)effectRenderer, (int)this.getParticleStateId(type.getSoil().func_176223_P(), world, pos, null));
        }
        return ParticleHelper.addHitEffects((World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b, (ParticleManager)effectRenderer, (int)Block.func_176210_f((IBlockState)ParticleHelper.getStateForParticle((IBlockState)state, (World)world, (BlockPos)pos)));
    }

    private int getParticleStateId(IBlockState state, World world, BlockPos pos, Entity entity) {
        EnumType type;
        if (state.func_177230_c() == this && (type = BlockFlowerPot.getEnumType(state)).getSoil() != null) {
            return Block.func_176210_f((IBlockState)type.getSoil().func_176223_P());
        }
        int stateId = entity != null ? Block.func_176210_f((IBlockState)ParticleHelper.getStateForParticle((Entity)entity, (BlockPos)pos, (IBlockState)state, BlockFlowerPot.class)) : Block.func_176210_f((IBlockState)ParticleHelper.getStateForParticle((IBlockState)state, (World)world, (BlockPos)pos));
        return stateId;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        EnumType type = BlockFlowerPot.getEnumType(state);
        TileEntityFlowerPot tile = BlockFlowerPot.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            if (player != null && player.func_70093_af()) {
                if (type == EnumType.FLOWERPOT && tile.getPlantStack() != null) {
                    return tile.getPlantStack();
                }
                if (type.getItem() != null) {
                    return type.getItem();
                }
            }
            ItemStack stack = new ItemStack((Block)this, 1, type == EnumType.FLOWERPOT ? 0 : 1);
            RGB16StackHelper.setRGB16((ItemStack)stack, (RGB16)tile.getRGB16(null));
            return stack;
        }
        return null;
    }

    public static TileEntityFlowerPot getTile(IBlockAccess world, BlockPos pos) {
        try {
            return (TileEntityFlowerPot)world.func_175625_s(pos);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.FLOWERPOT;
            Terraqueous.errorPropertyNotFound("BlockFlowerPot.VARIANT", "FLOWERPOT", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        FLOWERPOT(0, null),
        PLANTER_EMPTY(1, null),
        PLANTER_DIRT(2, Blocks.field_150346_d),
        PLANTER_FARM(3, Blocks.field_150458_ak),
        PLANTER_SAND(4, (Block)Blocks.field_150354_m),
        PLANTER_SOULSAND(5, Blocks.field_150425_aM),
        PLANTER_WATER(6, (Block)Blocks.field_150355_j),
        PLANTER_LAVA(7, (Block)Blocks.field_150353_l),
        PLANTER_ENDSTONE(8, Blocks.field_150377_bs);

        private static final EnumType[] array;
        private final byte value;
        private final Block soil;

        private EnumType(int value, Block soil) {
            this.value = (byte)value;
            this.soil = soil;
        }

        public byte getValue() {
            return this.value;
        }

        public Block getSoil() {
            return this.soil;
        }

        public ItemStack getItem() {
            if (this.soil == null) {
                return null;
            }
            if (this == PLANTER_WATER || this == PLANTER_LAVA) {
                return new ItemStack(this == PLANTER_LAVA ? Items.field_151129_at : Items.field_151131_as);
            }
            if (this.soil == Blocks.field_150458_ak) {
                return new ItemStack(Blocks.field_150346_d);
            }
            return new ItemStack(this.soil);
        }

        public IBlockState state() {
            if (Values.blockFlowerPot != null) {
                return Values.blockFlowerPot.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)this));
            }
            return null;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? FLOWERPOT : type;
        }

        public static EnumType forBlock(Block block) {
            if (block != null) {
                for (EnumType type : EnumType.values()) {
                    if (type.getSoil() != block) continue;
                    return type;
                }
            }
            return PLANTER_DIRT;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[9];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType value;
                EnumType.array[value.getValue()] = value = enumTypeArray[i];
            }
        }
    }
}

