/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.terraqueous.common.block;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import shetiphian.core.common.Function;
import shetiphian.terraqueous.Terraqueous;
import shetiphian.terraqueous.Values;
import shetiphian.terraqueous.api.cloud.BlockCloudBase;
import shetiphian.terraqueous.api.cloud.CloudAPI;
import shetiphian.terraqueous.api.cloud.CloudPresets;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyArch;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyBase;
import shetiphian.terraqueous.common.tileentity.TileEntityTypeFancyEdge;

public class BlockCloudFancy
extends BlockCloudBase {
    public static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);

    public BlockCloudFancy() {
        super(CloudAPI.materialCloud);
        this.func_149647_a((CreativeTabs)Values.tabTerraqueous);
        this.func_149672_a(CloudAPI.soundTypeCloud);
        this.func_149711_c(0.7f);
        this.func_149752_b(0.5f);
        this.setHarvestLevel("shovel", 0);
        this.field_149783_u = true;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)EnumType.byValue(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return this.getEnumType(state).getValue();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeFancyBase tile = this.getTile(world, pos);
        return tile != null ? tile.getActualState(state) : state;
    }

    public boolean hasTileEntity(IBlockState state) {
        EnumType type = this.getEnumType(state);
        return type.getValue() == 4 || type.getValue() == 5;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this.getEnumType(state).getValue()) {
            case 4: {
                return new TileEntityTypeFancyArch();
            }
            case 5: {
                return new TileEntityTypeFancyEdge();
            }
        }
        return null;
    }

    private TileEntityTypeFancyBase getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTypeFancyBase ? (TileEntityTypeFancyBase)tile : null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityTypeFancyBase tile = this.getTile(world, pos);
        if (tile != null) {
            float[] bounds = tile.getBoxBounds();
            return new AxisAlignedBB((double)bounds[0], (double)bounds[1], (double)bounds[2], (double)bounds[3], (double)bounds[4], (double)bounds[5]);
        }
        return Block.field_185505_j;
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        if (CloudPresets.shouldAddCollisionBoxToList(state, world, pos, entity)) {
            TileEntityTypeFancyBase tile = this.getTile((IBlockAccess)world, pos);
            if (tile != null) {
                float[] boxes = tile.getCollisionBoxes();
                if (boxes != null) {
                    for (int set = 0; set < boxes.length / 6; set = (int)((byte)(set + 1))) {
                        AxisAlignedBB box = new AxisAlignedBB((double)boxes[6 * set], (double)boxes[6 * set + 1], (double)boxes[6 * set + 2], (double)boxes[6 * set + 3], (double)boxes[6 * set + 4], (double)boxes[6 * set + 5]);
                        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)box);
                    }
                }
                return;
            }
            Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)state.func_185890_d((IBlockAccess)world, pos));
        }
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        RayTraceResult original = super.func_180636_a(state, world, pos, startVec, endVec);
        TileEntityTypeFancyBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null ? tile.collisionRayTrace(state, startVec, endVec, original) : original;
    }

    public RayTraceResult preformRayTrace(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        return super.func_180636_a(state, world, pos, startVec, endVec);
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        TileEntityTypeFancyBase tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            tile.neighborChanged(neighbor);
            return;
        }
        EnumType type = this.getEnumType(state);
        byte metadata = type.getValue();
        if (metadata < 3) {
            boolean[] others = new boolean[2];
            for (int y = 0; y < 2; y = (int)((byte)(y + 1))) {
                IBlockState sState = world.func_180495_p(pos.func_177982_a(0, y == 0 ? -1 : 1, 0));
                Block sBlock = sState.func_177230_c();
                others[y] = sBlock instanceof BlockCloudFancy && sBlock.func_176201_c(sState) < 3;
            }
            if (others[1] == others[0] && metadata != 1) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.COLUMN_MIDDLE)), (boolean)true);
            } else if (!others[1] && others[0] && metadata != 2) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.COLUMN_TOP)), (boolean)true);
            } else if (others[1] && !others[0] && metadata != 0) {
                Function.setBlock((World)world, (BlockPos)pos, (IBlockState)state.func_177226_a(VARIANT, (Comparable)((Object)EnumType.COLUMN_BOTTOM)), (boolean)true);
            }
        }
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityTypeFancyBase tile = this.getTile(world, pos);
        return tile != null && tile.isSideSolid(side);
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = this.getEnumType(state);
        return type.getValue() >= 0 && type.getValue() <= 2 ? (byte)1 : type.getValue();
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntityTypeFancyBase tile = this.getTile((IBlockAccess)world, pos);
        return tile != null && tile.rotateBlock(axis);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 127;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        boolean original = super.func_176225_a(state, world, pos, side);
        TileEntityTypeFancyBase tile = this.getTile(world, pos);
        return tile != null ? tile.renderSide(side, original) : original;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    private EnumType getEnumType(IBlockState state) {
        EnumType type;
        try {
            type = (EnumType)((Object)state.func_177229_b(VARIANT));
        }
        catch (Exception e) {
            type = EnumType.COLUMN_BOTTOM;
            Terraqueous.errorPropertyNotFound("BlockCloudFancy.VARIANT", "COLUMN_BOTTOM", state.toString());
        }
        return type;
    }

    public static enum EnumType implements IStringSerializable
    {
        COLUMN_BOTTOM(0),
        COLUMN_MIDDLE(1),
        COLUMN_TOP(2),
        CAPITAL_BLOCK(3),
        ARCH_NORTH(4),
        ARCH_EAST(4),
        ARCH_SOUTH(4),
        ARCH_WEST(4),
        ARCH_INSIDE_RIGHT_NORTH(4),
        ARCH_INSIDE_RIGHT_EAST(4),
        ARCH_INSIDE_RIGHT_SOUTH(4),
        ARCH_INSIDE_RIGHT_WEST(4),
        ARCH_INSIDE_LEFT_NORTH(4),
        ARCH_INSIDE_LEFT_EAST(4),
        ARCH_INSIDE_LEFT_SOUTH(4),
        ARCH_INSIDE_LEFT_WEST(4),
        ARCH_OUTSIDE_RIGHT_NORTH(4),
        ARCH_OUTSIDE_RIGHT_EAST(4),
        ARCH_OUTSIDE_RIGHT_SOUTH(4),
        ARCH_OUTSIDE_RIGHT_WEST(4),
        ARCH_OUTSIDE_LEFT_NORTH(4),
        ARCH_OUTSIDE_LEFT_EAST(4),
        ARCH_OUTSIDE_LEFT_SOUTH(4),
        ARCH_OUTSIDE_LEFT_WEST(4),
        EDGE_NORTH(5),
        EDGE_EAST(5),
        EDGE_SOUTH(5),
        EDGE_WEST(5),
        EDGE_INSIDE_RIGHT_NORTH(5),
        EDGE_INSIDE_RIGHT_EAST(5),
        EDGE_INSIDE_RIGHT_SOUTH(5),
        EDGE_INSIDE_RIGHT_WEST(5),
        EDGE_INSIDE_LEFT_NORTH(5),
        EDGE_INSIDE_LEFT_EAST(5),
        EDGE_INSIDE_LEFT_SOUTH(5),
        EDGE_INSIDE_LEFT_WEST(5),
        EDGE_OUTSIDE_RIGHT_NORTH(5),
        EDGE_OUTSIDE_RIGHT_EAST(5),
        EDGE_OUTSIDE_RIGHT_SOUTH(5),
        EDGE_OUTSIDE_RIGHT_WEST(5),
        EDGE_OUTSIDE_LEFT_NORTH(5),
        EDGE_OUTSIDE_LEFT_EAST(5),
        EDGE_OUTSIDE_LEFT_SOUTH(5),
        EDGE_OUTSIDE_LEFT_WEST(5);

        private static final EnumType[] array;
        private static final Map<String, EnumType> map;
        private final byte value;

        private EnumType(int value) {
            this.value = (byte)value;
        }

        public byte getValue() {
            return this.value;
        }

        public static EnumType byValue(int value) {
            EnumType type = array[MathHelper.func_76125_a((int)value, (int)0, (int)(array.length - 1))];
            return type == null ? COLUMN_BOTTOM : type;
        }

        public static EnumType byName(String name) {
            return map.containsKey(name = name.toLowerCase().trim()) ? map.get(name) : COLUMN_BOTTOM;
        }

        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }

        static {
            array = new EnumType[6];
            map = new HashMap<String, EnumType>();
            map.clear();
            for (EnumType value : EnumType.values()) {
                if (array[value.getValue()] == null) {
                    EnumType.array[value.getValue()] = value;
                }
                map.put(value.func_176610_l(), value);
            }
        }
    }
}

