/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.client.IHasModel;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.plants2.Plants2;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.PlantConstants;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ItemExcalibur
extends ItemSword
implements ILensEffect,
IManaUsingItem,
IHasModel,
IHasRecipe {
    private static final String TAG_ATTACKER_USERNAME = "attackerUsername";
    private static final String TAG_HOME_ID = "homeID";
    public static Item.ToolMaterial toolMaterial = EnumHelper.addToolMaterial((String)"EXCALIBUR", (int)3, (int)-1, (float)6.2f, (float)6.0f, (int)40);

    public ItemExcalibur() {
        super(toolMaterial);
        this.func_77637_a(PlantConstants.TAB);
        this.func_77655_b("plants2.excalibur");
        this.setRegistryName("excalibur");
        Plants2.INFO.getItemList().add((Object)this);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (entity instanceof EntityPlayer) {
            float check;
            EntityPlayer player = (EntityPlayer)entity;
            PotionEffect haste = player.func_70660_b(MobEffects.field_76422_e);
            float f = haste == null ? 0.16666667f : (check = haste.func_76458_c() == 1 ? 0.5f : 0.4f);
            if (player.func_184614_ca() == stack && player.field_70733_aJ == check && !world.field_72995_K) {
                EntityManaBurst burst = this.getBurst(player, stack, EnumHand.MAIN_HAND);
                world.func_72838_d((Entity)burst);
                world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
            }
        }
    }

    public boolean usesMana(ItemStack stack) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", 10.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", 0.3, 1));
        }
        return multimap;
    }

    public EntityManaBurst getBurst(EntityPlayer player, ItemStack stack, EnumHand hand) {
        EntityManaBurst burst = new EntityManaBurst(player, hand);
        float motionModifier = 7.0f;
        burst.setColor(PlantConfig.excaliburParty ? ItemExcalibur.getRandomColor(Item.field_77697_d) : 0xFFFF20);
        burst.setMana(1);
        burst.setStartingMana(1);
        burst.setMinManaLoss(200);
        burst.setManaLossPerTick(1.0f);
        burst.setGravity(0.0f);
        burst.setMotion(burst.field_70159_w * (double)motionModifier, burst.field_70181_x * (double)motionModifier, burst.field_70179_y * (double)motionModifier);
        ItemStack lens = stack.func_77946_l();
        ItemNBTHelper.setString((ItemStack)lens, (String)TAG_ATTACKER_USERNAME, (String)player.func_174793_f().func_70005_c_());
        burst.setSourceLens(lens);
        return burst;
    }

    public void apply(ItemStack stack, BurstProperties props) {
    }

    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        return dead;
    }

    private static int getRandomColor(Random rand) {
        int r = rand.nextInt(256);
        int g = rand.nextInt(256);
        int b = rand.nextInt(256);
        int value = 0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return value;
    }

    public void updateBurst(IManaBurst iManaBurst, ItemStack stack) {
        Entity home;
        EntityThrowable burst = (EntityThrowable)iManaBurst;
        AxisAlignedBB axis = new AxisAlignedBB(burst.field_70165_t, burst.field_70163_u, burst.field_70161_v, burst.field_70142_S, burst.field_70137_T, burst.field_70136_U).func_72314_b(1.0, 1.0, 1.0);
        if (PlantConfig.superExcaliburParty) {
            iManaBurst.setColor(ItemExcalibur.getRandomColor(Item.field_77697_d));
        }
        String attacker = ItemNBTHelper.getString((ItemStack)iManaBurst.getSourceLens(), (String)TAG_ATTACKER_USERNAME, (String)"");
        int homeID = ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_HOME_ID, (int)-1);
        if (homeID == -1) {
            AxisAlignedBB axis1 = new AxisAlignedBB(burst.field_70165_t, burst.field_70163_u, burst.field_70161_v, burst.field_70142_S, burst.field_70137_T, burst.field_70136_U).func_72314_b(5.0, 5.0, 5.0);
            List entities = burst.field_70170_p.func_72872_a(EntityLivingBase.class, axis1);
            for (EntityLivingBase living : entities) {
                if (living instanceof EntityPlayer || living instanceof EntityDragon || living instanceof EntityWither || !(living instanceof IMob) || living.field_70737_aN != 0) continue;
                homeID = living.func_145782_y();
                ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_HOME_ID, (int)homeID);
                break;
            }
        }
        List entities = burst.field_70170_p.func_72872_a(EntityLivingBase.class, axis);
        if (homeID != -1 && (home = burst.field_70170_p.func_73045_a(homeID)) != null) {
            Vector3 vecEntity = Vector3.fromEntityCenter((Entity)home);
            Vector3 vecThis = Vector3.fromEntityCenter((Entity)burst);
            Vector3 vecMotion = vecEntity.subtract(vecThis);
            Vector3 vecCurrentMotion = new Vector3(burst.field_70159_w, burst.field_70181_x, burst.field_70179_y);
            vecMotion.normalize().multiply(vecCurrentMotion.mag());
            iManaBurst.setMotion(vecMotion.x, vecMotion.y, vecMotion.z);
        }
        for (EntityLivingBase living : entities) {
            if (living instanceof EntityPlayer && (((EntityPlayer)living).func_174793_f().func_70005_c_().equals(attacker) || living.field_70170_p.func_73046_m() != null && living.field_70170_p.func_73046_m().func_71219_W()) || living.field_70737_aN != 0) continue;
            int cost = 1;
            int mana = iManaBurst.getMana();
            if (mana < cost) continue;
            iManaBurst.setMana(mana - cost);
            float damage = 4.0f + toolMaterial.func_78000_c();
            if (iManaBurst.isFake() || burst.field_70170_p.field_72995_K) continue;
            EntityPlayer player = living.field_70170_p.func_72924_a(attacker);
            living.func_70097_a(player == null ? DamageSource.field_76376_m : DamageSource.func_76365_a((EntityPlayer)player), damage);
            burst.func_70106_y();
            break;
        }
    }

    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (this.usesMana(stack)) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)attacker, (int)this.getManaPerDamage());
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World world, IBlockState state, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        if (this.usesMana(stack) && state.func_185887_b(world, pos) != 0.0f) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)entity, (int)this.getManaPerDamage());
        }
        return true;
    }

    public int getManaPerDamage() {
        return 60;
    }

    public boolean func_82789_a(ItemStack stack, ItemStack repairMat) {
        return repairMat.func_77973_b() == ModItems.manaResource && repairMat.func_77952_i() == 0 ? true : super.func_82789_a(stack, repairMat);
    }

    @Nonnull
    public EnumRarity func_77613_e(ItemStack stack) {
        return BotaniaAPI.rarityRelic;
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        Plants2.HELPER.addShapeless((IForgeRegistryEntry)this, new Object[]{ForgeRegistries.ITEMS.getValue(new ResourceLocation("botania", "kingkey"))});
    }
}

