/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.compat;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.potions.IPotion;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.potion.Potion;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import shadows.plants2.util.ColorToPotionUtil;
import shadows.plants2.util.ColorToPotionWeightedMap;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenRegister
@ZenClass(value="mods.plants.BrewingCauldron")
public class CrafttweakerIntegration {
    private static List<Triple<EnumDyeColor, Potion, Integer>> additions = new ArrayList<Triple<EnumDyeColor, Potion, Integer>>();
    private static List<Pair<EnumDyeColor, Potion>> removals = new ArrayList<Pair<EnumDyeColor, Potion>>();
    private static List<EnumDyeColor> clears = new ArrayList<EnumDyeColor>();

    @ZenMethod
    public static void addWeightedPotion(String dyeColor, IPotion potion, int weight) {
        EnumDyeColor color = EnumDyeColor.valueOf((String)dyeColor.toUpperCase(Locale.ENGLISH));
        Validate.notNull((Object)color, (String)"Invalid EnumDyeColor %s!", (Object[])new Object[]{dyeColor});
        Validate.isTrue((potion.getInternal() != null && potion.getInternal() instanceof Potion ? 1 : 0) != 0, (String)"Invalid potion %s!", (Object[])new Object[]{potion});
        Validate.isTrue((weight > 0 ? 1 : 0) != 0, (String)"Invalid weight %s, must be positive!", (long)weight);
        additions.add((Triple<EnumDyeColor, Potion, Integer>)Triple.of((Object)color, (Object)((Potion)potion.getInternal()), (Object)weight));
    }

    @ZenMethod
    public static void removeWeightedPotion(String dyeColor, IPotion potion) {
        EnumDyeColor color = EnumDyeColor.valueOf((String)dyeColor.toUpperCase(Locale.ENGLISH));
        Validate.notNull((Object)color, (String)"Invalid EnumDyeColor %s!", (Object[])new Object[]{dyeColor});
        Validate.isTrue((potion.getInternal() != null && potion.getInternal() instanceof Potion ? 1 : 0) != 0, (String)"Invalid potion %s!", (Object[])new Object[]{potion});
        removals.add((Pair<EnumDyeColor, Potion>)Pair.of((Object)color, (Object)((Potion)potion.getInternal())));
    }

    @ZenMethod
    public static void clearWeightedList(String dyeColor) {
        EnumDyeColor color = EnumDyeColor.valueOf((String)dyeColor.toUpperCase(Locale.ENGLISH));
        Validate.notNull((Object)color, (String)"Invalid EnumDyeColor %s!", (Object[])new Object[]{dyeColor});
        clears.add(color);
    }

    public static void processCauldronChanges() {
        for (EnumDyeColor enumDyeColor : clears) {
            ColorToPotionUtil.MAP.getPotionList(enumDyeColor).clear();
        }
        for (Pair pair : removals) {
            ColorToPotionWeightedMap.WeightedPotion pot = null;
            List<ColorToPotionWeightedMap.WeightedPotion> list = ColorToPotionUtil.MAP.getPotionList((EnumDyeColor)pair.getLeft());
            for (ColorToPotionWeightedMap.WeightedPotion wp : list) {
                if (wp.getPotion().delegate.get() != ((Potion)pair.getRight()).delegate.get()) continue;
                pot = wp;
                break;
            }
            if (pot != null) {
                list.remove((Object)pot);
                continue;
            }
            CraftTweakerAPI.logError((String)("[Plants] Tried to remove a weighted potion entry, but no entry was found. Color: " + pair.getLeft() + ", Potion: " + ((Potion)pair.getRight()).getRegistryName()));
        }
        for (Triple triple : additions) {
            ColorToPotionUtil.MAP.getPotionList((EnumDyeColor)triple.getLeft()).add(new ColorToPotionWeightedMap.WeightedPotion((Potion)triple.getMiddle(), (Integer)triple.getRight()));
        }
        for (Map.Entry entry : ColorToPotionUtil.MAP.entrySet()) {
            if (!((List)entry.getValue()).isEmpty()) continue;
            throw new RuntimeException("[Plants] All WeightedPotions have been removed from the " + entry.getKey() + " list, this is not allowed!");
        }
        additions = null;
        removals = null;
        clears = null;
    }
}

