/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFlowerPot;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.client.IHasModel;
import shadows.placebo.client.RenamedStateMapper;
import shadows.placebo.interfaces.IItemBlock;
import shadows.placebo.util.PlaceboUtil;
import shadows.placebo.util.VanillaPacketDispatcher;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumHarvestBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.state.FlowerpotBlockState;
import shadows.plants2.tile.TileFlowerpot;

public class BlockFlowerpot
extends BlockFlowerPot
implements IHasModel,
IItemBlock {
    public BlockFlowerpot() {
        PlaceboUtil.setRegNameIllegally((IForgeRegistryEntry)this, (String)"flower_pot");
        this.func_149663_c("plants2.flowerpot");
        this.func_149647_a(CreativeTabs.field_78031_c);
        if (PlantConfig.flowerpot) {
            Plants2.INFO.getBlockList().add((Object)this);
            Plants2.INFO.getItemList().add((Object)this.createItemBlock());
        }
    }

    BlockFlowerpot(String name) {
        this.setRegistryName("plants2", name);
        this.func_149663_c("plants2." + name);
        this.func_149647_a(Plants2.INFO.getDefaultTab());
        Plants2.INFO.getBlockList().add((Object)this);
        Plants2.INFO.getItemList().add((Object)this.createItemBlock());
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        TileFlowerpot pot;
        super.func_176208_a(world, pos, state, player);
        if (player.field_71075_bZ.field_75098_d && (pot = BlockFlowerpot.getTileEntity((IBlockAccess)world, pos)) != null) {
            pot.setState(Blocks.field_150350_a.func_176223_P());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initModels(ModelRegistryEvent e) {
        PlaceboUtil.sMRL((String)"plants2", (String)"flowerpot", (Block)this, (int)0, (String)"inventory");
        PlaceboUtil.sMRL((String)"plants2", (String)"flowerpot", (Block)this, (int)5444, (String)"cactus");
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new RenamedStateMapper("plants2", "flowerpot", "", "normal"));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState flowerpotState, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        ItemStack held = player.func_184586_b(hand);
        TileFlowerpot pot = BlockFlowerpot.getTileEntity((IBlockAccess)world, pos);
        if (pot == null) {
            return false;
        }
        ItemStack flowerpot = pot.func_184403_b();
        if (flowerpot.func_190926_b()) {
            IBlockState toUse = Block.func_149634_a((Item)held.func_77973_b()).getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, held.func_77960_j(), (EntityLivingBase)player, hand);
            if (toUse.func_177230_c() == Blocks.field_150350_a && held.func_77973_b() instanceof IPlantable) {
                toUse = ((IPlantable)held.func_77973_b()).getPlant((IBlockAccess)world, pos);
            }
            if (toUse.func_177230_c() != this && (toUse.func_177230_c() == Blocks.field_150350_a || toUse.func_177230_c().hasTileEntity(toUse))) {
                return false;
            }
            if (BlockEnumHarvestBush.FRUIT.equals((Object)toUse.func_177230_c().func_176194_O().func_185920_a("fruit"))) {
                toUse = toUse.func_177226_a((IProperty)BlockEnumHarvestBush.FRUIT, (Comparable)Boolean.valueOf(true));
            }
            pot.setState(toUse);
            ItemStack copy = held.func_77946_l();
            copy.func_190920_e(1);
            pot.func_190614_a(copy);
            if (!player.field_71075_bZ.field_75098_d) {
                held.func_190918_g(1);
            }
        } else if (player.func_191521_c(pot.func_184403_b())) {
            pot.setState(Blocks.field_150350_a.func_176223_P());
            pot.func_190614_a(ItemStack.field_190927_a);
        }
        pot.func_70296_d();
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)pot);
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack((Block)this));
        if (BlockFlowerpot.getTileEntity(world, pos) != null) {
            drops.add((Object)BlockFlowerpot.getTileEntity(world, pos).func_184403_b());
        }
    }

    public static double getDouble(Random rand) {
        return MathHelper.func_82716_a((Random)rand, (double)-0.05, (double)0.05);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileFlowerpot();
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176223_P());
    }

    public ItemBlock createItemBlock() {
        ItemBlock k = new ItemBlock((Block)this);
        PlaceboUtil.setRegNameIllegally((IForgeRegistryEntry)k, (String)"flower_pot");
        return k;
    }

    public BlockStateContainer func_180661_e() {
        return new FlowerpotBlockState((Block)this, new IProperty[0], new IUnlistedProperty[]{UnlistedStateProperty.UNLISTED_STATE});
    }

    @Nullable
    private static TileFlowerpot getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        return tileentity instanceof TileFlowerpot ? (TileFlowerpot)tileentity : null;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileFlowerpot t = BlockFlowerpot.getTileEntity(world, pos);
        if (t != null && state instanceof IExtendedBlockState) {
            return ((IExtendedBlockState)state).withProperty((IUnlistedProperty)UnlistedStateProperty.UNLISTED_STATE, (Object)t.getState());
        }
        return state;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return state;
    }

    public ItemStack func_185473_a(World world, BlockPos pos, IBlockState state) {
        TileFlowerpot t = BlockFlowerpot.getTileEntity((IBlockAccess)world, pos);
        if (t != null && !t.getStack().func_190926_b()) {
            return t.getStack();
        }
        return new ItemStack((Block)this);
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileFlowerpot t = BlockFlowerpot.getTileEntity((IBlockAccess)world, pos);
        if (t == null || t.getState().func_177230_c() == this) {
            return;
        }
        t.getState().func_177230_c().func_180655_c(t.getState(), world, pos, rand);
    }

    public static class UnlistedStateProperty
    implements IUnlistedProperty<IBlockState> {
        public static final UnlistedStateProperty UNLISTED_STATE = new UnlistedStateProperty();

        public String getName() {
            return "pot_state";
        }

        public boolean isValid(IBlockState value) {
            return true;
        }

        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        public String valueToString(IBlockState value) {
            return value.toString();
        }
    }
}

