/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import shadows.placebo.Placebo;
import shadows.placebo.block.BlockEnum;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.interfaces.ITreeEnum;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.PlaceboUtil;
import shadows.plants2.Plants2;

public class BlockEnumLog<E extends Enum<E>>
extends BlockEnum<E>
implements IHasRecipe {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);

    public BlockEnumLog(String name, SoundType s, float hard, float res, Class<E> enumClass, int predicate) {
        super(name, Material.field_151575_d, s, hard, res, enumClass, "type", e -> ((ITreeEnum)e).getPredicateIndex() == predicate, (RegistryInformation)Plants2.INFO);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.property, (Comparable)this.types.get(0)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y));
    }

    public BlockEnumLog(String name, Class<E> enumClass, int predicate) {
        this(name, SoundType.field_185848_a, 2.0f, 1.0f, enumClass, predicate);
    }

    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, AXIS});
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_175707_a(pos.func_177982_a(-5, -5, -5), pos.func_177982_a(5, 5, 5))) {
            for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-4, -4, -4), (BlockPos)pos.func_177982_a(4, 4, 4))) {
                IBlockState iblockstate = worldIn.func_180495_p(blockpos);
                if (!iblockstate.func_177230_c().isLeaves(iblockstate, (IBlockAccess)worldIn, blockpos)) continue;
                iblockstate.func_177230_c().beginLeavesDecay(iblockstate, worldIn, blockpos);
            }
        }
    }

    public String func_149739_a() {
        return "tile.plants2.log";
    }

    public boolean canSustainLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public boolean isWood(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)this.types.get(meta % 5)).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.values()[meta / 5]);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)this.types.get(MathHelper.func_76125_a((int)meta, (int)0, (int)this.types.size()))).func_177226_a(AXIS, (Comparable)facing.func_176740_k());
    }

    public int func_180651_a(IBlockState state) {
        return ((ITreeEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getMetadata();
    }

    public int func_176201_c(IBlockState state) {
        int i = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 5;
        return i += ((EnumFacing.Axis)state.func_177229_b(AXIS)).ordinal() * 5;
    }

    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.types.size(); ++i) {
            PlaceboUtil.sMRL((String)"logs", (Block)this, (int)i, (String)(AXIS.func_177701_a() + "=" + BlockLog.EnumAxis.Y.func_176610_l() + "," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l()));
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "logs");
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
        GameRegistry.addSmelting((ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE), (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)2.0f);
    }

    public String getHarvestTool(IBlockState state) {
        return "axe";
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 5;
    }
}

