/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockFarmland;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import shadows.placebo.Placebo;
import shadows.plants2.block.BlockEnumBush;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.init.ModRegistry;

public class BlockEnumCrop<E extends Enum<E>>
extends BlockEnumBush<E>
implements IGrowable {
    public static final PropertyInteger AGE = BlockCrops.field_176488_a;
    public static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.875, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};
    private final Item[] crops;
    private final Item[] seeds;

    public BlockEnumCrop(String name, Class<E> enumClass, int predicate, Item crop1, Item crop2, Item seed1, Item seed2) {
        super(name, EnumPlantType.Crop, enumClass, predicate);
        this.crops = new Item[]{crop1, crop2};
        this.seeds = new Item[]{seed1, seed2};
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
    }

    @Override
    public IBlockState getStateFor(E e) {
        return super.getStateFor(e).func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7));
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)AGE)];
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if ((Integer)state.func_177229_b((IProperty)AGE) != 7 || !(world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockFarmland)) {
            return false;
        }
        for (ItemStack s : this.getActualDrops((IBlockAccess)world, pos, state, 1594)) {
            if (player.func_191521_c(s) || world.field_72995_K) continue;
            Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)s);
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(0)));
        return true;
    }

    @Override
    public ItemBlock createItemBlock() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(this.seeds[((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 2]);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.crops[((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 2];
    }

    public boolean func_176473_a(World world, BlockPos pos, IBlockState state, boolean isClient) {
        return (Integer)state.func_177229_b((IProperty)AGE) < 7;
    }

    public boolean func_180670_a(World world, Random rand, BlockPos pos, IBlockState state) {
        return this.func_176473_a(world, pos, state, false);
    }

    public void func_176474_b(World world, Random rand, BlockPos pos, IBlockState state) {
        int age = (Integer)state.func_177229_b((IProperty)AGE);
        int grow = MathHelper.func_76136_a((Random)rand, (int)1, (int)3);
        if (age < 7) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age + grow <= 7 ? age + grow : 7)));
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && this.func_176473_a(world, pos, state, false)) {
            boolean couldGrow;
            boolean bl = couldGrow = rand.nextInt(PlantConfig.cropGrowthChance) == 0;
            if (ForgeHooks.onCropsGrowPre((World)world, (BlockPos)pos, (IBlockState)state, (boolean)couldGrow)) {
                this.func_176474_b(world, rand, pos, state);
                ForgeHooks.onCropsGrowPost((World)world, (BlockPos)pos, (IBlockState)state, (IBlockState)world.func_180495_p(pos));
            }
        }
    }

    @Override
    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, this.getInvProperty(), AGE});
    }

    @Override
    public void initModels(ModelRegistryEvent e) {
        Placebo.PROXY.useRenamedMapper((Block)this, "crops");
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)this.types.get(meta / 8));
        if (meta >= 8) {
            meta -= 8;
        }
        state = state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
        return state;
    }

    @Override
    public int func_176201_c(IBlockState state) {
        int i = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 2;
        i *= 8;
        return i += ((Integer)state.func_177229_b((IProperty)AGE)).intValue();
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 2;
    }

    @Override
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
    }

    @Override
    public List<ItemStack> getActualDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> k = new ArrayList<ItemStack>();
        int i = ((Enum)((Object)state.func_177229_b((IProperty)this.property))).ordinal() % 2;
        if (fortune != 1594) {
            k.add(new ItemStack(this.seeds[i]));
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7) {
            k.add(new ItemStack(this.crops[i]));
        }
        if ((Integer)state.func_177229_b((IProperty)AGE) == 7 && RANDOM.nextInt(4) == 0) {
            k.add(new ItemStack(this.seeds[i]));
        }
        return k;
    }

    @Override
    public boolean placeStateAt(IBlockState state, World world, BlockPos pos) {
        return world.func_175656_a(pos, state.func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(7)));
    }

    @Override
    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return super.func_176196_c(world, pos) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, ModRegistry.PLANT_0);
    }

    @Override
    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, ModRegistry.PLANT_0);
    }

    @Override
    protected void addStatesToList() {
        if (PlantConfig.harvests) {
            super.addStatesToList();
        }
    }
}

