/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.biome;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.WorldGenAbstractTree;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.plants2.Plants2;
import shadows.plants2.biome.AbstractBiomeBase;
import shadows.plants2.data.PlantConfig;
import shadows.plants2.data.enums.TheBigBookOfEnums;
import shadows.plants2.gen.WorldGenCrystals;
import shadows.plants2.init.ModRegistry;

public class BiomeCrystalForest
extends AbstractBiomeBase {
    static final WorldGenerator CRYSTALS = new WorldGenCrystals();

    public BiomeCrystalForest() {
        super("crystal_forest", new Biome.BiomeProperties("Crystal Forest").func_185410_a(0.8f).func_185395_b(0.2f).func_185400_d(0.1f).func_185398_c(0.3f));
        this.field_76762_K.clear();
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySkeleton.class, 10, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityCreeper.class, 3, 1, 1));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySpider.class, 7, 1, 2));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntityRabbit.class, 5, 2, 5));
        this.field_76762_K.add(new Biome.SpawnListEntry(EntitySilverfish.class, 1, 1, 1));
        this.field_76753_B = ModRegistry.GROUNDCOVER.func_176223_P();
        this.field_76752_A = ModRegistry.GROUNDCOVER.func_176223_P();
        this.field_76760_I.field_76832_z = 4;
        this.field_76760_I.field_76802_A = 0;
        this.field_76760_I.field_76803_B = 15;
        this.flowers.clear();
        this.flowers.add(new Biome.FlowerEntry(ModRegistry.CRYSTAL.getStateFor((Enum)TheBigBookOfEnums.Crystals.CRYSTAL_SHARD), 60));
        this.flowers.add(new Biome.FlowerEntry(ModRegistry.CRYSTAL.getStateFor((Enum)TheBigBookOfEnums.Crystals.DARK_CRYSTAL_SHARD), 40));
        Plants2.INFO.getBiomeList().add((Object)this);
    }

    public WorldGenAbstractTree func_150567_a(Random rand) {
        return rand.nextFloat() >= 0.73f ? ModRegistry.DARK_CRYSTAL_TREE : ModRegistry.CRYSTAL_TREE;
    }

    public void plantFlower(World world, Random rand, BlockPos pos) {
        Biome.FlowerEntry flower = (Biome.FlowerEntry)WeightedRandom.func_76271_a((Random)rand, (List)this.flowers);
        if (flower != null) {
            world.func_180501_a(pos, flower.state, 3);
        }
    }

    public WorldGenerator func_76730_b(Random rand) {
        return CRYSTALS;
    }

    @Override
    public void register(IForgeRegistry<Biome> reg) {
        if (PlantConfig.crystalForest) {
            reg.register((IForgeRegistryEntry)this);
            if (PlantConfig.crystalForestWeight > 0) {
                BiomeManager.addBiome((BiomeManager.BiomeType)BiomeManager.BiomeType.COOL, (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry((Biome)this, PlantConfig.crystalForestWeight));
                BiomeManager.addSpawnBiome((Biome)this);
            }
        }
    }
}

